/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.filterspec;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprIdentNodeEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityMake;
import com.espertech.esper.common.internal.filterspec.FilterSpecParam;
import com.espertech.esper.common.internal.filterspec.FilterSpecParamInValueForge;
import com.espertech.esper.common.internal.filterspec.MatchedEventMap;
import com.espertech.esper.common.internal.util.JavaClassHelper;

public class FilterForEvalEventPropForge
implements FilterSpecParamInValueForge {
    private final String resultEventAsName;
    private final String resultEventProperty;
    private final ExprIdentNodeEvaluator exprIdentNodeEvaluator;
    private final boolean isMustCoerce;
    private final EPTypeClass coercionType;

    public FilterForEvalEventPropForge(String resultEventAsName, String resultEventProperty, ExprIdentNodeEvaluator exprIdentNodeEvaluator, boolean isMustCoerce, EPTypeClass coercionType) {
        this.resultEventAsName = resultEventAsName;
        this.resultEventProperty = resultEventProperty;
        this.exprIdentNodeEvaluator = exprIdentNodeEvaluator;
        this.coercionType = coercionType;
        this.isMustCoerce = isMustCoerce;
    }

    @Override
    public EPType getReturnType() {
        return this.coercionType;
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public final Object getFilterValue(MatchedEventMap matchedEvents, ExprEvaluatorContext evaluatorContext) {
        throw ExprNodeUtilityMake.makeUnsupportedCompileTime();
    }

    public final String toString() {
        return "resultEventProp=" + this.resultEventAsName + '.' + this.resultEventProperty;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FilterForEvalEventPropForge)) {
            return false;
        }
        FilterForEvalEventPropForge other = (FilterForEvalEventPropForge)obj;
        return other.resultEventAsName.equals(this.resultEventAsName) && other.resultEventProperty.equals(this.resultEventProperty);
    }

    public int hashCode() {
        return this.resultEventProperty.hashCode();
    }

    @Override
    public CodegenExpression makeCodegen(CodegenClassScope classScope, CodegenMethodScope parent) {
        CodegenMethod method = parent.makeChild(EPTypePremade.OBJECT.getEPType(), this.getClass(), (CodegenScope)classScope).addParam(FilterSpecParam.GET_FILTER_VALUE_FP);
        CodegenExpression get = this.exprIdentNodeEvaluator.getGetter().eventBeanGetCodegen(CodegenExpressionBuilder.ref("event"), method, classScope);
        method.getBlock().declareVar(EventBean.EPTYPE, "event", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("matchedEvents"), "getMatchingEventByTag", CodegenExpressionBuilder.constant(this.resultEventAsName))).ifNull(CodegenExpressionBuilder.ref("event")).blockThrow(CodegenExpressionBuilder.newInstance(EPTypePremade.ILLEGALSTATEEXCEPTION.getEPType(), CodegenExpressionBuilder.constant("Matching event named '" + this.resultEventAsName + "' not found in event result set"))).declareVar(EPTypePremade.OBJECT.getEPType(), "value", get);
        if (this.isMustCoerce) {
            method.getBlock().assignRef("value", JavaClassHelper.coerceNumberBoxedToBoxedCodegen(CodegenExpressionBuilder.cast(EPTypePremade.NUMBER.getEPType(), (CodegenExpression)CodegenExpressionBuilder.ref("value")), EPTypePremade.NUMBER.getEPType(), this.coercionType));
        }
        method.getBlock().methodReturn(CodegenExpressionBuilder.ref("value"));
        return CodegenExpressionBuilder.localMethod(method, FilterSpecParam.GET_FILTER_VALUE_REFS);
    }

    @Override
    public void valueToString(StringBuilder out) {
        out.append("property '").append(this.resultEventProperty).append("'");
        if (this.resultEventAsName != null) {
            out.append(" of '").append(this.resultEventAsName).append("'");
        }
    }
}

