/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.filterspec;

import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.epl.expression.core.ExprFilterSpecLookupable;
import com.espertech.esper.common.internal.filterspec.FilterOperator;
import com.espertech.esper.common.internal.filterspec.FilterSpecParam;
import com.espertech.esper.common.internal.filterspec.FilterValueSetParam;
import java.io.StringWriter;

public class FilterValueSetParamImpl
implements FilterValueSetParam {
    public static final EPTypeClass EPTYPE = new EPTypeClass(FilterValueSetParamImpl.class);
    private final ExprFilterSpecLookupable lookupable;
    private final FilterOperator filterOperator;
    private final Object filterValue;

    public FilterValueSetParamImpl(ExprFilterSpecLookupable lookupable, FilterOperator filterOperator, Object filterValue) {
        this.lookupable = lookupable;
        this.filterOperator = filterOperator;
        this.filterValue = filterValue;
    }

    public static CodegenExpression codegenNew(CodegenExpression filterForValue) {
        return CodegenExpressionBuilder.newInstance(EPTYPE, FilterSpecParam.REF_LOOKUPABLE, FilterSpecParam.REF_FILTEROPERATOR, filterForValue);
    }

    @Override
    public ExprFilterSpecLookupable getLookupable() {
        return this.lookupable;
    }

    @Override
    public FilterOperator getFilterOperator() {
        return this.filterOperator;
    }

    @Override
    public Object getFilterForValue() {
        return this.filterValue;
    }

    public String toString() {
        return "FilterValueSetParamImpl{lookupable='" + this.lookupable + '\'' + ", filterOperator=" + (Object)((Object)this.filterOperator) + ", filterValue=" + this.filterValue + '}';
    }

    @Override
    public void appendTo(StringWriter writer) {
        this.lookupable.appendTo(writer);
        writer.append(this.filterOperator.getTextualOp());
        writer.append(this.filterValue == null ? "null" : this.filterValue.toString());
    }
}

