/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.filterspec;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.context.aifactory.core.SAIFFInitializeSymbol;
import com.espertech.esper.common.internal.event.core.EventTypeUtility;
import java.util.HashMap;
import java.util.Map;

public final class MatchedEventMapMeta {
    public static final EPTypeClass EPTYPE = new EPTypeClass(MatchedEventMapMeta.class);
    private static final int MIN_MAP_LOOKUP = 3;
    private final String[] tagsPerIndex;
    private final EventType[] eventTypes;
    private final String[] arrayTags;
    private final Map<String, Integer> tagsPerIndexMap;

    public MatchedEventMapMeta(String[] tagsPerIndex, EventType[] eventTypes, String[] arrayTags) {
        this.tagsPerIndex = tagsPerIndex;
        this.eventTypes = eventTypes;
        this.arrayTags = arrayTags;
        this.tagsPerIndexMap = this.getMap(tagsPerIndex);
    }

    public String[] getTagsPerIndex() {
        return this.tagsPerIndex;
    }

    public EventType[] getEventTypes() {
        return this.eventTypes;
    }

    public int getTagFor(String key) {
        if (this.tagsPerIndexMap != null) {
            Integer result = this.tagsPerIndexMap.get(key);
            return result == null ? -1 : result;
        }
        for (int i = 0; i < this.tagsPerIndex.length; ++i) {
            if (!this.tagsPerIndex[i].equals(key)) continue;
            return i;
        }
        return -1;
    }

    private Map<String, Integer> getMap(String[] tagsPerIndex) {
        if (tagsPerIndex.length < 3) {
            return null;
        }
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (int i = 0; i < tagsPerIndex.length; ++i) {
            map.put(tagsPerIndex[i], i);
        }
        return map;
    }

    public boolean isHasArrayProperties() {
        return this.arrayTags != null;
    }

    public String[] getArrayTags() {
        return this.arrayTags;
    }

    public CodegenMethod makeCodegen(CodegenClassScope classScope, CodegenMethodScope parent, SAIFFInitializeSymbol symbols) {
        CodegenMethod method = parent.makeChild(EPTYPE, this.getClass(), (CodegenScope)classScope);
        method.getBlock().declareVar(EPTypePremade.STRINGARRAY.getEPType(), "tagsPerIndex", CodegenExpressionBuilder.constant(this.tagsPerIndex)).declareVar(EventType.EPTYPEARRAY, "eventTypes", EventTypeUtility.resolveTypeArrayCodegen(this.eventTypes, symbols.getAddInitSvc(method))).methodReturn(CodegenExpressionBuilder.newInstance(EPTYPE, CodegenExpressionBuilder.ref("tagsPerIndex"), CodegenExpressionBuilder.ref("eventTypes"), CodegenExpressionBuilder.constant(this.arrayTags)));
        return method;
    }

    public Object getEventTypeForTag(String tag) {
        return this.eventTypes[this.getTagFor(tag)];
    }

    public String[] getNonArrayTags() {
        if (!this.isHasArrayProperties()) {
            return this.tagsPerIndex;
        }
        String[] result = new String[this.tagsPerIndex.length - this.arrayTags.length];
        int count = 0;
        for (int i = 0; i < this.tagsPerIndex.length; ++i) {
            boolean isArray = false;
            for (int j = 0; j < this.arrayTags.length; ++j) {
                if (!this.arrayTags[j].equals(this.tagsPerIndex[i])) continue;
                isArray = true;
                break;
            }
            if (isArray) continue;
            result[count++] = this.tagsPerIndex[i];
        }
        return result;
    }
}

