/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.metrics.stmtmetrics;

import com.espertech.esper.common.internal.metrics.stmtmetrics.MetricExec;
import com.espertech.esper.common.internal.metrics.stmtmetrics.MetricTimeSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MetricScheduleService
implements MetricTimeSource {
    private static final Logger log = LoggerFactory.getLogger(MetricScheduleService.class);
    private final SortedMap<Long, List<MetricExec>> timeHandleMap = new TreeMap<Long, List<MetricExec>>();
    private volatile Long currentTime;
    private volatile Long nearestTime;

    @Override
    public long getCurrentTime() {
        return this.currentTime;
    }

    public void clear() {
        log.debug("Clearing scheduling service");
        this.timeHandleMap.clear();
        this.nearestTime = null;
    }

    public final synchronized void setTime(long currentTime) {
        this.currentTime = currentTime;
    }

    public final synchronized void add(long afterMSec, MetricExec execution) {
        if (execution == null) {
            throw new IllegalArgumentException("Unexpected parameters : null execution");
        }
        long triggerOnTime = this.currentTime + afterMSec;
        ArrayList<MetricExec> handleSet = (ArrayList<MetricExec>)this.timeHandleMap.get(triggerOnTime);
        if (handleSet == null) {
            handleSet = new ArrayList<MetricExec>();
            this.timeHandleMap.put(triggerOnTime, handleSet);
        }
        handleSet.add(execution);
        this.nearestTime = this.timeHandleMap.firstKey();
    }

    public final synchronized void evaluate(Collection<MetricExec> handles) {
        SortedMap<Long, List<MetricExec>> headMap = this.timeHandleMap.headMap(this.currentTime + 1L);
        LinkedList<Long> removeKeys = new LinkedList<Long>();
        for (Map.Entry<Long, List<MetricExec>> entry : headMap.entrySet()) {
            Long key = entry.getKey();
            List<MetricExec> value = entry.getValue();
            removeKeys.add(key);
            for (MetricExec handle : value) {
                handles.add(handle);
            }
        }
        for (Long key : removeKeys) {
            this.timeHandleMap.remove(key);
        }
        this.nearestTime = !this.timeHandleMap.isEmpty() ? this.timeHandleMap.firstKey() : null;
    }

    public Long getNearestTime() {
        return this.nearestTime;
    }

    public void remove(MetricExec metricExec) {
        for (Map.Entry<Long, List<MetricExec>> entry : this.timeHandleMap.entrySet()) {
            entry.getValue().remove(metricExec);
        }
    }
}

