/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.metrics.stmtmetrics;

import com.espertech.esper.common.internal.metrics.stmtmetrics.MetricExec;
import com.espertech.esper.common.internal.metrics.stmtmetrics.MetricExecutionContext;
import com.espertech.esper.common.internal.metrics.stmtmetrics.MetricsExecutor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsExecutorThreaded
implements MetricsExecutor {
    private static final Logger log = LoggerFactory.getLogger(MetricsExecutorThreaded.class);
    private final ExecutorService threadPool;

    public MetricsExecutorThreaded(final String runtimeURI) {
        ThreadFactory threadFactory = new ThreadFactory(){
            AtomicInteger count = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                String uri = runtimeURI;
                if (runtimeURI == null) {
                    uri = "default";
                }
                Thread t = new Thread(r);
                t.setName("com.espertech.esper.MetricReporting-" + uri + "-" + this.count.getAndIncrement());
                t.setDaemon(true);
                return t;
            }
        };
        this.threadPool = Executors.newCachedThreadPool(threadFactory);
    }

    @Override
    public void execute(final MetricExec execution, final MetricExecutionContext executionContext) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                execution.execute(executionContext);
            }
        };
        this.threadPool.execute(runnable);
    }

    @Override
    public void destroy() {
        this.threadPool.shutdownNow();
        try {
            this.threadPool.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            log.error("Interrupted", (Throwable)e);
        }
    }
}

