/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.metrics.stmtmetrics;

import com.espertech.esper.common.client.configuration.runtime.ConfigurationRuntimeMetricsReporting;
import com.espertech.esper.common.client.metric.EPMetricsStatementGroup;
import com.espertech.esper.common.client.metric.StatementMetric;
import com.espertech.esper.common.internal.collection.Pair;
import com.espertech.esper.common.internal.metrics.stmtmetrics.StatementMetricArray;
import com.espertech.esper.common.internal.metrics.stmtmetrics.StatementMetricHandle;
import com.espertech.esper.common.internal.type.StringPatternSet;
import com.espertech.esper.common.internal.type.StringPatternSetUtil;
import com.espertech.esper.common.internal.util.DeploymentIdNamePair;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class StatementMetricRepository {
    private final ConfigurationRuntimeMetricsReporting specification;
    private final StatementMetricArray[] groupMetrics;
    private final Map<DeploymentIdNamePair, Integer> statementGroups;

    public StatementMetricRepository(String runtimeURI, ConfigurationRuntimeMetricsReporting specification) {
        this.specification = specification;
        int numGroups = specification.getStatementGroups().size() + 1;
        this.groupMetrics = new StatementMetricArray[numGroups];
        this.groupMetrics[0] = new StatementMetricArray(runtimeURI, "group-default", 100, false);
        int countGroups = 1;
        for (Map.Entry<String, ConfigurationRuntimeMetricsReporting.StmtGroupMetrics> entry : specification.getStatementGroups().entrySet()) {
            ConfigurationRuntimeMetricsReporting.StmtGroupMetrics config = entry.getValue();
            int initialNumStmts = config.getNumStatements();
            if (initialNumStmts < 10) {
                initialNumStmts = 10;
            }
            this.groupMetrics[countGroups] = new StatementMetricArray(runtimeURI, "group-" + countGroups, initialNumStmts, config.isReportInactive());
            ++countGroups;
        }
        this.statementGroups = new HashMap<DeploymentIdNamePair, Integer>();
    }

    public StatementMetricHandle addStatement(DeploymentIdNamePair statement) {
        int countGroups = 1;
        int groupNumber = -1;
        for (Map.Entry<String, ConfigurationRuntimeMetricsReporting.StmtGroupMetrics> entry : this.specification.getStatementGroups().entrySet()) {
            List<Pair<StringPatternSet, Boolean>> patterns = entry.getValue().getPatterns();
            boolean result = StringPatternSetUtil.evaluate(entry.getValue().isDefaultInclude(), patterns, statement.getName());
            if (result) {
                groupNumber = countGroups;
                break;
            }
            ++countGroups;
        }
        if (groupNumber == -1) {
            groupNumber = 0;
        }
        int index = this.groupMetrics[groupNumber].addStatementGetIndex(statement);
        this.statementGroups.put(statement, groupNumber);
        return new StatementMetricHandle(groupNumber, index);
    }

    public void removeStatement(DeploymentIdNamePair statement) {
        Integer group = this.statementGroups.remove(statement);
        if (group != null) {
            this.groupMetrics[group].removeStatement(statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accountTimes(StatementMetricHandle handle, long cpu, long wall, int numInput) {
        StatementMetricArray array = this.groupMetrics[handle.getGroupNum()];
        array.getRwLock().acquireReadLock();
        try {
            StatementMetric metric = array.getAddMetric(handle.getIndex());
            metric.addCPUTime(cpu);
            metric.addWallTime(wall);
            metric.addNumInput(numInput);
        }
        finally {
            array.getRwLock().releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accountOutput(StatementMetricHandle handle, int numIStream, int numRStream) {
        StatementMetricArray array = this.groupMetrics[handle.getGroupNum()];
        array.getRwLock().acquireReadLock();
        try {
            StatementMetric metric = array.getAddMetric(handle.getIndex());
            metric.addNumOutputIStream(numIStream);
            metric.addNumOutputRStream(numRStream);
        }
        finally {
            array.getRwLock().releaseReadLock();
        }
    }

    public StatementMetric[] reportGroup(int group) {
        return this.groupMetrics[group].flushMetrics();
    }

    public void iterateMetrics(Consumer<EPMetricsStatementGroup> consumer) {
        for (int i = 0; i < this.groupMetrics.length; ++i) {
            StatementMetricArray array = this.groupMetrics[i];
            consumer.accept(new EPMetricsStatementGroup(array));
        }
    }
}

