/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.rettype;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypeClassParameterized;
import com.espertech.esper.common.client.type.EPTypeNull;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.compile.stage2.StatementRawInfo;
import com.espertech.esper.common.internal.compile.stage3.StatementCompileTimeServices;
import com.espertech.esper.common.internal.epl.expression.core.ExprEnumerationForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.rettype.EPChainableType;
import com.espertech.esper.common.internal.rettype.EPChainableTypeClass;
import com.espertech.esper.common.internal.rettype.EPChainableTypeEventMulti;
import com.espertech.esper.common.internal.rettype.EPChainableTypeEventSingle;
import com.espertech.esper.common.internal.rettype.EPChainableTypeNull;
import com.espertech.esper.common.internal.util.ClassHelperGenericType;
import com.espertech.esper.common.internal.util.ClassHelperPrint;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.lang.reflect.Method;
import java.util.Collection;

public class EPChainableTypeHelper {
    public static EventType getEventTypeMultiValued(EPChainableType type) {
        if (type instanceof EPChainableTypeEventMulti) {
            return ((EPChainableTypeEventMulti)type).getComponent();
        }
        return null;
    }

    public static EPTypeClass getCollectionOrArrayComponentTypeOrNull(EPChainableType type) {
        if (type instanceof EPChainableTypeClass) {
            EPChainableTypeClass classInfo = (EPChainableTypeClass)type;
            if (classInfo.getType().getType().isArray()) {
                return JavaClassHelper.getArrayComponentType(classInfo.getType());
            }
            if (JavaClassHelper.isSubclassOrImplementsInterface((EPType)classInfo.getType(), Collection.class)) {
                return JavaClassHelper.getSingleParameterTypeOrObject(classInfo.getType());
            }
        }
        return null;
    }

    public static boolean isCarryEvent(EPChainableType epType) {
        return epType instanceof EPChainableTypeEventMulti || epType instanceof EPChainableTypeEventSingle;
    }

    public static EventType getEventType(EPChainableType epType) {
        if (epType instanceof EPChainableTypeEventMulti) {
            return ((EPChainableTypeEventMulti)epType).getComponent();
        }
        if (epType instanceof EPChainableTypeEventSingle) {
            return ((EPChainableTypeEventSingle)epType).getType();
        }
        return null;
    }

    public static EPChainableType array(EPTypeClass arrayComponentType) {
        if (arrayComponentType == null) {
            throw new IllegalArgumentException("Invalid null array component type");
        }
        EPTypeClass array = JavaClassHelper.getArrayType(arrayComponentType);
        return new EPChainableTypeClass(array);
    }

    public static EPChainableTypeClass singleValueNonNull(EPType typeClass) {
        if (typeClass == null || typeClass == EPTypeNull.INSTANCE) {
            throw new IllegalArgumentException("Null-type not supported as a return type");
        }
        return new EPChainableTypeClass((EPTypeClass)typeClass);
    }

    public static EPChainableType singleValue(EPType singleValueType) {
        if (singleValueType == EPTypeNull.INSTANCE) {
            return EPChainableTypeNull.INSTANCE;
        }
        return new EPChainableTypeClass((EPTypeClass)singleValueType);
    }

    public static EPChainableType singleValue(Class clazz) {
        if (clazz == null) {
            return EPChainableTypeNull.INSTANCE;
        }
        return new EPChainableTypeClass(ClassHelperGenericType.getClassEPType(clazz));
    }

    public static EPChainableType nullValue() {
        return EPChainableTypeNull.INSTANCE;
    }

    public static EPChainableType collectionOfSingleValue(EPTypeClass collectionComponentType) {
        if (collectionComponentType == null) {
            throw new IllegalArgumentException("Invalid null collection component type");
        }
        EPTypeClassParameterized typeClass = EPTypeClassParameterized.from(Collection.class, JavaClassHelper.getBoxedType(collectionComponentType));
        return new EPChainableTypeClass(typeClass);
    }

    public static EPChainableType collectionOfEvents(EventType eventTypeOfCollectionEvents) {
        if (eventTypeOfCollectionEvents == null) {
            throw new IllegalArgumentException("Invalid null event type");
        }
        return new EPChainableTypeEventMulti(Collection.class, eventTypeOfCollectionEvents);
    }

    public static EPChainableType arrayOfEvents(EventType eventTypeOfArrayEvents) {
        if (eventTypeOfArrayEvents == null) {
            throw new IllegalArgumentException("Invalid null event type");
        }
        return new EPChainableTypeEventMulti(EventBean[].class, eventTypeOfArrayEvents);
    }

    public static EPChainableType singleEvent(EventType eventTypeOfSingleEvent) {
        if (eventTypeOfSingleEvent == null) {
            throw new IllegalArgumentException("Invalid null event type");
        }
        return new EPChainableTypeEventSingle(eventTypeOfSingleEvent);
    }

    public static EPChainableType fromMethod(Method method, EPTypeClass methodTargetType) {
        EPTypeClass type = JavaClassHelper.getBoxedType(ClassHelperGenericType.getMethodReturnEPType(method, methodTargetType));
        return new EPChainableTypeClass(type);
    }

    public static String toTypeDescriptive(EPChainableType epType) {
        if (epType instanceof EPChainableTypeEventSingle) {
            EPChainableTypeEventSingle type = (EPChainableTypeEventSingle)epType;
            return "event type '" + type.getType().getName() + "'";
        }
        if (epType instanceof EPChainableTypeEventMulti) {
            EPChainableTypeEventMulti type = (EPChainableTypeEventMulti)epType;
            if (type.getContainer() == EventType[].class) {
                return "array of events of type '" + type.getComponent().getName() + "'";
            }
            return "collection of events of type '" + type.getComponent().getName() + "'";
        }
        if (epType instanceof EPChainableTypeClass) {
            EPChainableTypeClass type = (EPChainableTypeClass)epType;
            return ClassHelperPrint.getClassNameFullyQualPretty(type.getType());
        }
        if (epType instanceof EPChainableTypeNull) {
            return "null type";
        }
        throw new IllegalArgumentException("Unrecognized type " + epType);
    }

    public static EPType getNormalizedEPType(EPChainableType theType) {
        if (theType instanceof EPChainableTypeEventMulti) {
            EPChainableTypeEventMulti type = (EPChainableTypeEventMulti)theType;
            EPTypeClass underlyingType = type.getComponent().getUnderlyingEPType();
            return JavaClassHelper.getArrayType(underlyingType);
        }
        if (theType instanceof EPChainableTypeEventSingle) {
            EPChainableTypeEventSingle type = (EPChainableTypeEventSingle)theType;
            return EPTypePremade.getOrCreate(type.getType().getUnderlyingType());
        }
        if (theType instanceof EPChainableTypeClass) {
            EPChainableTypeClass type = (EPChainableTypeClass)theType;
            return type.getType();
        }
        if (theType instanceof EPChainableTypeNull) {
            return EPTypeNull.INSTANCE;
        }
        throw new IllegalArgumentException("Unrecognized type " + theType);
    }

    public static EPTypeClass getCodegenReturnType(EPChainableType theType) {
        if (theType instanceof EPChainableTypeEventMulti) {
            EPChainableTypeEventMulti multi = (EPChainableTypeEventMulti)theType;
            if (multi.getContainer().isArray()) {
                return EventBean.EPTYPEARRAY;
            }
            return EPTypeClassParameterized.from(multi.getContainer(), EventBean.EPTYPE);
        }
        if (theType instanceof EPChainableTypeEventSingle) {
            return EventBean.EPTYPE;
        }
        if (theType instanceof EPChainableTypeClass) {
            EPChainableTypeClass type = (EPChainableTypeClass)theType;
            return type.getType();
        }
        if (theType instanceof EPChainableTypeNull) {
            return EPTypePremade.OBJECT.getEPType();
        }
        throw new IllegalArgumentException("Unrecognized type " + theType);
    }

    public static EPChainableType optionalFromEnumerationExpr(StatementRawInfo raw, StatementCompileTimeServices services, ExprNode exprNode) throws ExprValidationException {
        if (!(exprNode instanceof ExprEnumerationForge)) {
            return null;
        }
        ExprEnumerationForge enumInfo = (ExprEnumerationForge)((Object)exprNode);
        if (enumInfo.getComponentTypeCollection() != null) {
            return EPChainableTypeHelper.collectionOfSingleValue(enumInfo.getComponentTypeCollection());
        }
        EventType eventTypeSingle = enumInfo.getEventTypeSingle(raw, services);
        if (eventTypeSingle != null) {
            return EPChainableTypeHelper.singleEvent(eventTypeSingle);
        }
        EventType eventTypeColl = enumInfo.getEventTypeCollection(raw, services);
        if (eventTypeColl != null) {
            return EPChainableTypeHelper.collectionOfEvents(eventTypeColl);
        }
        return null;
    }

    public static EventType optionalIsEventTypeColl(EPChainableType type) {
        if (type instanceof EPChainableTypeEventMulti) {
            return ((EPChainableTypeEventMulti)type).getComponent();
        }
        return null;
    }

    public static EventType optionalIsEventTypeSingle(EPChainableType type) {
        if (type instanceof EPChainableTypeEventSingle) {
            return ((EPChainableTypeEventSingle)type).getType();
        }
        return null;
    }
}

