/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.serde.compiletime.eventtype;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypeNull;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.compile.stage2.StatementRawInfo;
import com.espertech.esper.common.internal.event.core.EventTypeUtility;
import com.espertech.esper.common.internal.event.core.TypeBeanOrUnderlying;
import com.espertech.esper.common.internal.event.json.core.JsonEventType;
import com.espertech.esper.common.internal.event.json.serde.DIOJsonAnyValueSerde;
import com.espertech.esper.common.internal.event.json.serde.DIOJsonArraySerde;
import com.espertech.esper.common.internal.event.json.serde.DIOJsonObjectSerde;
import com.espertech.esper.common.internal.serde.compiletime.eventtype.SerdeEventPropertyDesc;
import com.espertech.esper.common.internal.serde.compiletime.resolve.DataInputOutputSerdeForge;
import com.espertech.esper.common.internal.serde.compiletime.resolve.DataInputOutputSerdeForgeEventSerde;
import com.espertech.esper.common.internal.serde.compiletime.resolve.DataInputOutputSerdeForgeEventSerdeMethod;
import com.espertech.esper.common.internal.serde.compiletime.resolve.DataInputOutputSerdeForgeMap;
import com.espertech.esper.common.internal.serde.compiletime.resolve.DataInputOutputSerdeForgeParameterizedVars;
import com.espertech.esper.common.internal.serde.compiletime.resolve.DataInputOutputSerdeForgeSingleton;
import com.espertech.esper.common.internal.serde.compiletime.resolve.DataInputOutputSerdeForgeSkip;
import com.espertech.esper.common.internal.serde.compiletime.resolve.SerdeCompileTimeResolver;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOSkipSerde;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.function.Function;

public class SerdeEventPropertyUtility {
    public static SerdeEventPropertyDesc forgeForEventProperty(EventType eventTypeSerde, String propertyName, Object propertyType, StatementRawInfo raw, SerdeCompileTimeResolver resolver) {
        if (propertyType == EPTypeNull.INSTANCE) {
            return new SerdeEventPropertyDesc(DataInputOutputSerdeForgeSkip.INSTANCE, Collections.emptySet());
        }
        if (propertyType instanceof EPTypeClass) {
            DataInputOutputSerdeForge forge;
            EPTypeClass epType = (EPTypeClass)propertyType;
            if (eventTypeSerde instanceof JsonEventType) {
                forge = null;
                if (epType.getType() == Map.class) {
                    forge = new DataInputOutputSerdeForgeSingleton(DIOJsonObjectSerde.class);
                } else if (epType.getType() == Object[].class) {
                    forge = new DataInputOutputSerdeForgeSingleton(DIOJsonArraySerde.class);
                } else if (epType.getType() == Object.class) {
                    forge = new DataInputOutputSerdeForgeSingleton(DIOJsonAnyValueSerde.class);
                }
                if (forge != null) {
                    return new SerdeEventPropertyDesc(forge, Collections.emptySet());
                }
            }
            forge = epType.getType() == Object.class && propertyName.equals("internal-reserved") ? new DataInputOutputSerdeForgeSingleton(DIOSkipSerde.class) : resolver.serdeForEventProperty(epType, eventTypeSerde.getName(), propertyName, raw);
            return new SerdeEventPropertyDesc(forge, Collections.emptySet());
        }
        if (propertyType instanceof EventType) {
            EventType eventType = (EventType)propertyType;
            Function<DataInputOutputSerdeForgeParameterizedVars, CodegenExpression> func = vars -> EventTypeUtility.resolveTypeCodegenGivenResolver(eventType, vars.getOptionalEventTypeResolver());
            DataInputOutputSerdeForgeEventSerde forge = new DataInputOutputSerdeForgeEventSerde(DataInputOutputSerdeForgeEventSerdeMethod.NULLABLEEVENT, eventType, func);
            return new SerdeEventPropertyDesc(forge, Collections.singleton(eventType));
        }
        if (propertyType instanceof EventType[]) {
            EventType eventType = ((EventType[])propertyType)[0];
            Function<DataInputOutputSerdeForgeParameterizedVars, CodegenExpression> func = vars -> EventTypeUtility.resolveTypeCodegenGivenResolver(eventType, vars.getOptionalEventTypeResolver());
            DataInputOutputSerdeForgeEventSerde forge = new DataInputOutputSerdeForgeEventSerde(DataInputOutputSerdeForgeEventSerdeMethod.NULLABLEEVENTARRAY, eventType, func);
            return new SerdeEventPropertyDesc(forge, Collections.singleton(eventType));
        }
        if (propertyType instanceof TypeBeanOrUnderlying) {
            EventType eventType = ((TypeBeanOrUnderlying)propertyType).getEventType();
            Function<DataInputOutputSerdeForgeParameterizedVars, CodegenExpression> func = vars -> EventTypeUtility.resolveTypeCodegenGivenResolver(eventType, vars.getOptionalEventTypeResolver());
            DataInputOutputSerdeForgeEventSerde forge = new DataInputOutputSerdeForgeEventSerde(DataInputOutputSerdeForgeEventSerdeMethod.NULLABLEEVENTORUNDERLYING, eventType, func);
            return new SerdeEventPropertyDesc(forge, Collections.singleton(eventType));
        }
        if (propertyType instanceof TypeBeanOrUnderlying[]) {
            EventType eventType = ((TypeBeanOrUnderlying[])propertyType)[0].getEventType();
            Function<DataInputOutputSerdeForgeParameterizedVars, CodegenExpression> func = vars -> EventTypeUtility.resolveTypeCodegenGivenResolver(eventType, vars.getOptionalEventTypeResolver());
            DataInputOutputSerdeForgeEventSerde forge = new DataInputOutputSerdeForgeEventSerde(DataInputOutputSerdeForgeEventSerdeMethod.NULLABLEEVENTARRAYORUNDERLYING, eventType, func);
            return new SerdeEventPropertyDesc(forge, Collections.singleton(eventType));
        }
        if (propertyType instanceof Map) {
            Map kv = (Map)propertyType;
            String[] keys = new String[kv.size()];
            DataInputOutputSerdeForge[] serdes = new DataInputOutputSerdeForge[kv.size()];
            int index = 0;
            LinkedHashSet<EventType> nestedTypes = new LinkedHashSet<EventType>();
            for (Map.Entry entry : kv.entrySet()) {
                String value;
                Class<?> clazz;
                keys[index] = (String)entry.getKey();
                if (entry.getValue() instanceof String && (clazz = JavaClassHelper.getPrimitiveClassForName(value = entry.getValue().toString().trim())) != null) {
                    entry.setValue(clazz);
                }
                SerdeEventPropertyDesc desc = SerdeEventPropertyUtility.forgeForEventProperty(eventTypeSerde, (String)entry.getKey(), entry.getValue(), raw, resolver);
                nestedTypes.addAll(desc.getNestedTypes());
                serdes[index] = desc.getForge();
                ++index;
            }
            DataInputOutputSerdeForgeMap forge = new DataInputOutputSerdeForgeMap(keys, serdes);
            return new SerdeEventPropertyDesc(forge, nestedTypes);
        }
        throw new EPException("Failed to determine serde for unrecognized property value type '" + propertyType + "' for property '" + propertyName + "' of type '" + eventTypeSerde.getName() + "'");
    }
}

