/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.serde.compiletime.resolve;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.hook.expr.EPLMethodInvocationContext;
import com.espertech.esper.common.client.serde.DataInputOutputSerde;
import com.espertech.esper.common.client.serde.SerdeProvider;
import com.espertech.esper.common.client.serde.SerdeProviderAdditionalInfo;
import com.espertech.esper.common.client.serde.SerdeProviderAdditionalInfoAggregation;
import com.espertech.esper.common.client.serde.SerdeProviderAdditionalInfoAggregationDistinct;
import com.espertech.esper.common.client.serde.SerdeProviderAdditionalInfoDerivedViewProperty;
import com.espertech.esper.common.client.serde.SerdeProviderAdditionalInfoEventProperty;
import com.espertech.esper.common.client.serde.SerdeProviderAdditionalInfoEventType;
import com.espertech.esper.common.client.serde.SerdeProviderAdditionalInfoFilter;
import com.espertech.esper.common.client.serde.SerdeProviderAdditionalInfoIndex;
import com.espertech.esper.common.client.serde.SerdeProviderAdditionalInfoMultikey;
import com.espertech.esper.common.client.serde.SerdeProviderAdditionalInfoVariable;
import com.espertech.esper.common.client.serde.SerdeProviderEventTypeContext;
import com.espertech.esper.common.client.serde.SerdeProvision;
import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypeNull;
import com.espertech.esper.common.internal.compile.multikey.MultiKeyPlanner;
import com.espertech.esper.common.internal.compile.stage2.StatementRawInfo;
import com.espertech.esper.common.internal.event.core.BaseNestableEventType;
import com.espertech.esper.common.internal.serde.compiletime.resolve.DataInputOutputSerdeException;
import com.espertech.esper.common.internal.serde.compiletime.resolve.DataInputOutputSerdeForge;
import com.espertech.esper.common.internal.serde.compiletime.resolve.DataInputOutputSerdeForgeSingleton;
import com.espertech.esper.common.internal.serde.compiletime.resolve.DataInputOutputSerdeForgeSingletonBasicBuiltin;
import com.espertech.esper.common.internal.serde.compiletime.resolve.DataInputOutputSerdeForgeSingletonExtendedBuiltin;
import com.espertech.esper.common.internal.serde.compiletime.resolve.DataInputOutputSerdeForgeSingletonMKArray;
import com.espertech.esper.common.internal.serde.compiletime.resolve.DataInputOutputSerdeForgeSkip;
import com.espertech.esper.common.internal.serde.compiletime.resolve.SerdeCompileTimeResolver;
import com.espertech.esper.common.internal.serde.compiletime.resolve.SerdeCompileTimeResolverUtil;
import com.espertech.esper.common.internal.serde.compiletime.resolve.VMBasicBuiltinSerdeFactory;
import com.espertech.esper.common.internal.serde.compiletime.resolve.VMExtendedBuiltinSerdeFactory;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOSkipSerde;
import com.espertech.esper.common.internal.serde.serdeset.multikey.DIOMultiKeyArraySerde;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class SerdeCompileTimeResolverImpl
implements SerdeCompileTimeResolver {
    private final boolean allowExtendedJVM;
    private final boolean allowSerializable;
    private final boolean allowExternalizable;
    private final boolean allowSerializationFallback;
    private final Collection<SerdeProvider> serdeProviders;

    public SerdeCompileTimeResolverImpl(List<SerdeProvider> serdeProviders, boolean allowExtendedJVM, boolean allowSerializable, boolean allowExternalizable, boolean allowSerializationFallback) {
        this.serdeProviders = new CopyOnWriteArrayList<SerdeProvider>(serdeProviders);
        this.allowExtendedJVM = allowExtendedJVM;
        this.allowSerializable = allowSerializable;
        this.allowExternalizable = allowExternalizable;
        this.allowSerializationFallback = allowSerializationFallback;
    }

    @Override
    public boolean isTargetHA() {
        return true;
    }

    @Override
    public DataInputOutputSerdeForge serdeForFilter(EPType evaluationType, StatementRawInfo raw) {
        return this.serdeMayArray(evaluationType, new SerdeProviderAdditionalInfoFilter(raw));
    }

    @Override
    public DataInputOutputSerdeForge serdeForKeyNonArray(EPType paramType, StatementRawInfo raw) {
        return this.serdeForClass(paramType, new SerdeProviderAdditionalInfoMultikey(raw));
    }

    @Override
    public DataInputOutputSerdeForge[] serdeForMultiKey(EPType[] types, StatementRawInfo raw) {
        return this.serdeForClasses(types, new SerdeProviderAdditionalInfoMultikey(raw));
    }

    @Override
    public DataInputOutputSerdeForge[] serdeForDataWindowSortCriteria(EPType[] sortCriteriaExpressions, StatementRawInfo raw) {
        return this.serdeForClasses(sortCriteriaExpressions, new SerdeProviderAdditionalInfoMultikey(raw));
    }

    @Override
    public DataInputOutputSerdeForge serdeForDerivedViewAddProp(EPType evalType, StatementRawInfo raw) {
        return this.serdeForClass(evalType, new SerdeProviderAdditionalInfoDerivedViewProperty(raw));
    }

    @Override
    public DataInputOutputSerdeForge serdeForIndexHashNonArray(EPTypeClass propType, StatementRawInfo raw) {
        return this.serdeForClass(propType, new SerdeProviderAdditionalInfoIndex(raw));
    }

    @Override
    public DataInputOutputSerdeForge serdeForBeanEventType(StatementRawInfo raw, EPTypeClass underlyingType, String eventTypeName, EventType[] eventTypeSupertypes) {
        return this.serdeForClass(underlyingType, new SerdeProviderAdditionalInfoEventType(raw, eventTypeName, eventTypeSupertypes));
    }

    @Override
    public DataInputOutputSerdeForge serdeForEventProperty(EPTypeClass typedProperty, String eventTypeName, String propertyName, StatementRawInfo raw) {
        return this.serdeForClass(typedProperty, new SerdeProviderAdditionalInfoEventProperty(raw, eventTypeName, propertyName));
    }

    @Override
    public DataInputOutputSerdeForge serdeForAggregation(EPType type, StatementRawInfo raw) {
        return this.serdeForClass(type, new SerdeProviderAdditionalInfoAggregation(raw));
    }

    @Override
    public DataInputOutputSerdeForge serdeForAggregationDistinct(EPType type, StatementRawInfo raw) {
        return this.serdeMayArray(type, new SerdeProviderAdditionalInfoAggregationDistinct(raw));
    }

    @Override
    public DataInputOutputSerdeForge serdeForIndexBtree(EPTypeClass rangeType, StatementRawInfo raw) {
        return this.serdeForClass(rangeType, new SerdeProviderAdditionalInfoIndex(raw));
    }

    @Override
    public DataInputOutputSerdeForge serdeForVariable(EPTypeClass type, String variableName, StatementRawInfo raw) {
        return this.serdeForClass(type, new SerdeProviderAdditionalInfoVariable(raw, variableName));
    }

    @Override
    public DataInputOutputSerdeForge serdeForEventTypeExternalProvider(BaseNestableEventType eventType, StatementRawInfo raw) {
        if (this.serdeProviders.isEmpty()) {
            return null;
        }
        SerdeProviderEventTypeContext context = new SerdeProviderEventTypeContext(raw, eventType);
        for (SerdeProvider provider : this.serdeProviders) {
            try {
                SerdeProvision serde = provider.resolveSerdeForEventType(context);
                if (serde == null) continue;
                return serde.toForge();
            }
            catch (DataInputOutputSerdeException ex) {
                throw ex;
            }
            catch (RuntimeException ex) {
                throw new DataInputOutputSerdeException("Unexpected exception invoking serde provider '" + provider.getClass().getName() + "' passing for event type '" + eventType.getName() + "': " + ex.getMessage(), ex);
            }
        }
        return null;
    }

    private DataInputOutputSerdeForge serdeMayArray(EPType type, SerdeProviderAdditionalInfo info) {
        if (type != EPTypeNull.INSTANCE && ((EPTypeClass)type).getType().isArray()) {
            EPTypeClass component = JavaClassHelper.getArrayComponentType((EPTypeClass)type);
            DIOMultiKeyArraySerde mkSerde = MultiKeyPlanner.getMKSerdeClassForComponentType(component);
            return new DataInputOutputSerdeForgeSingletonMKArray(mkSerde.getClass(), mkSerde.componentType().getSimpleName());
        }
        return this.serdeForClass(type, info);
    }

    private DataInputOutputSerdeForge[] serdeForClasses(EPType[] sortCriteriaExpressions, SerdeProviderAdditionalInfo additionalInfo) {
        DataInputOutputSerdeForge[] forges = new DataInputOutputSerdeForge[sortCriteriaExpressions.length];
        for (int i = 0; i < sortCriteriaExpressions.length; ++i) {
            forges[i] = this.serdeForClass(sortCriteriaExpressions[i], additionalInfo);
        }
        return forges;
    }

    private DataInputOutputSerdeForge serdeForClass(EPType type, SerdeProviderAdditionalInfo additionalInfo) {
        DataInputOutputSerde serde;
        if (type == EPTypeNull.INSTANCE) {
            return DataInputOutputSerdeForgeSkip.INSTANCE;
        }
        EPTypeClass typeClass = (EPTypeClass)type;
        if (this.isJVMBasicBuiltin(typeClass.getType())) {
            DataInputOutputSerde serde2 = VMBasicBuiltinSerdeFactory.getSerde(typeClass.getType());
            if (serde2 == null) {
                throw new DataInputOutputSerdeException("Failed to find built-in serde for class " + typeClass.getType().getName());
            }
            return new DataInputOutputSerdeForgeSingletonBasicBuiltin(serde2.getClass(), typeClass);
        }
        if (this.allowExtendedJVM && (serde = VMExtendedBuiltinSerdeFactory.getSerde(typeClass)) != null) {
            return new DataInputOutputSerdeForgeSingletonExtendedBuiltin(serde.getClass(), typeClass);
        }
        if (typeClass.getType() == EPLMethodInvocationContext.class) {
            return new DataInputOutputSerdeForgeSingleton(DIOSkipSerde.class);
        }
        SerdeProvision provision = SerdeCompileTimeResolverUtil.determineSerde(typeClass, this.serdeProviders, this.allowSerializable, this.allowExternalizable, this.allowSerializationFallback, additionalInfo);
        return provision.toForge();
    }

    private boolean isJVMBasicBuiltin(Class type) {
        return JavaClassHelper.isJavaBuiltinDataType(type) && type != BigInteger.class && type != BigDecimal.class;
    }
}

