/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.serde.compiletime.resolve;

import com.espertech.esper.common.client.serde.DataInputOutputSerde;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOBigDecimalArray2DimNullableSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOBigDecimalArrayNullableSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOBigIntegerArray2DimNullableSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOBigIntegerArrayNullableSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOBooleanSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOBoxedBooleanArray2DimNullableSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOBoxedBooleanArrayNullableSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOBoxedByteArray2DimNullableSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOBoxedByteArrayNullableSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOBoxedCharacterArray2DimNullableSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOBoxedCharacterArrayNullableSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOBoxedDoubleArray2DimNullableSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOBoxedDoubleArrayNullableSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOBoxedFloatArray2DimNullableSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOBoxedFloatArrayNullableSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOBoxedIntegerArray2DimNullableSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOBoxedIntegerArrayNullableSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOBoxedLongArray2DimNullableSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOBoxedLongArrayNullableSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOBoxedShortArray2DimNullableSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOBoxedShortArrayNullableSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOByteSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOCharSequenceSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOCharacterSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIODoubleSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOFloatSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOIntegerSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOLongSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIONullableBooleanSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIONullableByteSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIONullableCharacterSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIONullableDoubleSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIONullableFloatSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIONullableIntegerSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIONullableLongSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIONullableShortSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIONullableStringSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOPrimitiveBooleanArray2DimNullableSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOPrimitiveBooleanArrayNullableSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOPrimitiveByteArray2DimNullableSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOPrimitiveByteArrayNullableSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOPrimitiveCharArray2DimNullableSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOPrimitiveCharArrayNullableSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOPrimitiveDoubleArray2DimNullableSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOPrimitiveDoubleArrayNullableSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOPrimitiveFloatArray2DimNullableSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOPrimitiveFloatArrayNullableSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOPrimitiveIntArray2DimNullableSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOPrimitiveIntArrayNullableSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOPrimitiveLongArray2DimNullableSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOPrimitiveLongArrayNullableSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOPrimitiveShortArray2DimNullableSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOPrimitiveShortArrayNullableSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOShortSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOSkipSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOStringArray2DimNullableSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOStringArrayNullableSerde;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;

public class VMBasicBuiltinSerdeFactory {
    private static final Map<Class, DataInputOutputSerde> PRIMITIVES = new HashMap<Class, DataInputOutputSerde>();
    private static final Map<Class, DataInputOutputSerde> BOXED = new HashMap<Class, DataInputOutputSerde>();
    private static Map<String, DataInputOutputSerde> byPrettyName = null;

    private static void addPrimitive(Class cls, DataInputOutputSerde serde) {
        PRIMITIVES.put(cls, serde);
    }

    private static void addBoxed(Class cls, DataInputOutputSerde serde) {
        BOXED.put(cls, serde);
    }

    protected static DataInputOutputSerde getSerde(Class cls) {
        if (cls.isPrimitive()) {
            return PRIMITIVES.get(cls);
        }
        return BOXED.get(cls);
    }

    public static synchronized DataInputOutputSerde getSerde(String classNamePretty) {
        if (byPrettyName == null) {
            byPrettyName = new HashMap<String, DataInputOutputSerde>();
            VMBasicBuiltinSerdeFactory.addPrettyName(PRIMITIVES, byPrettyName);
            VMBasicBuiltinSerdeFactory.addPrettyName(BOXED, byPrettyName);
        }
        return byPrettyName.get(classNamePretty);
    }

    private static void addPrettyName(Map<Class, DataInputOutputSerde> serdes, Map<String, DataInputOutputSerde> allbyname) {
        for (Map.Entry<Class, DataInputOutputSerde> serde : serdes.entrySet()) {
            Class clazz = serde.getKey();
            String pretty = JavaClassHelper.getClassNameNormalized(EPTypePremade.getOrCreate(clazz));
            if (allbyname.containsKey(pretty)) {
                throw new IllegalStateException("Duplicate key '" + pretty + "'");
            }
            allbyname.put(pretty, serde.getValue());
        }
    }

    static {
        VMBasicBuiltinSerdeFactory.addPrimitive(Character.TYPE, DIOCharacterSerde.INSTANCE);
        VMBasicBuiltinSerdeFactory.addPrimitive(Boolean.TYPE, DIOBooleanSerde.INSTANCE);
        VMBasicBuiltinSerdeFactory.addPrimitive(Byte.TYPE, DIOByteSerde.INSTANCE);
        VMBasicBuiltinSerdeFactory.addPrimitive(Short.TYPE, DIOShortSerde.INSTANCE);
        VMBasicBuiltinSerdeFactory.addPrimitive(Integer.TYPE, DIOIntegerSerde.INSTANCE);
        VMBasicBuiltinSerdeFactory.addPrimitive(Long.TYPE, DIOLongSerde.INSTANCE);
        VMBasicBuiltinSerdeFactory.addPrimitive(Float.TYPE, DIOFloatSerde.INSTANCE);
        VMBasicBuiltinSerdeFactory.addPrimitive(Double.TYPE, DIODoubleSerde.INSTANCE);
        VMBasicBuiltinSerdeFactory.addPrimitive(Void.TYPE, DIOSkipSerde.INSTANCE);
        VMBasicBuiltinSerdeFactory.addBoxed(String.class, DIONullableStringSerde.INSTANCE);
        VMBasicBuiltinSerdeFactory.addBoxed(CharSequence.class, DIOCharSequenceSerde.INSTANCE);
        VMBasicBuiltinSerdeFactory.addBoxed(Character.class, DIONullableCharacterSerde.INSTANCE);
        VMBasicBuiltinSerdeFactory.addBoxed(Boolean.class, DIONullableBooleanSerde.INSTANCE);
        VMBasicBuiltinSerdeFactory.addBoxed(Byte.class, DIONullableByteSerde.INSTANCE);
        VMBasicBuiltinSerdeFactory.addBoxed(Short.class, DIONullableShortSerde.INSTANCE);
        VMBasicBuiltinSerdeFactory.addBoxed(Integer.class, DIONullableIntegerSerde.INSTANCE);
        VMBasicBuiltinSerdeFactory.addBoxed(Long.class, DIONullableLongSerde.INSTANCE);
        VMBasicBuiltinSerdeFactory.addBoxed(Float.class, DIONullableFloatSerde.INSTANCE);
        VMBasicBuiltinSerdeFactory.addBoxed(Double.class, DIONullableDoubleSerde.INSTANCE);
        VMBasicBuiltinSerdeFactory.addBoxed(String[].class, DIOStringArrayNullableSerde.INSTANCE);
        VMBasicBuiltinSerdeFactory.addBoxed(CharSequence[].class, DIOStringArrayNullableSerde.INSTANCE);
        VMBasicBuiltinSerdeFactory.addBoxed(Character[].class, DIOBoxedCharacterArrayNullableSerde.INSTANCE);
        VMBasicBuiltinSerdeFactory.addBoxed(Boolean[].class, DIOBoxedBooleanArrayNullableSerde.INSTANCE);
        VMBasicBuiltinSerdeFactory.addBoxed(Byte[].class, DIOBoxedByteArrayNullableSerde.INSTANCE);
        VMBasicBuiltinSerdeFactory.addBoxed(Short[].class, DIOBoxedShortArrayNullableSerde.INSTANCE);
        VMBasicBuiltinSerdeFactory.addBoxed(Integer[].class, DIOBoxedIntegerArrayNullableSerde.INSTANCE);
        VMBasicBuiltinSerdeFactory.addBoxed(Long[].class, DIOBoxedLongArrayNullableSerde.INSTANCE);
        VMBasicBuiltinSerdeFactory.addBoxed(Float[].class, DIOBoxedFloatArrayNullableSerde.INSTANCE);
        VMBasicBuiltinSerdeFactory.addBoxed(Double[].class, DIOBoxedDoubleArrayNullableSerde.INSTANCE);
        VMBasicBuiltinSerdeFactory.addBoxed(char[].class, DIOPrimitiveCharArrayNullableSerde.INSTANCE);
        VMBasicBuiltinSerdeFactory.addBoxed(boolean[].class, DIOPrimitiveBooleanArrayNullableSerde.INSTANCE);
        VMBasicBuiltinSerdeFactory.addBoxed(byte[].class, DIOPrimitiveByteArrayNullableSerde.INSTANCE);
        VMBasicBuiltinSerdeFactory.addBoxed(short[].class, DIOPrimitiveShortArrayNullableSerde.INSTANCE);
        VMBasicBuiltinSerdeFactory.addBoxed(int[].class, DIOPrimitiveIntArrayNullableSerde.INSTANCE);
        VMBasicBuiltinSerdeFactory.addBoxed(long[].class, DIOPrimitiveLongArrayNullableSerde.INSTANCE);
        VMBasicBuiltinSerdeFactory.addBoxed(float[].class, DIOPrimitiveFloatArrayNullableSerde.INSTANCE);
        VMBasicBuiltinSerdeFactory.addBoxed(double[].class, DIOPrimitiveDoubleArrayNullableSerde.INSTANCE);
        VMBasicBuiltinSerdeFactory.addBoxed(char[][].class, DIOPrimitiveCharArray2DimNullableSerde.INSTANCE);
        VMBasicBuiltinSerdeFactory.addBoxed(boolean[][].class, DIOPrimitiveBooleanArray2DimNullableSerde.INSTANCE);
        VMBasicBuiltinSerdeFactory.addBoxed(byte[][].class, DIOPrimitiveByteArray2DimNullableSerde.INSTANCE);
        VMBasicBuiltinSerdeFactory.addBoxed(short[][].class, DIOPrimitiveShortArray2DimNullableSerde.INSTANCE);
        VMBasicBuiltinSerdeFactory.addBoxed(int[][].class, DIOPrimitiveIntArray2DimNullableSerde.INSTANCE);
        VMBasicBuiltinSerdeFactory.addBoxed(long[][].class, DIOPrimitiveLongArray2DimNullableSerde.INSTANCE);
        VMBasicBuiltinSerdeFactory.addBoxed(float[][].class, DIOPrimitiveFloatArray2DimNullableSerde.INSTANCE);
        VMBasicBuiltinSerdeFactory.addBoxed(double[][].class, DIOPrimitiveDoubleArray2DimNullableSerde.INSTANCE);
        VMBasicBuiltinSerdeFactory.addBoxed(String[][].class, DIOStringArray2DimNullableSerde.INSTANCE);
        VMBasicBuiltinSerdeFactory.addBoxed(CharSequence[][].class, DIOStringArray2DimNullableSerde.INSTANCE);
        VMBasicBuiltinSerdeFactory.addBoxed(Character[][].class, DIOBoxedCharacterArray2DimNullableSerde.INSTANCE);
        VMBasicBuiltinSerdeFactory.addBoxed(Boolean[][].class, DIOBoxedBooleanArray2DimNullableSerde.INSTANCE);
        VMBasicBuiltinSerdeFactory.addBoxed(Byte[][].class, DIOBoxedByteArray2DimNullableSerde.INSTANCE);
        VMBasicBuiltinSerdeFactory.addBoxed(Short[][].class, DIOBoxedShortArray2DimNullableSerde.INSTANCE);
        VMBasicBuiltinSerdeFactory.addBoxed(Integer[][].class, DIOBoxedIntegerArray2DimNullableSerde.INSTANCE);
        VMBasicBuiltinSerdeFactory.addBoxed(Long[][].class, DIOBoxedLongArray2DimNullableSerde.INSTANCE);
        VMBasicBuiltinSerdeFactory.addBoxed(Float[][].class, DIOBoxedFloatArray2DimNullableSerde.INSTANCE);
        VMBasicBuiltinSerdeFactory.addBoxed(Double[][].class, DIOBoxedDoubleArray2DimNullableSerde.INSTANCE);
        VMBasicBuiltinSerdeFactory.addBoxed(BigInteger[].class, DIOBigIntegerArrayNullableSerde.INSTANCE);
        VMBasicBuiltinSerdeFactory.addBoxed(BigDecimal[].class, DIOBigDecimalArrayNullableSerde.INSTANCE);
        VMBasicBuiltinSerdeFactory.addBoxed(BigInteger[][].class, DIOBigIntegerArray2DimNullableSerde.INSTANCE);
        VMBasicBuiltinSerdeFactory.addBoxed(BigDecimal[][].class, DIOBigDecimalArray2DimNullableSerde.INSTANCE);
    }
}

