/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.serde.compiletime.resolve;

import com.espertech.esper.common.client.serde.DataInputOutputSerde;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypeClassParameterized;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOArrayListBigDecimalNullableSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOArrayListBigIntegerNullableSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOArrayListBooleanNullableSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOArrayListByteNullableSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOArrayListCalendarNullableSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOArrayListCharacterNullableSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOArrayListDateNullableSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOArrayListDoubleNullableSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOArrayListFloatNullableSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOArrayListIntegerNullableSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOArrayListLongNullableSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOArrayListShortNullableSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOArrayListSqlDateNullableSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOArrayListStringNullableSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOBigDecimalArrayNullableSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOBigDecimalSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOBigIntegerArrayNullableSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOBigIntegerSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOBoxedBooleanArrayNullableSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOBoxedByteArrayNullableSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOBoxedCharacterArrayNullableSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOBoxedDoubleArrayNullableSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOBoxedFloatArrayNullableSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOBoxedIntegerArrayNullableSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOBoxedLongArrayNullableSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOBoxedShortArrayNullableSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOCalendarArrayNullableSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOCalendarSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIODateArrayNullableSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIODateSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOPrimitiveBooleanArrayNullableSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOPrimitiveByteArrayNullableSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOPrimitiveCharArrayNullableSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOPrimitiveDoubleArrayNullableSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOPrimitiveFloatArrayNullableSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOPrimitiveIntArrayNullableSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOPrimitiveLongArrayNullableSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOPrimitiveShortArrayNullableSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOSqlDateArrayNullableSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOSqlDateSerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOStringArrayNullableSerde;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VMExtendedBuiltinSerdeFactory {
    private static final Map<EPTypeClass, DataInputOutputSerde> SERDES = new HashMap<EPTypeClass, DataInputOutputSerde>();
    private static Map<String, DataInputOutputSerde> byPrettyName = null;

    private static void addArrayList(Class component, DataInputOutputSerde serde) {
        SERDES.put(EPTypeClassParameterized.from(Collection.class, component), serde);
        SERDES.put(EPTypeClassParameterized.from(List.class, component), serde);
        SERDES.put(EPTypeClassParameterized.from(ArrayList.class, component), serde);
    }

    public static DataInputOutputSerde getSerde(EPTypeClass typeClass) {
        return SERDES.get(typeClass);
    }

    public static synchronized DataInputOutputSerde getSerde(String classNamePretty) {
        if (byPrettyName == null) {
            byPrettyName = new HashMap<String, DataInputOutputSerde>();
            for (Map.Entry<EPTypeClass, DataInputOutputSerde> serde : SERDES.entrySet()) {
                EPTypeClass clazz = serde.getKey();
                String pretty = JavaClassHelper.getClassNameNormalized(clazz);
                if (byPrettyName.containsKey(pretty)) {
                    throw new IllegalStateException("Duplicate key '" + pretty + "'");
                }
                byPrettyName.put(pretty, serde.getValue());
            }
        }
        return byPrettyName.get(classNamePretty);
    }

    static {
        SERDES.put(EPTypePremade.BIGINTEGER.getEPType(), DIOBigIntegerSerde.INSTANCE);
        SERDES.put(EPTypePremade.BIGDECIMAL.getEPType(), DIOBigDecimalSerde.INSTANCE);
        SERDES.put(EPTypePremade.DATE.getEPType(), DIODateSerde.INSTANCE);
        SERDES.put(EPTypePremade.SQLDATE.getEPType(), DIOSqlDateSerde.INSTANCE);
        SERDES.put(EPTypePremade.CALENDAR.getEPType(), DIOCalendarSerde.INSTANCE);
        SERDES.put(EPTypePremade.INTEGERPRIMITIVEARRAY.getEPType(), DIOPrimitiveIntArrayNullableSerde.INSTANCE);
        SERDES.put(EPTypePremade.BOOLEANPRIMITIVEARRAY.getEPType(), DIOPrimitiveBooleanArrayNullableSerde.INSTANCE);
        SERDES.put(EPTypePremade.CHARPRIMITIVEARRAY.getEPType(), DIOPrimitiveCharArrayNullableSerde.INSTANCE);
        SERDES.put(EPTypePremade.BYTEPRIMITIVEARRAY.getEPType(), DIOPrimitiveByteArrayNullableSerde.INSTANCE);
        SERDES.put(EPTypePremade.SHORTPRIMITIVEARRAY.getEPType(), DIOPrimitiveShortArrayNullableSerde.INSTANCE);
        SERDES.put(EPTypePremade.LONGPRIMITIVEARRAY.getEPType(), DIOPrimitiveLongArrayNullableSerde.INSTANCE);
        SERDES.put(EPTypePremade.FLOATPRIMITIVEARRAY.getEPType(), DIOPrimitiveFloatArrayNullableSerde.INSTANCE);
        SERDES.put(EPTypePremade.DOUBLEPRIMITIVEARRAY.getEPType(), DIOPrimitiveDoubleArrayNullableSerde.INSTANCE);
        SERDES.put(EPTypePremade.STRINGARRAY.getEPType(), DIOStringArrayNullableSerde.INSTANCE);
        SERDES.put(EPTypePremade.CHARBOXEDARRAY.getEPType(), DIOBoxedCharacterArrayNullableSerde.INSTANCE);
        SERDES.put(EPTypePremade.BOOLEANBOXEDARRAY.getEPType(), DIOBoxedBooleanArrayNullableSerde.INSTANCE);
        SERDES.put(EPTypePremade.BYTEBOXEDARRAY.getEPType(), DIOBoxedByteArrayNullableSerde.INSTANCE);
        SERDES.put(EPTypePremade.SHORTBOXEDARRAY.getEPType(), DIOBoxedShortArrayNullableSerde.INSTANCE);
        SERDES.put(EPTypePremade.INTEGERBOXEDARRAY.getEPType(), DIOBoxedIntegerArrayNullableSerde.INSTANCE);
        SERDES.put(EPTypePremade.LONGBOXEDARRAY.getEPType(), DIOBoxedLongArrayNullableSerde.INSTANCE);
        SERDES.put(EPTypePremade.FLOATBOXEDARRAY.getEPType(), DIOBoxedFloatArrayNullableSerde.INSTANCE);
        SERDES.put(EPTypePremade.DOUBLEBOXEDARRAY.getEPType(), DIOBoxedDoubleArrayNullableSerde.INSTANCE);
        SERDES.put(EPTypePremade.BIGDECIMALARRAY.getEPType(), DIOBigDecimalArrayNullableSerde.INSTANCE);
        SERDES.put(EPTypePremade.BIGINTEGERARRAY.getEPType(), DIOBigIntegerArrayNullableSerde.INSTANCE);
        SERDES.put(EPTypePremade.DATEARRAY.getEPType(), DIODateArrayNullableSerde.INSTANCE);
        SERDES.put(EPTypePremade.SQLDATEARRAY.getEPType(), DIOSqlDateArrayNullableSerde.INSTANCE);
        SERDES.put(EPTypePremade.CALENDARARRAY.getEPType(), DIOCalendarArrayNullableSerde.INSTANCE);
        VMExtendedBuiltinSerdeFactory.addArrayList(String.class, DIOArrayListStringNullableSerde.INSTANCE);
        VMExtendedBuiltinSerdeFactory.addArrayList(Character.class, DIOArrayListCharacterNullableSerde.INSTANCE);
        VMExtendedBuiltinSerdeFactory.addArrayList(Boolean.class, DIOArrayListBooleanNullableSerde.INSTANCE);
        VMExtendedBuiltinSerdeFactory.addArrayList(Byte.class, DIOArrayListByteNullableSerde.INSTANCE);
        VMExtendedBuiltinSerdeFactory.addArrayList(Short.class, DIOArrayListShortNullableSerde.INSTANCE);
        VMExtendedBuiltinSerdeFactory.addArrayList(Integer.class, DIOArrayListIntegerNullableSerde.INSTANCE);
        VMExtendedBuiltinSerdeFactory.addArrayList(Long.class, DIOArrayListLongNullableSerde.INSTANCE);
        VMExtendedBuiltinSerdeFactory.addArrayList(Float.class, DIOArrayListFloatNullableSerde.INSTANCE);
        VMExtendedBuiltinSerdeFactory.addArrayList(Double.class, DIOArrayListDoubleNullableSerde.INSTANCE);
        VMExtendedBuiltinSerdeFactory.addArrayList(BigDecimal.class, DIOArrayListBigDecimalNullableSerde.INSTANCE);
        VMExtendedBuiltinSerdeFactory.addArrayList(BigInteger.class, DIOArrayListBigIntegerNullableSerde.INSTANCE);
        VMExtendedBuiltinSerdeFactory.addArrayList(java.util.Date.class, DIOArrayListDateNullableSerde.INSTANCE);
        VMExtendedBuiltinSerdeFactory.addArrayList(Date.class, DIOArrayListSqlDateNullableSerde.INSTANCE);
        VMExtendedBuiltinSerdeFactory.addArrayList(Calendar.class, DIOArrayListCalendarNullableSerde.INSTANCE);
    }
}

