/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.serde.compiletime.sharable;

import com.espertech.esper.common.client.serde.DataInputOutputSerde;
import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenFieldSharable;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.serde.compiletime.resolve.DataInputOutputSerdeForge;
import com.espertech.esper.common.internal.serde.serdeset.additional.DIORefCountedSet;
import com.espertech.esper.common.internal.serde.serdeset.additional.DIOSortedRefCountedSet;

public class CodegenSharableSerdeClassTyped
implements CodegenFieldSharable {
    private final CodegenSharableSerdeName name;
    private final EPType valueType;
    private final DataInputOutputSerdeForge forge;
    private final CodegenClassScope classScope;

    public CodegenSharableSerdeClassTyped(CodegenSharableSerdeName name, EPType valueType, DataInputOutputSerdeForge forge, CodegenClassScope classScope) {
        this.name = name;
        this.valueType = valueType;
        this.forge = forge;
        this.classScope = classScope;
    }

    @Override
    public EPTypeClass type() {
        return DataInputOutputSerde.EPTYPE;
    }

    @Override
    public CodegenExpression initCtorScoped() {
        CodegenExpression serde = this.forge.codegen(this.classScope.getPackageScope().getInitMethod(), this.classScope, null);
        if (this.name == CodegenSharableSerdeName.VALUE_NULLABLE) {
            return serde;
        }
        if (this.name == CodegenSharableSerdeName.REFCOUNTEDSET) {
            return CodegenExpressionBuilder.newInstance(DIORefCountedSet.EPTYPE, serde);
        }
        if (this.name == CodegenSharableSerdeName.SORTEDREFCOUNTEDSET) {
            return CodegenExpressionBuilder.newInstance(DIOSortedRefCountedSet.EPTYPE, serde);
        }
        throw new IllegalArgumentException("Unrecognized name " + (Object)((Object)this.name));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CodegenSharableSerdeClassTyped that = (CodegenSharableSerdeClassTyped)o;
        if (this.name != that.name) {
            return false;
        }
        return this.valueType.equals(that.valueType);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.valueType.hashCode();
        return result;
    }

    public static enum CodegenSharableSerdeName {
        VALUE_NULLABLE("valueNullable"),
        REFCOUNTEDSET("refCountedSet"),
        SORTEDREFCOUNTEDSET("sortedRefCountedSet");

        private final String methodName;

        private CodegenSharableSerdeName(String methodName) {
            this.methodName = methodName;
        }

        public String getMethodName() {
            return this.methodName;
        }
    }
}

