/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.serde.serdeset.additional;

import com.espertech.esper.common.client.serde.DataInputOutputSerde;
import com.espertech.esper.common.client.serde.EventBeanCollatedWriter;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.util.CollectionUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class DIOMapPropertySerde
implements DataInputOutputSerde<Map> {
    public static final EPTypeClass EPTYPE = new EPTypeClass(DIOMapPropertySerde.class);
    private final String[] keys;
    private final DataInputOutputSerde[] serdes;

    public DIOMapPropertySerde(String[] keys, DataInputOutputSerde[] serdes) {
        this.keys = keys;
        this.serdes = serdes;
    }

    @Override
    public void write(Map object, DataOutput output, byte[] unitKey, EventBeanCollatedWriter writer) throws IOException {
        for (int i = 0; i < this.keys.length; ++i) {
            String value = this.keys[i];
            this.serdes[i].write(value, output, unitKey, writer);
        }
    }

    @Override
    public Map read(DataInput input, byte[] unitKey) throws IOException {
        HashMap map = new HashMap(CollectionUtil.capacityHashMap(this.keys.length));
        for (int i = 0; i < this.keys.length; ++i) {
            Object value = this.serdes[i].read(input, unitKey);
            map.put(this.keys[i], value);
        }
        return map;
    }
}

