/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.serde.serdeset.additional;

import com.espertech.esper.common.client.serde.DataInputOutputSerde;
import com.espertech.esper.common.client.serde.EventBeanCollatedWriter;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.collection.RefCountedSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;

public class DIORefCountedSet
implements DataInputOutputSerde<RefCountedSet<Object>> {
    public static final EPTypeClass EPTYPE = new EPTypeClass(DIORefCountedSet.class);
    private final DataInputOutputSerde inner;

    public DIORefCountedSet(DataInputOutputSerde inner) {
        this.inner = inner;
    }

    @Override
    public void write(RefCountedSet<Object> valueSet, DataOutput output, byte[] unitKey, EventBeanCollatedWriter writer) throws IOException {
        output.writeInt(valueSet.getRefSet().size());
        for (Map.Entry<Object, Integer> entry : valueSet.getRefSet().entrySet()) {
            this.inner.write(entry.getKey(), output, unitKey, writer);
            output.writeInt(entry.getValue());
        }
        output.writeInt(valueSet.getNumValues());
    }

    @Override
    public RefCountedSet<Object> read(DataInput input, byte[] unitKey) throws IOException {
        RefCountedSet<Object> valueSet = new RefCountedSet<Object>();
        Map refSet = valueSet.getRefSet();
        int size = input.readInt();
        for (int i = 0; i < size; ++i) {
            Object key = this.inner.read(input, unitKey);
            int ref = input.readInt();
            refSet.put(key, ref);
        }
        valueSet.setNumValues(input.readInt());
        return valueSet;
    }
}

