/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.serde.serdeset.builtin;

import com.espertech.esper.common.client.serde.DataInputOutputSerde;
import com.espertech.esper.common.client.serde.EventBeanCollatedWriter;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOBigDecimalBigIntegerUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigInteger;

public class DIOBigIntegerSerde
implements DataInputOutputSerde<BigInteger> {
    public static final EPTypeClass EPTYPE = new EPTypeClass(DIOBigIntegerSerde.class);
    public static final DIOBigIntegerSerde INSTANCE = new DIOBigIntegerSerde();

    private DIOBigIntegerSerde() {
    }

    @Override
    public void write(BigInteger object, DataOutput output, byte[] pageFullKey, EventBeanCollatedWriter writer) throws IOException {
        this.write(object, output);
    }

    public void write(BigInteger bigInteger, DataOutput stream) throws IOException {
        boolean isNull = bigInteger == null;
        stream.writeBoolean(isNull);
        if (!isNull) {
            DIOBigDecimalBigIntegerUtil.writeBigInt(bigInteger, stream);
        }
    }

    public BigInteger read(DataInput input) throws IOException {
        return this.readInternal(input);
    }

    @Override
    public BigInteger read(DataInput input, byte[] resourceKey) throws IOException {
        return this.readInternal(input);
    }

    private BigInteger readInternal(DataInput input) throws IOException {
        boolean isNull = input.readBoolean();
        if (isNull) {
            return null;
        }
        return DIOBigDecimalBigIntegerUtil.readBigInt(input);
    }
}

