/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.serde.serdeset.builtin;

import com.espertech.esper.common.client.serde.DataInputOutputSerde;
import com.espertech.esper.common.client.serde.EventBeanCollatedWriter;
import com.espertech.esper.common.client.type.EPTypeClass;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class DIOPrimitiveCharArray2DimNullableSerde
implements DataInputOutputSerde<char[][]> {
    public static final EPTypeClass EPTYPE = new EPTypeClass(DIOPrimitiveCharArray2DimNullableSerde.class);
    public static final DIOPrimitiveCharArray2DimNullableSerde INSTANCE = new DIOPrimitiveCharArray2DimNullableSerde();

    private DIOPrimitiveCharArray2DimNullableSerde() {
    }

    @Override
    public void write(char[][] object, DataOutput output, byte[] unitKey, EventBeanCollatedWriter writer) throws IOException {
        if (object == null) {
            output.writeInt(-1);
            return;
        }
        output.writeInt(object.length);
        for (char[] i : object) {
            this.writeArray(i, output);
        }
    }

    @Override
    public char[][] read(DataInput input, byte[] unitKey) throws IOException {
        int len = input.readInt();
        if (len == -1) {
            return null;
        }
        char[][] array = new char[len][];
        for (int i = 0; i < len; ++i) {
            array[i] = this.readArray(input);
        }
        return array;
    }

    private void writeArray(char[] array, DataOutput output) throws IOException {
        if (array == null) {
            output.writeInt(-1);
            return;
        }
        output.writeInt(array.length);
        for (char i : array) {
            output.writeChar(i);
        }
    }

    private char[] readArray(DataInput input) throws IOException {
        int len = input.readInt();
        if (len == -1) {
            return null;
        }
        char[] array = new char[len];
        for (int i = 0; i < len; ++i) {
            array[i] = input.readChar();
        }
        return array;
    }
}

