/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.serde.serdeset.builtin;

import com.espertech.esper.common.client.serde.DataInputOutputSerde;
import com.espertech.esper.common.client.serde.EventBeanCollatedWriter;
import com.espertech.esper.common.client.type.EPTypeClass;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class DIOPrimitiveIntArray2DimNullableSerde
implements DataInputOutputSerde<int[][]> {
    public static final EPTypeClass EPTYPE = new EPTypeClass(DIOPrimitiveIntArray2DimNullableSerde.class);
    public static final DIOPrimitiveIntArray2DimNullableSerde INSTANCE = new DIOPrimitiveIntArray2DimNullableSerde();

    private DIOPrimitiveIntArray2DimNullableSerde() {
    }

    @Override
    public void write(int[][] object, DataOutput output, byte[] unitKey, EventBeanCollatedWriter writer) throws IOException {
        if (object == null) {
            output.writeInt(-1);
            return;
        }
        output.writeInt(object.length);
        for (int[] i : object) {
            this.writeArray(i, output);
        }
    }

    @Override
    public int[][] read(DataInput input, byte[] unitKey) throws IOException {
        int len = input.readInt();
        if (len == -1) {
            return null;
        }
        int[][] array = new int[len][];
        for (int i = 0; i < len; ++i) {
            array[i] = this.readArray(input);
        }
        return array;
    }

    private void writeArray(int[] array, DataOutput output) throws IOException {
        if (array == null) {
            output.writeInt(-1);
            return;
        }
        output.writeInt(array.length);
        for (int i : array) {
            output.writeInt(i);
        }
    }

    private int[] readArray(DataInput input) throws IOException {
        int len = input.readInt();
        if (len == -1) {
            return null;
        }
        int[] array = new int[len];
        for (int i = 0; i < len; ++i) {
            array[i] = input.readInt();
        }
        return array;
    }
}

