/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.serde.serdeset.builtin;

import com.espertech.esper.common.client.serde.DataInputOutputSerde;
import com.espertech.esper.common.client.serde.EventBeanCollatedWriter;
import com.espertech.esper.common.client.type.EPTypeClass;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class DIOPrimitiveLongArray2DimNullableSerde
implements DataInputOutputSerde<long[][]> {
    public static final EPTypeClass EPTYPE = new EPTypeClass(DIOPrimitiveLongArray2DimNullableSerde.class);
    public static final DIOPrimitiveLongArray2DimNullableSerde INSTANCE = new DIOPrimitiveLongArray2DimNullableSerde();

    private DIOPrimitiveLongArray2DimNullableSerde() {
    }

    @Override
    public void write(long[][] object, DataOutput output, byte[] unitKey, EventBeanCollatedWriter writer) throws IOException {
        if (object == null) {
            output.writeInt(-1);
            return;
        }
        output.writeInt(object.length);
        for (long[] i : object) {
            this.writeArray(i, output);
        }
    }

    @Override
    public long[][] read(DataInput input, byte[] unitKey) throws IOException {
        int len = input.readInt();
        if (len == -1) {
            return null;
        }
        long[][] array = new long[len][];
        for (int i = 0; i < len; ++i) {
            array[i] = this.readArray(input);
        }
        return array;
    }

    private void writeArray(long[] array, DataOutput output) throws IOException {
        if (array == null) {
            output.writeInt(-1);
            return;
        }
        output.writeInt(array.length);
        for (long i : array) {
            output.writeLong(i);
        }
    }

    private long[] readArray(DataInput input) throws IOException {
        int len = input.readInt();
        if (len == -1) {
            return null;
        }
        long[] array = new long[len];
        for (int i = 0; i < len; ++i) {
            array[i] = input.readLong();
        }
        return array;
    }
}

