/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.serde.serdeset.builtin;

import com.espertech.esper.common.client.serde.DataInputOutputSerde;
import com.espertech.esper.common.client.serde.EventBeanCollatedWriter;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.util.CollectionUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class DIOSetSerde
implements DataInputOutputSerde<Set<Object>> {
    public static final EPTypeClass EPTYPE = new EPTypeClass(DIOSetSerde.class);
    private final DataInputOutputSerde inner;

    public DIOSetSerde(DataInputOutputSerde inner) {
        this.inner = inner;
    }

    @Override
    public void write(Set<Object> set, DataOutput output, byte[] unitKey, EventBeanCollatedWriter writer) throws IOException {
        output.writeInt(set.size());
        for (Object object : set) {
            this.inner.write(object, output, unitKey, writer);
        }
    }

    @Override
    public Set<Object> read(DataInput input, byte[] unitKey) throws IOException {
        int size = input.readInt();
        HashSet<Object> set = new HashSet<Object>(CollectionUtil.capacityHashMap(size));
        for (int i = 0; i < size; ++i) {
            set.add(this.inner.read(input, unitKey));
        }
        return set;
    }
}

