/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.statement.dispatch;

import com.espertech.esper.common.internal.statement.dispatch.Dispatchable;
import com.espertech.esper.common.internal.statement.dispatch.UpdateDispatchView;
import java.util.ArrayDeque;
import java.util.Iterator;

public class DispatchService {
    private final ThreadLocal<ArrayDeque<Dispatchable>> dispatchStateThreadLocal = new ThreadLocal<ArrayDeque<Dispatchable>>(){

        @Override
        protected synchronized ArrayDeque<Dispatchable> initialValue() {
            return new ArrayDeque<Dispatchable>();
        }
    };

    public ThreadLocal<ArrayDeque<Dispatchable>> getDispatchStateThreadLocal() {
        return this.dispatchStateThreadLocal;
    }

    public void dispatch() {
        DispatchService.dispatchFromQueue(this.dispatchStateThreadLocal.get());
    }

    public void addExternal(Dispatchable dispatchable) {
        ArrayDeque<Dispatchable> dispatchQueue = this.dispatchStateThreadLocal.get();
        DispatchService.addToQueue(dispatchable, dispatchQueue);
    }

    private static void addToQueue(Dispatchable dispatchable, ArrayDeque<Dispatchable> dispatchQueue) {
        dispatchQueue.add(dispatchable);
    }

    private static void dispatchFromQueue(ArrayDeque<Dispatchable> dispatchQueue) {
        Dispatchable next;
        while ((next = dispatchQueue.poll()) != null) {
            next.execute();
        }
    }

    public void removeAll(UpdateDispatchView updateDispatchView) {
        ArrayDeque<Dispatchable> dispatchables = this.dispatchStateThreadLocal.get();
        Iterator<Dispatchable> it = dispatchables.descendingIterator();
        while (it.hasNext()) {
            Dispatchable dispatchable = it.next();
            if (dispatchable.getView() != updateDispatchView) continue;
            it.remove();
            dispatchable.cancelled();
        }
    }
}

