/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.statement.insertintolatch;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.util.Locking;
import com.espertech.esper.common.internal.schedule.TimeSourceService;
import com.espertech.esper.common.internal.statement.insertintolatch.InsertIntoLatchSpin;
import com.espertech.esper.common.internal.statement.insertintolatch.InsertIntoLatchWait;

public class InsertIntoLatchFactory {
    private final String name;
    private final boolean stateless;
    private final boolean useSpin;
    private final TimeSourceService timeSourceService;
    private final long msecWait;
    private InsertIntoLatchSpin currentLatchSpin;
    private InsertIntoLatchWait currentLatchWait;

    public InsertIntoLatchFactory(String name, boolean stateless, long msecWait, Locking locking, TimeSourceService timeSourceService) {
        this.name = name;
        this.msecWait = msecWait;
        this.timeSourceService = timeSourceService;
        this.stateless = stateless;
        boolean bl = this.useSpin = locking == Locking.SPIN;
        if (this.useSpin) {
            this.currentLatchSpin = new InsertIntoLatchSpin(this);
        } else {
            this.currentLatchWait = new InsertIntoLatchWait(this);
        }
    }

    public Object newLatch(EventBean payload) {
        if (this.stateless) {
            return payload;
        }
        if (this.useSpin) {
            InsertIntoLatchSpin nextLatch;
            this.currentLatchSpin = nextLatch = new InsertIntoLatchSpin(this, this.currentLatchSpin, this.msecWait, payload);
            return nextLatch;
        }
        InsertIntoLatchWait nextLatch = new InsertIntoLatchWait(this, this.currentLatchWait, this.msecWait, payload);
        this.currentLatchWait.setLater(nextLatch);
        this.currentLatchWait = nextLatch;
        return nextLatch;
    }

    public TimeSourceService getTimeSourceService() {
        return this.timeSourceService;
    }

    public String getName() {
        return this.name;
    }
}

