/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.statement.insertintolatch;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.statement.insertintolatch.InsertIntoLatch;
import com.espertech.esper.common.internal.statement.insertintolatch.InsertIntoLatchFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InsertIntoLatchWait
implements InsertIntoLatch {
    private static final Logger log = LoggerFactory.getLogger(InsertIntoLatchWait.class);
    private final InsertIntoLatchFactory factory;
    private InsertIntoLatchWait earlier;
    private long msecTimeout;
    private EventBean payload;
    private InsertIntoLatchWait later;
    private volatile boolean isCompleted;

    public InsertIntoLatchWait(InsertIntoLatchFactory factory, InsertIntoLatchWait earlier, long msecTimeout, EventBean payload) {
        this.factory = factory;
        this.earlier = earlier;
        this.msecTimeout = msecTimeout;
        this.payload = payload;
    }

    public InsertIntoLatchWait(InsertIntoLatchFactory factory) {
        this.factory = factory;
        this.isCompleted = true;
        this.earlier = null;
        this.msecTimeout = 0L;
    }

    public boolean isCompleted() {
        return this.isCompleted;
    }

    public void setLater(InsertIntoLatchWait later) {
        this.later = later;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventBean await() {
        if (!this.earlier.isCompleted) {
            InsertIntoLatchWait insertIntoLatchWait = this;
            synchronized (insertIntoLatchWait) {
                if (!this.earlier.isCompleted) {
                    try {
                        this.wait(this.msecTimeout);
                    }
                    catch (InterruptedException e) {
                        log.error("Interrupted: " + e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
        if (!this.earlier.isCompleted) {
            log.info("Wait timeout exceeded for insert-into dispatch with notify");
        }
        return this.payload;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void done() {
        this.isCompleted = true;
        if (this.later != null) {
            InsertIntoLatchWait insertIntoLatchWait = this.later;
            synchronized (insertIntoLatchWait) {
                this.later.notify();
            }
        }
        this.earlier = null;
        this.later = null;
    }

    @Override
    public InsertIntoLatchFactory getFactory() {
        return this.factory;
    }

    @Override
    public void setEvent(EventBean event) {
        this.payload = event;
    }

    @Override
    public EventBean getEvent() {
        return this.payload;
    }
}

