/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.type;

import com.espertech.esper.common.internal.type.ClassDescriptorParser;
import java.io.StringWriter;
import java.util.Collections;
import java.util.List;

public class ClassDescriptor {
    public static final String PRIMITIVE_KEYWORD = "primitive";
    private final String classIdentifier;
    private List<ClassDescriptor> typeParameters;
    private int arrayDimensions;
    private boolean arrayOfPrimitive;

    public ClassDescriptor(String classIdentifier) {
        this.classIdentifier = classIdentifier;
        this.typeParameters = Collections.emptyList();
        this.arrayDimensions = 0;
        this.arrayOfPrimitive = false;
    }

    public ClassDescriptor(String classIdentifier, List<ClassDescriptor> typeParameters, int arrayDimensions, boolean arrayOfPrimitive) {
        this.classIdentifier = classIdentifier;
        this.typeParameters = typeParameters;
        this.arrayDimensions = arrayDimensions;
        this.arrayOfPrimitive = arrayOfPrimitive;
    }

    public static ClassDescriptor parseTypeText(String typeName) {
        return ClassDescriptorParser.parse(typeName);
    }

    public String getClassIdentifier() {
        return this.classIdentifier;
    }

    public int getArrayDimensions() {
        return this.arrayDimensions;
    }

    public boolean isArrayOfPrimitive() {
        return this.arrayOfPrimitive;
    }

    public List<ClassDescriptor> getTypeParameters() {
        return this.typeParameters;
    }

    public void setTypeParameters(List<ClassDescriptor> typeParameters) {
        this.typeParameters = typeParameters;
    }

    public void setArrayDimensions(int arrayDimensions) {
        this.arrayDimensions = arrayDimensions;
    }

    public void setArrayOfPrimitive(boolean arrayOfPrimitive) {
        this.arrayOfPrimitive = arrayOfPrimitive;
    }

    public String toEPL() {
        StringWriter writer = new StringWriter();
        this.toEPL(writer);
        return writer.toString();
    }

    public void toEPL(StringWriter writer) {
        writer.append(this.classIdentifier);
        if (this.arrayDimensions == 0 && this.typeParameters.isEmpty()) {
            return;
        }
        if (!this.typeParameters.isEmpty()) {
            writer.append("<");
            String delimiter = "";
            for (ClassDescriptor typeParameter : this.typeParameters) {
                writer.append(delimiter);
                typeParameter.toEPL(writer);
                delimiter = ",";
            }
            writer.append(">");
        }
        if (this.arrayDimensions > 0) {
            writer.append("[");
            if (this.arrayOfPrimitive) {
                writer.append(PRIMITIVE_KEYWORD);
            }
            writer.append("]");
            for (int i = 1; i < this.arrayDimensions; ++i) {
                writer.append("[]");
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassDescriptor that = (ClassDescriptor)o;
        if (this.arrayDimensions != that.arrayDimensions) {
            return false;
        }
        if (this.arrayOfPrimitive != that.arrayOfPrimitive) {
            return false;
        }
        if (!this.classIdentifier.equals(that.classIdentifier)) {
            return false;
        }
        return this.typeParameters.equals(that.typeParameters);
    }

    public int hashCode() {
        int result = this.classIdentifier.hashCode();
        result = 31 * result + this.typeParameters.hashCode();
        result = 31 * result + this.arrayDimensions;
        result = 31 * result + (this.arrayOfPrimitive ? 1 : 0);
        return result;
    }

    public String toString() {
        return "ClassIdentifierWArray{classIdentifier='" + this.classIdentifier + '\'' + ", typeParameters=" + this.typeParameters + ", arrayDimensions=" + this.arrayDimensions + ", arrayOfPrimitive=" + this.arrayOfPrimitive + '}';
    }
}

