/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.type;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.internal.type.ClassDescriptor;
import com.espertech.esper.common.internal.type.ClassDescriptorParseException;
import com.espertech.esper.common.internal.type.ClassDescriptorParserWalker;
import com.espertech.esper.common.internal.type.ClassDescriptorToken;
import com.espertech.esper.common.internal.type.ClassDescriptorTokenType;
import com.espertech.esper.common.internal.type.ClassDescriptorTokenizer;
import java.util.ArrayDeque;

public class ClassDescriptorParser {
    private static ClassDescriptorTokenizer tokenizer = new ClassDescriptorTokenizer();

    protected static ClassDescriptor parse(String classIdent) throws ClassDescriptorParseException {
        try {
            ArrayDeque<ClassDescriptorToken> tokens = tokenizer.tokenize(classIdent);
            ClassDescriptorParserWalker parser = new ClassDescriptorParserWalker(tokens);
            return parser.walk(false);
        }
        catch (ClassDescriptorParseException ex) {
            throw new EPException("Failed to parse class identifier '" + classIdent + "': " + ex.getMessage(), ex);
        }
    }

    static {
        tokenizer.add("([a-zA-Z_$][a-zA-Z\\d_$]*\\.)*[a-zA-Z_$][a-zA-Z\\d_$]*", ClassDescriptorTokenType.IDENTIFIER);
        tokenizer.add("\\[", ClassDescriptorTokenType.LEFT_BRACKET);
        tokenizer.add("\\]", ClassDescriptorTokenType.RIGHT_BRACKET);
        tokenizer.add("<", ClassDescriptorTokenType.LESSER_THAN);
        tokenizer.add(",", ClassDescriptorTokenType.COMMA);
        tokenizer.add(">", ClassDescriptorTokenType.GREATER_THAN);
    }
}

