/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.type;

import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.type.NumberSetParameter;
import java.util.HashSet;
import java.util.Set;

public class FrequencyParameter
implements NumberSetParameter {
    public static final EPTypeClass EPTYPE = new EPTypeClass(FrequencyParameter.class);
    private int frequency;
    private static final long serialVersionUID = -2303214112045704231L;

    public FrequencyParameter(int frequency) {
        this.frequency = frequency;
        if (frequency <= 0) {
            throw new IllegalArgumentException("Zero or negative value supplied as freqeuncy");
        }
    }

    public int getFrequency() {
        return this.frequency;
    }

    @Override
    public boolean isWildcard(int min, int max) {
        return this.frequency == 1;
    }

    @Override
    public Set<Integer> getValuesInRange(int min, int max) {
        HashSet<Integer> values = new HashSet<Integer>();
        int start = min - min % this.frequency;
        do {
            if (start < min) continue;
            values.add(start);
        } while ((start += this.frequency) <= max);
        return values;
    }

    @Override
    public boolean containsPoint(int point) {
        return point % this.frequency == 0;
    }

    @Override
    public String formatted() {
        return "*/" + this.frequency;
    }
}

