/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.type;

import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRef;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRelational;
import com.espertech.esper.common.internal.type.MathArithTypeEnum;
import com.espertech.esper.common.internal.util.SimpleNumberBigDecimalCoercer;
import com.espertech.esper.common.internal.util.SimpleNumberBigIntegerCoercer;
import com.espertech.esper.common.internal.util.SimpleNumberCoercerFactory;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;

public enum RelationalOpEnum {
    GT(">"),
    GE(">="),
    LT("<"),
    LE("<=");

    private static Map<RelationalOpDesc, Computer> computers;
    private String expressionText;

    private RelationalOpEnum(String expressionText) {
        this.expressionText = expressionText;
    }

    public RelationalOpEnum reversed() {
        if (GT == this) {
            return LT;
        }
        if (GE == this) {
            return LE;
        }
        if (LE == this) {
            return GE;
        }
        return GT;
    }

    public static RelationalOpEnum parse(String op) {
        if (op.equals("<")) {
            return LT;
        }
        if (op.equals(">")) {
            return GT;
        }
        if (op.equals(">=") || op.equals("=>")) {
            return GE;
        }
        if (op.equals("<=") || op.equals("=<")) {
            return LE;
        }
        throw new IllegalArgumentException("Invalid relational operator '" + op + "'");
    }

    public Computer getComputer(EPTypeClass coercedTypeClass, EPTypeClass typeOne, EPTypeClass typeTwo) {
        Class<?> coercedType = coercedTypeClass.getType();
        if (coercedType != Double.class && coercedType != Float.class && coercedType != Integer.class && coercedType != Long.class && coercedType != String.class && coercedType != BigDecimal.class && coercedType != BigInteger.class) {
            throw new IllegalArgumentException("Unsupported type for relational op compare, type " + coercedType);
        }
        if (coercedType == BigDecimal.class) {
            return this.makeBigDecimalComputer(typeOne, typeTwo);
        }
        if (coercedType == BigInteger.class) {
            return this.makeBigIntegerComputer(typeOne, typeTwo);
        }
        RelationalOpDesc key = new RelationalOpDesc(coercedTypeClass, this);
        return computers.get(key);
    }

    private Computer makeBigDecimalComputer(EPTypeClass typeOne, EPTypeClass typeTwo) {
        if (typeOne.getType() == BigDecimal.class && typeTwo.getType() == BigDecimal.class) {
            return computers.get(new RelationalOpDesc(EPTypePremade.BIGDECIMAL.getEPType(), this));
        }
        SimpleNumberBigDecimalCoercer convertorOne = SimpleNumberCoercerFactory.getCoercerBigDecimal(typeOne);
        SimpleNumberBigDecimalCoercer convertorTwo = SimpleNumberCoercerFactory.getCoercerBigDecimal(typeTwo);
        if (this == GT) {
            return new GTBigDecConvComputer(convertorOne, convertorTwo);
        }
        if (this == LT) {
            return new LTBigDecConvComputer(convertorOne, convertorTwo);
        }
        if (this == GE) {
            return new GEBigDecConvComputer(convertorOne, convertorTwo);
        }
        return new LEBigDecConvComputer(convertorOne, convertorTwo);
    }

    private Computer makeBigIntegerComputer(EPTypeClass typeOne, EPTypeClass typeTwo) {
        if (typeOne.getType() == BigInteger.class && typeTwo.getType() == BigInteger.class) {
            return computers.get(new RelationalOpDesc(EPTypePremade.BIGINTEGER.getEPType(), this));
        }
        SimpleNumberBigIntegerCoercer convertorOne = SimpleNumberCoercerFactory.getCoercerBigInteger(typeOne);
        SimpleNumberBigIntegerCoercer convertorTwo = SimpleNumberCoercerFactory.getCoercerBigInteger(typeTwo);
        if (this == GT) {
            return new GTBigIntConvComputer(convertorOne, convertorTwo);
        }
        if (this == LT) {
            return new LTBigIntConvComputer(convertorOne, convertorTwo);
        }
        if (this == GE) {
            return new GEBigIntConvComputer(convertorOne, convertorTwo);
        }
        return new LEBigIntConvComputer(convertorOne, convertorTwo);
    }

    public String getExpressionText() {
        return this.expressionText;
    }

    private static CodegenExpression codegenLong(CodegenExpression lhs, EPTypeClass lhsType, CodegenExpression rhs, EPTypeClass rhsType, RelationalOpEnum op) {
        return CodegenExpressionBuilder.op(MathArithTypeEnum.codegenAsLong(lhs, lhsType), op.getExpressionText(), MathArithTypeEnum.codegenAsLong(rhs, rhsType));
    }

    private static CodegenExpression codegenDouble(CodegenExpression lhs, EPTypeClass lhsType, CodegenExpression rhs, EPTypeClass rhsType, RelationalOpEnum op) {
        return CodegenExpressionBuilder.op(MathArithTypeEnum.codegenAsDouble(lhs, lhsType), op.getExpressionText(), MathArithTypeEnum.codegenAsDouble(rhs, rhsType));
    }

    private static CodegenExpression codegenFloat(CodegenExpression lhs, EPTypeClass lhsType, CodegenExpression rhs, EPTypeClass rhsType, RelationalOpEnum op) {
        return CodegenExpressionBuilder.op(MathArithTypeEnum.codegenAsFloat(lhs, lhsType), op.getExpressionText(), MathArithTypeEnum.codegenAsFloat(rhs, rhsType));
    }

    private static CodegenExpression codegenInt(CodegenExpression lhs, EPTypeClass lhsType, CodegenExpression rhs, EPTypeClass rhsType, RelationalOpEnum op) {
        return CodegenExpressionBuilder.op(MathArithTypeEnum.codegenAsInt(lhs, lhsType), op.getExpressionText(), MathArithTypeEnum.codegenAsInt(rhs, rhsType));
    }

    private static CodegenExpression codegenStringCompare(CodegenExpression lhs, EPTypeClass lhsType, CodegenExpression rhs, EPTypeClass rhsType, CodegenExpressionRelational.CodegenRelational rel) {
        return CodegenExpressionBuilder.relational(CodegenExpressionBuilder.exprDotMethod(RelationalOpEnum.codegenAsString(lhs, lhsType), "compareTo", RelationalOpEnum.codegenAsString(rhs, rhsType)), rel, CodegenExpressionBuilder.constant(0));
    }

    private static CodegenExpression codegenAsString(CodegenExpression ref, EPTypeClass type) {
        if (type.getType() == String.class) {
            return ref;
        }
        return CodegenExpressionBuilder.cast(EPTypePremade.STRING.getEPType(), ref);
    }

    private static CodegenExpression codegenBigIntBigDecPlain(CodegenExpression lhs, CodegenExpression rhs, CodegenExpressionRelational.CodegenRelational rel) {
        return CodegenExpressionBuilder.relational(CodegenExpressionBuilder.exprDotMethod(lhs, "compareTo", rhs), rel, CodegenExpressionBuilder.constant(0));
    }

    private static CodegenExpression codegenBigDecConv(CodegenExpression lhs, EPTypeClass lhsType, CodegenExpression rhs, EPTypeClass rhsType, SimpleNumberBigDecimalCoercer convLeft, SimpleNumberBigDecimalCoercer convRight, CodegenExpressionRelational.CodegenRelational rel) {
        CodegenExpression leftConv = convLeft.coerceBoxedBigDecCodegen(lhs, lhsType);
        CodegenExpression rightConv = convRight.coerceBoxedBigDecCodegen(rhs, rhsType);
        return CodegenExpressionBuilder.relational(CodegenExpressionBuilder.exprDotMethod(leftConv, "compareTo", rightConv), rel, CodegenExpressionBuilder.constant(0));
    }

    private static CodegenExpression codegenBigIntConv(CodegenExpression lhs, EPTypeClass lhsType, CodegenExpression rhs, EPTypeClass rhsType, SimpleNumberBigIntegerCoercer convLeft, SimpleNumberBigIntegerCoercer convRight, CodegenExpressionRelational.CodegenRelational rel) {
        CodegenExpression leftConv = convLeft.coerceBoxedBigIntCodegen(lhs, lhsType);
        CodegenExpression rightConv = convRight.coerceBoxedBigIntCodegen(rhs, rhsType);
        return CodegenExpressionBuilder.relational(CodegenExpressionBuilder.exprDotMethod(leftConv, "compareTo", rightConv), rel, CodegenExpressionBuilder.constant(0));
    }

    static {
        computers = new HashMap<RelationalOpDesc, Computer>();
        computers.put(new RelationalOpDesc(EPTypePremade.STRING.getEPType(), GT), new GTStringComputer());
        computers.put(new RelationalOpDesc(EPTypePremade.STRING.getEPType(), GE), new GEStringComputer());
        computers.put(new RelationalOpDesc(EPTypePremade.STRING.getEPType(), LT), new LTStringComputer());
        computers.put(new RelationalOpDesc(EPTypePremade.STRING.getEPType(), LE), new LEStringComputer());
        computers.put(new RelationalOpDesc(EPTypePremade.INTEGERBOXED.getEPType(), GT), new GTIntegerComputer());
        computers.put(new RelationalOpDesc(EPTypePremade.INTEGERBOXED.getEPType(), GE), new GEIntegerComputer());
        computers.put(new RelationalOpDesc(EPTypePremade.INTEGERBOXED.getEPType(), LT), new LTIntegerComputer());
        computers.put(new RelationalOpDesc(EPTypePremade.INTEGERBOXED.getEPType(), LE), new LEIntegerComputer());
        computers.put(new RelationalOpDesc(EPTypePremade.LONGBOXED.getEPType(), GT), new GTLongComputer());
        computers.put(new RelationalOpDesc(EPTypePremade.LONGBOXED.getEPType(), GE), new GELongComputer());
        computers.put(new RelationalOpDesc(EPTypePremade.LONGBOXED.getEPType(), LT), new LTLongComputer());
        computers.put(new RelationalOpDesc(EPTypePremade.LONGBOXED.getEPType(), LE), new LELongComputer());
        computers.put(new RelationalOpDesc(EPTypePremade.DOUBLEBOXED.getEPType(), GT), new GTDoubleComputer());
        computers.put(new RelationalOpDesc(EPTypePremade.DOUBLEBOXED.getEPType(), GE), new GEDoubleComputer());
        computers.put(new RelationalOpDesc(EPTypePremade.DOUBLEBOXED.getEPType(), LT), new LTDoubleComputer());
        computers.put(new RelationalOpDesc(EPTypePremade.DOUBLEBOXED.getEPType(), LE), new LEDoubleComputer());
        computers.put(new RelationalOpDesc(EPTypePremade.FLOATBOXED.getEPType(), GT), new GTFloatComputer());
        computers.put(new RelationalOpDesc(EPTypePremade.FLOATBOXED.getEPType(), GE), new GEFloatComputer());
        computers.put(new RelationalOpDesc(EPTypePremade.FLOATBOXED.getEPType(), LT), new LTFloatComputer());
        computers.put(new RelationalOpDesc(EPTypePremade.FLOATBOXED.getEPType(), LE), new LEFloatComputer());
        computers.put(new RelationalOpDesc(EPTypePremade.BIGDECIMAL.getEPType(), GT), new GTBigDecComputer());
        computers.put(new RelationalOpDesc(EPTypePremade.BIGDECIMAL.getEPType(), GE), new GEBigDecComputer());
        computers.put(new RelationalOpDesc(EPTypePremade.BIGDECIMAL.getEPType(), LT), new LTBigDecComputer());
        computers.put(new RelationalOpDesc(EPTypePremade.BIGDECIMAL.getEPType(), LE), new LEBigDecComputer());
        computers.put(new RelationalOpDesc(EPTypePremade.BIGINTEGER.getEPType(), GT), new GTBigIntComputer());
        computers.put(new RelationalOpDesc(EPTypePremade.BIGINTEGER.getEPType(), GE), new GEBigIntComputer());
        computers.put(new RelationalOpDesc(EPTypePremade.BIGINTEGER.getEPType(), LT), new LTBigIntComputer());
        computers.put(new RelationalOpDesc(EPTypePremade.BIGINTEGER.getEPType(), LE), new LEBigIntComputer());
    }

    public static class RelationalOpDesc {
        private final EPTypeClass type;
        private final RelationalOpEnum op;

        public RelationalOpDesc(EPTypeClass type, RelationalOpEnum op) {
            this.type = type;
            this.op = op;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RelationalOpDesc that = (RelationalOpDesc)o;
            if (!this.type.equals(that.type)) {
                return false;
            }
            return this.op == that.op;
        }

        public int hashCode() {
            int result = this.type.hashCode();
            result = 31 * result + this.op.hashCode();
            return result;
        }
    }

    public static class LTBigDecConvComputer
    implements Computer {
        private final SimpleNumberBigDecimalCoercer convOne;
        private final SimpleNumberBigDecimalCoercer convTwo;

        public LTBigDecConvComputer(SimpleNumberBigDecimalCoercer convOne, SimpleNumberBigDecimalCoercer convTwo) {
            this.convOne = convOne;
            this.convTwo = convTwo;
        }

        @Override
        public boolean compare(Object objOne, Object objTwo) {
            BigDecimal s2;
            BigDecimal s1 = this.convOne.coerceBoxedBigDec((Number)objOne);
            return s1.compareTo(s2 = this.convTwo.coerceBoxedBigDec((Number)objTwo)) < 0;
        }

        @Override
        public CodegenExpression codegen(CodegenExpressionRef lhs, EPTypeClass lhsType, CodegenExpression rhs, EPTypeClass rhsType) {
            return RelationalOpEnum.codegenBigDecConv(lhs, lhsType, rhs, rhsType, this.convOne, this.convTwo, CodegenExpressionRelational.CodegenRelational.LT);
        }
    }

    public static class LEBigDecConvComputer
    implements Computer {
        private final SimpleNumberBigDecimalCoercer convOne;
        private final SimpleNumberBigDecimalCoercer convTwo;

        public LEBigDecConvComputer(SimpleNumberBigDecimalCoercer convOne, SimpleNumberBigDecimalCoercer convTwo) {
            this.convOne = convOne;
            this.convTwo = convTwo;
        }

        @Override
        public boolean compare(Object objOne, Object objTwo) {
            BigDecimal s2;
            BigDecimal s1 = this.convOne.coerceBoxedBigDec((Number)objOne);
            return s1.compareTo(s2 = this.convTwo.coerceBoxedBigDec((Number)objTwo)) <= 0;
        }

        @Override
        public CodegenExpression codegen(CodegenExpressionRef lhs, EPTypeClass lhsType, CodegenExpression rhs, EPTypeClass rhsType) {
            return RelationalOpEnum.codegenBigDecConv(lhs, lhsType, rhs, rhsType, this.convOne, this.convTwo, CodegenExpressionRelational.CodegenRelational.LE);
        }
    }

    public static class GEBigDecConvComputer
    implements Computer {
        private final SimpleNumberBigDecimalCoercer convOne;
        private final SimpleNumberBigDecimalCoercer convTwo;

        public GEBigDecConvComputer(SimpleNumberBigDecimalCoercer convOne, SimpleNumberBigDecimalCoercer convTwo) {
            this.convOne = convOne;
            this.convTwo = convTwo;
        }

        @Override
        public boolean compare(Object objOne, Object objTwo) {
            BigDecimal s2;
            BigDecimal s1 = this.convOne.coerceBoxedBigDec((Number)objOne);
            return s1.compareTo(s2 = this.convTwo.coerceBoxedBigDec((Number)objTwo)) >= 0;
        }

        @Override
        public CodegenExpression codegen(CodegenExpressionRef lhs, EPTypeClass lhsType, CodegenExpression rhs, EPTypeClass rhsType) {
            return RelationalOpEnum.codegenBigDecConv(lhs, lhsType, rhs, rhsType, this.convOne, this.convTwo, CodegenExpressionRelational.CodegenRelational.GE);
        }
    }

    public static class GTBigDecConvComputer
    implements Computer {
        private final SimpleNumberBigDecimalCoercer convOne;
        private final SimpleNumberBigDecimalCoercer convTwo;

        public GTBigDecConvComputer(SimpleNumberBigDecimalCoercer convOne, SimpleNumberBigDecimalCoercer convTwo) {
            this.convOne = convOne;
            this.convTwo = convTwo;
        }

        @Override
        public boolean compare(Object objOne, Object objTwo) {
            BigDecimal s2;
            BigDecimal s1 = this.convOne.coerceBoxedBigDec((Number)objOne);
            int result = s1.compareTo(s2 = this.convTwo.coerceBoxedBigDec((Number)objTwo));
            return result > 0;
        }

        @Override
        public CodegenExpression codegen(CodegenExpressionRef lhs, EPTypeClass lhsType, CodegenExpression rhs, EPTypeClass rhsType) {
            return RelationalOpEnum.codegenBigDecConv(lhs, lhsType, rhs, rhsType, this.convOne, this.convTwo, CodegenExpressionRelational.CodegenRelational.GT);
        }
    }

    public static class LTBigIntConvComputer
    implements Computer {
        private final SimpleNumberBigIntegerCoercer convOne;
        private final SimpleNumberBigIntegerCoercer convTwo;

        public LTBigIntConvComputer(SimpleNumberBigIntegerCoercer convOne, SimpleNumberBigIntegerCoercer convTwo) {
            this.convOne = convOne;
            this.convTwo = convTwo;
        }

        @Override
        public boolean compare(Object objOne, Object objTwo) {
            BigInteger s2;
            BigInteger s1 = this.convOne.coerceBoxedBigInt((Number)objOne);
            return s1.compareTo(s2 = this.convTwo.coerceBoxedBigInt((Number)objTwo)) < 0;
        }

        @Override
        public CodegenExpression codegen(CodegenExpressionRef lhs, EPTypeClass lhsType, CodegenExpression rhs, EPTypeClass rhsType) {
            return RelationalOpEnum.codegenBigIntConv(lhs, lhsType, rhs, rhsType, this.convOne, this.convTwo, CodegenExpressionRelational.CodegenRelational.LT);
        }
    }

    public static class LEBigIntConvComputer
    implements Computer {
        private final SimpleNumberBigIntegerCoercer convOne;
        private final SimpleNumberBigIntegerCoercer convTwo;

        public LEBigIntConvComputer(SimpleNumberBigIntegerCoercer convOne, SimpleNumberBigIntegerCoercer convTwo) {
            this.convOne = convOne;
            this.convTwo = convTwo;
        }

        @Override
        public boolean compare(Object objOne, Object objTwo) {
            BigInteger s2;
            BigInteger s1 = this.convOne.coerceBoxedBigInt((Number)objOne);
            return s1.compareTo(s2 = this.convTwo.coerceBoxedBigInt((Number)objTwo)) <= 0;
        }

        @Override
        public CodegenExpression codegen(CodegenExpressionRef lhs, EPTypeClass lhsType, CodegenExpression rhs, EPTypeClass rhsType) {
            return RelationalOpEnum.codegenBigIntConv(lhs, lhsType, rhs, rhsType, this.convOne, this.convTwo, CodegenExpressionRelational.CodegenRelational.LE);
        }
    }

    public static class GEBigIntConvComputer
    implements Computer {
        private final SimpleNumberBigIntegerCoercer convOne;
        private final SimpleNumberBigIntegerCoercer convTwo;

        public GEBigIntConvComputer(SimpleNumberBigIntegerCoercer convOne, SimpleNumberBigIntegerCoercer convTwo) {
            this.convOne = convOne;
            this.convTwo = convTwo;
        }

        @Override
        public boolean compare(Object objOne, Object objTwo) {
            BigInteger s2;
            BigInteger s1 = this.convOne.coerceBoxedBigInt((Number)objOne);
            return s1.compareTo(s2 = this.convTwo.coerceBoxedBigInt((Number)objTwo)) >= 0;
        }

        @Override
        public CodegenExpression codegen(CodegenExpressionRef lhs, EPTypeClass lhsType, CodegenExpression rhs, EPTypeClass rhsType) {
            return RelationalOpEnum.codegenBigIntConv(lhs, lhsType, rhs, rhsType, this.convOne, this.convTwo, CodegenExpressionRelational.CodegenRelational.GE);
        }
    }

    public static class GTBigIntConvComputer
    implements Computer {
        private final SimpleNumberBigIntegerCoercer convOne;
        private final SimpleNumberBigIntegerCoercer convTwo;

        public GTBigIntConvComputer(SimpleNumberBigIntegerCoercer convOne, SimpleNumberBigIntegerCoercer convTwo) {
            this.convOne = convOne;
            this.convTwo = convTwo;
        }

        @Override
        public boolean compare(Object objOne, Object objTwo) {
            BigInteger s2;
            BigInteger s1 = this.convOne.coerceBoxedBigInt((Number)objOne);
            int result = s1.compareTo(s2 = this.convTwo.coerceBoxedBigInt((Number)objTwo));
            return result > 0;
        }

        @Override
        public CodegenExpression codegen(CodegenExpressionRef lhs, EPTypeClass lhsType, CodegenExpression rhs, EPTypeClass rhsType) {
            return RelationalOpEnum.codegenBigIntConv(lhs, lhsType, rhs, rhsType, this.convOne, this.convTwo, CodegenExpressionRelational.CodegenRelational.GT);
        }
    }

    public static class LTBigIntComputer
    implements Computer {
        @Override
        public boolean compare(Object objOne, Object objTwo) {
            BigInteger s1 = (BigInteger)objOne;
            BigInteger s2 = (BigInteger)objTwo;
            return s1.compareTo(s2) < 0;
        }

        @Override
        public CodegenExpression codegen(CodegenExpressionRef lhs, EPTypeClass lhsType, CodegenExpression rhs, EPTypeClass rhsType) {
            return RelationalOpEnum.codegenBigIntBigDecPlain(lhs, rhs, CodegenExpressionRelational.CodegenRelational.LT);
        }
    }

    public static class LEBigIntComputer
    implements Computer {
        @Override
        public boolean compare(Object objOne, Object objTwo) {
            BigInteger s1 = (BigInteger)objOne;
            BigInteger s2 = (BigInteger)objTwo;
            return s1.compareTo(s2) <= 0;
        }

        @Override
        public CodegenExpression codegen(CodegenExpressionRef lhs, EPTypeClass lhsType, CodegenExpression rhs, EPTypeClass rhsType) {
            return RelationalOpEnum.codegenBigIntBigDecPlain(lhs, rhs, CodegenExpressionRelational.CodegenRelational.LE);
        }
    }

    public static class GEBigIntComputer
    implements Computer {
        @Override
        public boolean compare(Object objOne, Object objTwo) {
            BigInteger s1 = (BigInteger)objOne;
            BigInteger s2 = (BigInteger)objTwo;
            return s1.compareTo(s2) >= 0;
        }

        @Override
        public CodegenExpression codegen(CodegenExpressionRef lhs, EPTypeClass lhsType, CodegenExpression rhs, EPTypeClass rhsType) {
            return RelationalOpEnum.codegenBigIntBigDecPlain(lhs, rhs, CodegenExpressionRelational.CodegenRelational.GE);
        }
    }

    public static class GTBigIntComputer
    implements Computer {
        @Override
        public boolean compare(Object objOne, Object objTwo) {
            BigInteger s1 = (BigInteger)objOne;
            BigInteger s2 = (BigInteger)objTwo;
            int result = s1.compareTo(s2);
            return result > 0;
        }

        @Override
        public CodegenExpression codegen(CodegenExpressionRef lhs, EPTypeClass lhsType, CodegenExpression rhs, EPTypeClass rhsType) {
            return RelationalOpEnum.codegenBigIntBigDecPlain(lhs, rhs, CodegenExpressionRelational.CodegenRelational.GT);
        }
    }

    public static class LTBigDecComputer
    implements Computer {
        @Override
        public boolean compare(Object objOne, Object objTwo) {
            BigDecimal s1 = (BigDecimal)objOne;
            BigDecimal s2 = (BigDecimal)objTwo;
            return s1.compareTo(s2) < 0;
        }

        @Override
        public CodegenExpression codegen(CodegenExpressionRef lhs, EPTypeClass lhsType, CodegenExpression rhs, EPTypeClass rhsType) {
            return RelationalOpEnum.codegenBigIntBigDecPlain(lhs, rhs, CodegenExpressionRelational.CodegenRelational.LT);
        }
    }

    public static class LEBigDecComputer
    implements Computer {
        @Override
        public boolean compare(Object objOne, Object objTwo) {
            BigDecimal s1 = (BigDecimal)objOne;
            BigDecimal s2 = (BigDecimal)objTwo;
            return s1.compareTo(s2) <= 0;
        }

        @Override
        public CodegenExpression codegen(CodegenExpressionRef lhs, EPTypeClass lhsType, CodegenExpression rhs, EPTypeClass rhsType) {
            return RelationalOpEnum.codegenBigIntBigDecPlain(lhs, rhs, CodegenExpressionRelational.CodegenRelational.LE);
        }
    }

    public static class GEBigDecComputer
    implements Computer {
        @Override
        public boolean compare(Object objOne, Object objTwo) {
            BigDecimal s1 = (BigDecimal)objOne;
            BigDecimal s2 = (BigDecimal)objTwo;
            return s1.compareTo(s2) >= 0;
        }

        @Override
        public CodegenExpression codegen(CodegenExpressionRef lhs, EPTypeClass lhsType, CodegenExpression rhs, EPTypeClass rhsType) {
            return RelationalOpEnum.codegenBigIntBigDecPlain(lhs, rhs, CodegenExpressionRelational.CodegenRelational.GE);
        }
    }

    public static class GTBigDecComputer
    implements Computer {
        @Override
        public boolean compare(Object objOne, Object objTwo) {
            BigDecimal s1 = (BigDecimal)objOne;
            BigDecimal s2 = (BigDecimal)objTwo;
            int result = s1.compareTo(s2);
            return result > 0;
        }

        @Override
        public CodegenExpression codegen(CodegenExpressionRef lhs, EPTypeClass lhsType, CodegenExpression rhs, EPTypeClass rhsType) {
            return RelationalOpEnum.codegenBigIntBigDecPlain(lhs, rhs, CodegenExpressionRelational.CodegenRelational.GT);
        }
    }

    public static class LEFloatComputer
    implements Computer {
        @Override
        public boolean compare(Object objOne, Object objTwo) {
            Number s1 = (Number)objOne;
            Number s2 = (Number)objTwo;
            return s1.floatValue() <= s2.floatValue();
        }

        @Override
        public CodegenExpression codegen(CodegenExpressionRef lhs, EPTypeClass lhsType, CodegenExpression rhs, EPTypeClass rhsType) {
            return RelationalOpEnum.codegenFloat(lhs, lhsType, rhs, rhsType, LE);
        }
    }

    public static class LTFloatComputer
    implements Computer {
        @Override
        public boolean compare(Object objOne, Object objTwo) {
            Number s1 = (Number)objOne;
            Number s2 = (Number)objTwo;
            return s1.floatValue() < s2.floatValue();
        }

        @Override
        public CodegenExpression codegen(CodegenExpressionRef lhs, EPTypeClass lhsType, CodegenExpression rhs, EPTypeClass rhsType) {
            return RelationalOpEnum.codegenFloat(lhs, lhsType, rhs, rhsType, LT);
        }
    }

    public static class GEFloatComputer
    implements Computer {
        @Override
        public boolean compare(Object objOne, Object objTwo) {
            Number s1 = (Number)objOne;
            Number s2 = (Number)objTwo;
            return s1.floatValue() >= s2.floatValue();
        }

        @Override
        public CodegenExpression codegen(CodegenExpressionRef lhs, EPTypeClass lhsType, CodegenExpression rhs, EPTypeClass rhsType) {
            return RelationalOpEnum.codegenFloat(lhs, lhsType, rhs, rhsType, GE);
        }
    }

    public static class GTFloatComputer
    implements Computer {
        @Override
        public boolean compare(Object objOne, Object objTwo) {
            Number s1 = (Number)objOne;
            Number s2 = (Number)objTwo;
            return s1.floatValue() > s2.floatValue();
        }

        @Override
        public CodegenExpression codegen(CodegenExpressionRef lhs, EPTypeClass lhsType, CodegenExpression rhs, EPTypeClass rhsType) {
            return RelationalOpEnum.codegenFloat(lhs, lhsType, rhs, rhsType, GT);
        }
    }

    public static class LEDoubleComputer
    implements Computer {
        @Override
        public boolean compare(Object objOne, Object objTwo) {
            Number s1 = (Number)objOne;
            Number s2 = (Number)objTwo;
            return s1.doubleValue() <= s2.doubleValue();
        }

        @Override
        public CodegenExpression codegen(CodegenExpressionRef lhs, EPTypeClass lhsType, CodegenExpression rhs, EPTypeClass rhsType) {
            return RelationalOpEnum.codegenDouble(lhs, lhsType, rhs, rhsType, LE);
        }
    }

    public static class LTDoubleComputer
    implements Computer {
        @Override
        public boolean compare(Object objOne, Object objTwo) {
            Number s1 = (Number)objOne;
            Number s2 = (Number)objTwo;
            return s1.doubleValue() < s2.doubleValue();
        }

        @Override
        public CodegenExpression codegen(CodegenExpressionRef lhs, EPTypeClass lhsType, CodegenExpression rhs, EPTypeClass rhsType) {
            return RelationalOpEnum.codegenDouble(lhs, lhsType, rhs, rhsType, LT);
        }
    }

    public static class GEDoubleComputer
    implements Computer {
        @Override
        public boolean compare(Object objOne, Object objTwo) {
            Number s1 = (Number)objOne;
            Number s2 = (Number)objTwo;
            return s1.doubleValue() >= s2.doubleValue();
        }

        @Override
        public CodegenExpression codegen(CodegenExpressionRef lhs, EPTypeClass lhsType, CodegenExpression rhs, EPTypeClass rhsType) {
            return RelationalOpEnum.codegenDouble(lhs, lhsType, rhs, rhsType, GE);
        }
    }

    public static class GTDoubleComputer
    implements Computer {
        @Override
        public boolean compare(Object objOne, Object objTwo) {
            Number s1 = (Number)objOne;
            Number s2 = (Number)objTwo;
            return s1.doubleValue() > s2.doubleValue();
        }

        @Override
        public CodegenExpression codegen(CodegenExpressionRef lhs, EPTypeClass lhsType, CodegenExpression rhs, EPTypeClass rhsType) {
            return RelationalOpEnum.codegenDouble(lhs, lhsType, rhs, rhsType, GT);
        }
    }

    public static class LEIntegerComputer
    implements Computer {
        @Override
        public boolean compare(Object objOne, Object objTwo) {
            Number s1 = (Number)objOne;
            Number s2 = (Number)objTwo;
            return s1.intValue() <= s2.intValue();
        }

        @Override
        public CodegenExpression codegen(CodegenExpressionRef lhs, EPTypeClass lhsType, CodegenExpression rhs, EPTypeClass rhsType) {
            return RelationalOpEnum.codegenInt(lhs, lhsType, rhs, rhsType, LE);
        }
    }

    public static class LTIntegerComputer
    implements Computer {
        @Override
        public boolean compare(Object objOne, Object objTwo) {
            Number s1 = (Number)objOne;
            Number s2 = (Number)objTwo;
            return s1.intValue() < s2.intValue();
        }

        @Override
        public CodegenExpression codegen(CodegenExpressionRef lhs, EPTypeClass lhsType, CodegenExpression rhs, EPTypeClass rhsType) {
            return RelationalOpEnum.codegenInt(lhs, lhsType, rhs, rhsType, LT);
        }
    }

    public static class GEIntegerComputer
    implements Computer {
        @Override
        public boolean compare(Object objOne, Object objTwo) {
            Number s1 = (Number)objOne;
            Number s2 = (Number)objTwo;
            return s1.intValue() >= s2.intValue();
        }

        @Override
        public CodegenExpression codegen(CodegenExpressionRef lhs, EPTypeClass lhsType, CodegenExpression rhs, EPTypeClass rhsType) {
            return RelationalOpEnum.codegenInt(lhs, lhsType, rhs, rhsType, GE);
        }
    }

    public static class GTIntegerComputer
    implements Computer {
        @Override
        public boolean compare(Object objOne, Object objTwo) {
            Number s1 = (Number)objOne;
            Number s2 = (Number)objTwo;
            return s1.intValue() > s2.intValue();
        }

        @Override
        public CodegenExpression codegen(CodegenExpressionRef lhs, EPTypeClass lhsType, CodegenExpression rhs, EPTypeClass rhsType) {
            return RelationalOpEnum.codegenInt(lhs, lhsType, rhs, rhsType, GT);
        }
    }

    public static class LELongComputer
    implements Computer {
        @Override
        public boolean compare(Object objOne, Object objTwo) {
            Number s1 = (Number)objOne;
            Number s2 = (Number)objTwo;
            return s1.longValue() <= s2.longValue();
        }

        @Override
        public CodegenExpression codegen(CodegenExpressionRef lhs, EPTypeClass lhsType, CodegenExpression rhs, EPTypeClass rhsType) {
            return RelationalOpEnum.codegenLong(lhs, lhsType, rhs, rhsType, LE);
        }
    }

    public static class LTLongComputer
    implements Computer {
        @Override
        public boolean compare(Object objOne, Object objTwo) {
            Number s1 = (Number)objOne;
            Number s2 = (Number)objTwo;
            return s1.longValue() < s2.longValue();
        }

        @Override
        public CodegenExpression codegen(CodegenExpressionRef lhs, EPTypeClass lhsType, CodegenExpression rhs, EPTypeClass rhsType) {
            return RelationalOpEnum.codegenLong(lhs, lhsType, rhs, rhsType, LT);
        }
    }

    public static class GELongComputer
    implements Computer {
        @Override
        public boolean compare(Object objOne, Object objTwo) {
            Number s1 = (Number)objOne;
            Number s2 = (Number)objTwo;
            return s1.longValue() >= s2.longValue();
        }

        @Override
        public CodegenExpression codegen(CodegenExpressionRef lhs, EPTypeClass lhsType, CodegenExpression rhs, EPTypeClass rhsType) {
            return RelationalOpEnum.codegenLong(lhs, lhsType, rhs, rhsType, GE);
        }
    }

    public static class GTLongComputer
    implements Computer {
        @Override
        public boolean compare(Object objOne, Object objTwo) {
            Number s1 = (Number)objOne;
            Number s2 = (Number)objTwo;
            return s1.longValue() > s2.longValue();
        }

        @Override
        public CodegenExpression codegen(CodegenExpressionRef lhs, EPTypeClass lhsType, CodegenExpression rhs, EPTypeClass rhsType) {
            return RelationalOpEnum.codegenLong(lhs, lhsType, rhs, rhsType, GT);
        }
    }

    public static class LTStringComputer
    implements Computer {
        @Override
        public boolean compare(Object objOne, Object objTwo) {
            String s1 = (String)objOne;
            String s2 = (String)objTwo;
            return s1.compareTo(s2) < 0;
        }

        @Override
        public CodegenExpression codegen(CodegenExpressionRef lhs, EPTypeClass lhsType, CodegenExpression rhs, EPTypeClass rhsType) {
            return RelationalOpEnum.codegenStringCompare(lhs, lhsType, rhs, rhsType, CodegenExpressionRelational.CodegenRelational.LT);
        }
    }

    public static class LEStringComputer
    implements Computer {
        @Override
        public boolean compare(Object objOne, Object objTwo) {
            String s1 = (String)objOne;
            String s2 = (String)objTwo;
            return s1.compareTo(s2) <= 0;
        }

        @Override
        public CodegenExpression codegen(CodegenExpressionRef lhs, EPTypeClass lhsType, CodegenExpression rhs, EPTypeClass rhsType) {
            return RelationalOpEnum.codegenStringCompare(lhs, lhsType, rhs, rhsType, CodegenExpressionRelational.CodegenRelational.LE);
        }
    }

    public static class GEStringComputer
    implements Computer {
        @Override
        public boolean compare(Object objOne, Object objTwo) {
            String s1 = (String)objOne;
            String s2 = (String)objTwo;
            return s1.compareTo(s2) >= 0;
        }

        @Override
        public CodegenExpression codegen(CodegenExpressionRef lhs, EPTypeClass lhsType, CodegenExpression rhs, EPTypeClass rhsType) {
            return RelationalOpEnum.codegenStringCompare(lhs, lhsType, rhs, rhsType, CodegenExpressionRelational.CodegenRelational.GE);
        }
    }

    public static class GTStringComputer
    implements Computer {
        @Override
        public boolean compare(Object objOne, Object objTwo) {
            String s1 = (String)objOne;
            String s2 = (String)objTwo;
            int result = s1.compareTo(s2);
            return result > 0;
        }

        @Override
        public CodegenExpression codegen(CodegenExpressionRef lhs, EPTypeClass lhsType, CodegenExpression rhs, EPTypeClass rhsType) {
            return RelationalOpEnum.codegenStringCompare(lhs, lhsType, rhs, rhsType, CodegenExpressionRelational.CodegenRelational.GT);
        }
    }

    public static interface Computer {
        public boolean compare(Object var1, Object var2);

        public CodegenExpression codegen(CodegenExpressionRef var1, EPTypeClass var2, CodegenExpression var3, EPTypeClass var4);
    }
}

