/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.util;

import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypeNull;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.io.StringWriter;
import java.util.HashSet;
import java.util.Set;

public class ClassHelperPrint {
    private static final Set<EPTypePremade> BASETYPES = new HashSet<EPTypePremade>();

    public static String getClassNameFullyQualPrettyObject(Object value) {
        return value == null ? EPTypeNull.INSTANCE.getTypeName() : ClassHelperPrint.getClassNameFullyQualPretty(value.getClass());
    }

    public static String getClassNameFullyQualPretty(EPType type) {
        return type == null ? EPTypeNull.INSTANCE.getTypeName() : type.getTypeName();
    }

    public static String getClassNameFullyQualPretty(Class clazz) {
        if (clazz == null) {
            return EPTypeNull.INSTANCE.getTypeName();
        }
        String className = ClassHelperPrint.getClassNameNonArray(JavaClassHelper.getArrayComponentTypeInnermost(clazz));
        if (!clazz.isArray()) {
            return className;
        }
        StringWriter buf = new StringWriter();
        buf.append(className);
        ClassHelperPrint.appendDimensions(buf, clazz);
        return buf.toString();
    }

    public static String getClassNameFullyQualPrettyWithClassloader(Class clazz) {
        String name = ClassHelperPrint.getClassNameFullyQualPretty(clazz);
        String classloader = ClassHelperPrint.getClassLoaderId(clazz.getClassLoader());
        return name + "(loaded by " + classloader + ")";
    }

    public static String getClassLoaderId(ClassLoader classLoader) {
        if (classLoader == null) {
            return "(classloader is null)";
        }
        return classLoader.getClass().getName() + "@" + System.identityHashCode(classLoader);
    }

    public static void appendDimensions(StringWriter writer, Class typeClass) {
        int numDimensions = JavaClassHelper.getArrayDimensions(typeClass);
        for (int i = 0; i < numDimensions; ++i) {
            writer.append("[]");
        }
    }

    private static String getClassNameNonArray(Class clazz) {
        if (clazz == null) {
            return EPTypeNull.INSTANCE.getTypeName();
        }
        EPTypePremade premade = EPTypePremade.getExisting(clazz);
        if (premade != null && ClassHelperPrint.isBaseType(premade)) {
            return premade.getEPType().getType().getSimpleName();
        }
        return clazz.getName();
    }

    private static boolean isBaseType(EPTypePremade premade) {
        return BASETYPES.contains((Object)premade);
    }

    public static String getParameterAsString(Class[] parameters) {
        StringBuilder builder = new StringBuilder();
        String delimiterComma = ", ";
        String delimiter = "";
        for (Class param : parameters) {
            builder.append(delimiter);
            builder.append(ClassHelperPrint.getParameterAsString(param));
            delimiter = delimiterComma;
        }
        return builder.toString();
    }

    public static String getParameterAsString(EPType[] parameters) {
        StringBuilder builder = new StringBuilder();
        String delimiterComma = ", ";
        String delimiter = "";
        for (EPType param : parameters) {
            builder.append(delimiter);
            builder.append(ClassHelperPrint.getParameterAsString(param));
            delimiter = delimiterComma;
        }
        return builder.toString();
    }

    public static String getParameterAsString(Class param) {
        if (param == null) {
            return EPTypeNull.INSTANCE.getTypeName();
        }
        return param.getSimpleName();
    }

    public static String getParameterAsString(EPType param) {
        if (param == null || param == EPTypeNull.INSTANCE) {
            return EPTypeNull.INSTANCE.getTypeName();
        }
        return ((EPTypeClass)param).getType().getSimpleName();
    }

    static {
        BASETYPES.add(EPTypePremade.BYTEPRIMITIVE);
        BASETYPES.add(EPTypePremade.CHARPRIMITIVE);
        BASETYPES.add(EPTypePremade.SHORTPRIMITIVE);
        BASETYPES.add(EPTypePremade.INTEGERPRIMITIVE);
        BASETYPES.add(EPTypePremade.LONGPRIMITIVE);
        BASETYPES.add(EPTypePremade.DOUBLEPRIMITIVE);
        BASETYPES.add(EPTypePremade.FLOATPRIMITIVE);
        BASETYPES.add(EPTypePremade.BOOLEANBOXED);
        BASETYPES.add(EPTypePremade.BYTEBOXED);
        BASETYPES.add(EPTypePremade.CHARBOXED);
        BASETYPES.add(EPTypePremade.SHORTBOXED);
        BASETYPES.add(EPTypePremade.INTEGERBOXED);
        BASETYPES.add(EPTypePremade.LONGBOXED);
        BASETYPES.add(EPTypePremade.DOUBLEBOXED);
        BASETYPES.add(EPTypePremade.FLOATBOXED);
        BASETYPES.add(EPTypePremade.BIGINTEGER);
        BASETYPES.add(EPTypePremade.BIGDECIMAL);
        BASETYPES.add(EPTypePremade.BIGINTEGERARRAY);
        BASETYPES.add(EPTypePremade.BIGDECIMALARRAY);
        BASETYPES.add(EPTypePremade.BIGINTEGERARRAYARRAY);
        BASETYPES.add(EPTypePremade.BIGDECIMALARRAYARRAY);
        BASETYPES.add(EPTypePremade.STRING);
        BASETYPES.add(EPTypePremade.NUMBER);
        BASETYPES.add(EPTypePremade.OBJECT);
        BASETYPES.add(EPTypePremade.VOID);
    }
}

