/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.util;

import com.espertech.esper.common.client.util.HashableMultiKey;
import com.espertech.esper.common.internal.util.CollectionUtil;
import java.io.Serializable;
import java.text.Collator;
import java.util.Comparator;

public final class ComparatorHashableMultiKeyCollating
implements Comparator<HashableMultiKey>,
Serializable {
    private final boolean[] isDescendingValues;
    private final boolean[] stringTypedValue;
    private transient Collator collator = null;
    private static final long serialVersionUID = -1166857207888935691L;

    public ComparatorHashableMultiKeyCollating(boolean[] isDescendingValues, boolean[] stringTypeValues) {
        this.isDescendingValues = isDescendingValues;
        this.stringTypedValue = stringTypeValues;
        this.collator = Collator.getInstance();
    }

    @Override
    public final int compare(HashableMultiKey firstValues, HashableMultiKey secondValues) {
        if (firstValues.size() != this.isDescendingValues.length || secondValues.size() != this.isDescendingValues.length) {
            throw new IllegalArgumentException("Incompatible size MultiKey sizes for comparison");
        }
        for (int i = 0; i < firstValues.size(); ++i) {
            int comparisonResult;
            Object valueOne = firstValues.get(i);
            Object valueTwo = secondValues.get(i);
            boolean isDescending = this.isDescendingValues[i];
            if (!(!this.stringTypedValue[i] ? (comparisonResult = CollectionUtil.compareValues(valueOne, valueTwo, isDescending)) != 0 : (comparisonResult = CollectionUtil.compareValuesCollated(valueOne, valueTwo, isDescending, this.collator)) != 0)) continue;
            return comparisonResult;
        }
        if (!firstValues.equals(secondValues)) {
            return -1;
        }
        return 0;
    }
}

