/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.util;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.configuration.Configuration;
import com.espertech.esper.common.client.configuration.common.ConfigurationCommonParser;
import com.espertech.esper.common.client.configuration.compiler.ConfigurationCompilerParser;
import com.espertech.esper.common.client.configuration.runtime.ConfigurationRuntimeParser;
import com.espertech.esper.common.internal.util.DOMElementIterator;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class ConfigurationParser {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationParser.class);

    public static void doConfigure(Configuration configuration, InputStream stream, String resourceName) throws EPException {
        Document document = ConfigurationParser.getDocument(stream, resourceName);
        ConfigurationParser.doConfigure(configuration, document);
    }

    public static Document getDocument(InputStream stream, String resourceName) throws EPException {
        Document document;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.parse(stream);
        }
        catch (ParserConfigurationException ex) {
            throw new EPException("Could not get a DOM parser configuration " + resourceName + ": " + ex.getMessage(), ex);
        }
        catch (SAXException ex) {
            throw new EPException("Could not parse configuration " + resourceName + ": " + ex.getMessage(), ex);
        }
        catch (IOException ex) {
            throw new EPException("Could not read configuration " + resourceName + ": " + ex.getMessage(), ex);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException ioe) {
                log.warn("could not close input stream for: " + resourceName, (Throwable)ioe);
            }
        }
        return document;
    }

    public static void doConfigure(Configuration configuration, Document doc) throws EPException {
        Element root = doc.getDocumentElement();
        DOMElementIterator eventTypeNodeIterator = new DOMElementIterator(root.getChildNodes());
        while (eventTypeNodeIterator.hasNext()) {
            Element element = eventTypeNodeIterator.next();
            String nodeName = element.getNodeName();
            if (nodeName.equals("common")) {
                ConfigurationCommonParser.doConfigure(configuration.getCommon(), element);
                continue;
            }
            if (nodeName.equals("compiler")) {
                ConfigurationCompilerParser.doConfigure(configuration.getCompiler(), element);
                continue;
            }
            if (nodeName.equals("runtime")) {
                ConfigurationRuntimeParser.doConfigure(configuration.getRuntime(), element);
                continue;
            }
            if (!nodeName.equals("event-type") && !nodeName.equals("auto-import") && !nodeName.equals("auto-import-annotations") && !nodeName.equals("method-reference") && !nodeName.equals("database-reference") && !nodeName.equals("plugin-view") && !nodeName.equals("plugin-virtualdw") && !nodeName.equals("plugin-aggregation-function") && !nodeName.equals("plugin-aggregation-multifunction") && !nodeName.equals("plugin-singlerow-function") && !nodeName.equals("plugin-pattern-guard") && !nodeName.equals("plugin-pattern-observer") && !nodeName.equals("variable") && !nodeName.equals("plugin-loader") && !nodeName.equals("engine-settings") && !nodeName.equals("variant-stream")) continue;
            log.warn("The configuration file appears outdated as it has element '" + nodeName + "' among top-level elements. Please convert to the newest schema using the online converter.");
        }
    }
}

