/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMElementIterator
implements Iterator<Element> {
    private int index;
    private NodeList nodeList;

    public DOMElementIterator(NodeList nodeList) {
        this.nodeList = nodeList;
    }

    @Override
    public boolean hasNext() {
        this.positionNext();
        return this.index < this.nodeList.getLength();
    }

    @Override
    public Element next() {
        if (this.index >= this.nodeList.getLength()) {
            throw new NoSuchElementException();
        }
        Element result = (Element)this.nodeList.item(this.index);
        ++this.index;
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void positionNext() {
        Node node;
        while (this.index < this.nodeList.getLength() && !((node = this.nodeList.item(this.index)) instanceof Element)) {
            ++this.index;
        }
    }
}

