/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.util;

import com.espertech.esper.common.client.annotation.EventRepresentation;
import com.espertech.esper.common.client.configuration.Configuration;
import com.espertech.esper.common.client.util.EventUnderlyingType;
import com.espertech.esper.common.internal.compile.stage1.spec.CreateSchemaDesc;
import com.espertech.esper.common.internal.epl.annotation.AnnotationUtil;
import java.lang.annotation.Annotation;

public class EventRepresentationUtil {
    public static EventUnderlyingType getRepresentation(Annotation[] annotations, Configuration configs, CreateSchemaDesc.AssignedType assignedType) {
        if (assignedType == CreateSchemaDesc.AssignedType.OBJECTARRAY) {
            return EventUnderlyingType.OBJECTARRAY;
        }
        if (assignedType == CreateSchemaDesc.AssignedType.MAP) {
            return EventUnderlyingType.MAP;
        }
        if (assignedType == CreateSchemaDesc.AssignedType.AVRO) {
            return EventUnderlyingType.AVRO;
        }
        if (assignedType == CreateSchemaDesc.AssignedType.JSON) {
            return EventUnderlyingType.JSON;
        }
        if (assignedType == CreateSchemaDesc.AssignedType.VARIANT || assignedType != CreateSchemaDesc.AssignedType.NONE) {
            throw new IllegalStateException("Not handled by event representation: " + (Object)((Object)assignedType));
        }
        Annotation annotation = AnnotationUtil.findAnnotation(annotations, EventRepresentation.class);
        if (annotation != null) {
            EventRepresentation eventRepresentation = (EventRepresentation)annotation;
            if (eventRepresentation.value() == EventUnderlyingType.AVRO) {
                return EventUnderlyingType.AVRO;
            }
            if (eventRepresentation.value() == EventUnderlyingType.JSON) {
                return EventUnderlyingType.JSON;
            }
            if (eventRepresentation.value() == EventUnderlyingType.OBJECTARRAY) {
                return EventUnderlyingType.OBJECTARRAY;
            }
            if (eventRepresentation.value() == EventUnderlyingType.MAP) {
                return EventUnderlyingType.MAP;
            }
            throw new IllegalStateException("Unrecognized enum " + (Object)((Object)eventRepresentation.value()));
        }
        EventUnderlyingType configured = configs.getCommon().getEventMeta().getDefaultEventRepresentation();
        if (configured == EventUnderlyingType.OBJECTARRAY) {
            return EventUnderlyingType.OBJECTARRAY;
        }
        if (configured == EventUnderlyingType.MAP) {
            return EventUnderlyingType.MAP;
        }
        if (configured == EventUnderlyingType.AVRO) {
            return EventUnderlyingType.AVRO;
        }
        if (configured == EventUnderlyingType.JSON) {
            return EventUnderlyingType.JSON;
        }
        return EventUnderlyingType.MAP;
    }
}

