/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.util;

import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypeClassParameterized;
import com.espertech.esper.common.client.type.EPTypeNull;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.client.util.ClassForNameProvider;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.util.BoolValue;
import com.espertech.esper.common.internal.util.ClassInstantiationException;
import com.espertech.esper.common.internal.util.CoercionException;
import com.espertech.esper.common.internal.util.LongValue;
import com.espertech.esper.common.internal.util.MethodResolver;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JavaClassHelper {
    public static final String APACHE_AVRO_GENERIC_RECORD_CLASSNAME = "org.apache.avro.generic.GenericData$Record";

    public static boolean isImplementsCharSequence(EPType type) {
        if (JavaClassHelper.isNullTypeSafe(type)) {
            return false;
        }
        EPTypeClass typeClass = (EPTypeClass)type;
        if (typeClass.getType() == String.class || typeClass.getType() == CharSequence.class) {
            return true;
        }
        return JavaClassHelper.isSubclassOrImplementsInterface((EPType)typeClass, EPTypePremade.CHARSEQUENCE.getEPType());
    }

    public static boolean isArrayTypeCompatible(Class<?> target, Class<?> provided) {
        Class<?> providedBoxed;
        if (target == provided || target == Object.class) {
            return true;
        }
        Class<?> targetBoxed = JavaClassHelper.getBoxedType(target);
        return targetBoxed == (providedBoxed = JavaClassHelper.getBoxedType(provided)) || JavaClassHelper.isSubclassOrImplementsInterface(providedBoxed, targetBoxed);
    }

    public static boolean isCollectionMapOrArray(EPType returnType) {
        if (returnType == null || returnType == EPTypeNull.INSTANCE) {
            return false;
        }
        EPTypeClass rt = (EPTypeClass)returnType;
        return JavaClassHelper.isImplementsInterface(rt, Collection.class) || JavaClassHelper.isImplementsInterface(rt, Map.class) || rt.getType().isArray();
    }

    public static EPType getBoxedType(EPType type) {
        if (type == EPTypeNull.INSTANCE) {
            return type;
        }
        return JavaClassHelper.getBoxedType((EPTypeClass)type);
    }

    public static EPTypeClass getBoxedType(EPTypeClass clazz) {
        if (clazz == null) {
            return null;
        }
        if (!clazz.getType().isPrimitive()) {
            return clazz;
        }
        if (clazz.getType() == Boolean.TYPE) {
            return EPTypePremade.BOOLEANBOXED.getEPType();
        }
        if (clazz.getType() == Character.TYPE) {
            return EPTypePremade.CHARBOXED.getEPType();
        }
        if (clazz.getType() == Double.TYPE) {
            return EPTypePremade.DOUBLEBOXED.getEPType();
        }
        if (clazz.getType() == Float.TYPE) {
            return EPTypePremade.FLOATBOXED.getEPType();
        }
        if (clazz.getType() == Byte.TYPE) {
            return EPTypePremade.BYTEBOXED.getEPType();
        }
        if (clazz.getType() == Short.TYPE) {
            return EPTypePremade.SHORTBOXED.getEPType();
        }
        if (clazz.getType() == Integer.TYPE) {
            return EPTypePremade.INTEGERBOXED.getEPType();
        }
        if (clazz.getType() == Long.TYPE) {
            return EPTypePremade.LONGBOXED.getEPType();
        }
        return clazz;
    }

    public static Class<?> getBoxedType(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        if (!clazz.isPrimitive()) {
            return clazz;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        if (clazz == Character.TYPE) {
            return Character.class;
        }
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Byte.TYPE) {
            return Byte.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz == Void.TYPE) {
            return Void.class;
        }
        return clazz;
    }

    public static EPTypeClass getPrimitiveType(Class<?> clazz) {
        if (clazz == Boolean.class) {
            return EPTypePremade.BOOLEANPRIMITIVE.getEPType();
        }
        if (clazz == Character.class) {
            return EPTypePremade.CHARPRIMITIVE.getEPType();
        }
        if (clazz == Double.class) {
            return EPTypePremade.DOUBLEPRIMITIVE.getEPType();
        }
        if (clazz == Float.class) {
            return EPTypePremade.FLOATPRIMITIVE.getEPType();
        }
        if (clazz == Byte.class) {
            return EPTypePremade.BYTEPRIMITIVE.getEPType();
        }
        if (clazz == Short.class) {
            return EPTypePremade.SHORTPRIMITIVE.getEPType();
        }
        if (clazz == Integer.class) {
            return EPTypePremade.INTEGERPRIMITIVE.getEPType();
        }
        if (clazz == Long.class) {
            return EPTypePremade.LONGPRIMITIVE.getEPType();
        }
        return EPTypePremade.getOrCreate(clazz);
    }

    public static EPTypeClass getPrimitiveType(EPTypeClass clazz) {
        if (clazz.getType() == Boolean.class) {
            return EPTypePremade.BOOLEANPRIMITIVE.getEPType();
        }
        if (clazz.getType() == Character.class) {
            return EPTypePremade.CHARPRIMITIVE.getEPType();
        }
        if (clazz.getType() == Double.class) {
            return EPTypePremade.DOUBLEPRIMITIVE.getEPType();
        }
        if (clazz.getType() == Float.class) {
            return EPTypePremade.FLOATPRIMITIVE.getEPType();
        }
        if (clazz.getType() == Byte.class) {
            return EPTypePremade.BYTEPRIMITIVE.getEPType();
        }
        if (clazz.getType() == Short.class) {
            return EPTypePremade.SHORTPRIMITIVE.getEPType();
        }
        if (clazz.getType() == Integer.class) {
            return EPTypePremade.INTEGERPRIMITIVE.getEPType();
        }
        if (clazz.getType() == Long.class) {
            return EPTypePremade.LONGPRIMITIVE.getEPType();
        }
        return clazz;
    }

    public static boolean isNumeric(EPType clazz) {
        if (clazz == null || clazz == EPTypeNull.INSTANCE) {
            return false;
        }
        return JavaClassHelper.isNumeric(((EPTypeClass)clazz).getType());
    }

    public static boolean isNumeric(Class<?> clazz) {
        return clazz == Double.class || clazz == Double.TYPE || clazz == BigDecimal.class || clazz == BigInteger.class || clazz == Float.class || clazz == Float.TYPE || clazz == Short.class || clazz == Short.TYPE || clazz == Integer.class || clazz == Integer.TYPE || clazz == Long.class || clazz == Long.TYPE || clazz == Byte.class || clazz == Byte.TYPE;
    }

    public static boolean isNumericNonFP(EPType type) {
        if (JavaClassHelper.isNullTypeSafe(type)) {
            return false;
        }
        return JavaClassHelper.isNumericNonFP(((EPTypeClass)type).getType());
    }

    public static boolean isNumericNonFP(Class<?> clazz) {
        return clazz == Short.class || clazz == Short.TYPE || clazz == Integer.class || clazz == Integer.TYPE || clazz == Long.class || clazz == Long.TYPE || clazz == Byte.class || clazz == Byte.TYPE;
    }

    public static boolean isAssignmentCompatible(EPType invocationType, Class<?> declarationType) {
        if (invocationType == null || invocationType == EPTypeNull.INSTANCE) {
            return declarationType == null || !declarationType.isPrimitive();
        }
        return JavaClassHelper.isAssignmentCompatible(((EPTypeClass)invocationType).getType(), declarationType);
    }

    public static boolean isAssignmentCompatible(Class<?> invocationType, Class<?> declarationType) {
        Class<?> parameterWrapperClazz;
        if (invocationType == null) {
            return declarationType == null || !declarationType.isPrimitive();
        }
        if (declarationType.isAssignableFrom(invocationType)) {
            return true;
        }
        if (declarationType.isPrimitive() && (parameterWrapperClazz = JavaClassHelper.getBoxedType(declarationType)) != null && parameterWrapperClazz.equals(invocationType)) {
            return true;
        }
        if (JavaClassHelper.getBoxedType(invocationType) == declarationType) {
            return true;
        }
        Set<Class> widenings = MethodResolver.getWideningConversions().get(declarationType);
        if (widenings != null) {
            return widenings.contains(invocationType);
        }
        if (declarationType.isInterface() && JavaClassHelper.isImplementsInterface(invocationType, declarationType)) {
            return true;
        }
        return JavaClassHelper.recursiveIsSuperClass(invocationType, declarationType);
    }

    public static boolean isTypeBoolean(EPType type) {
        if (JavaClassHelper.isNullTypeSafe(type)) {
            return false;
        }
        return JavaClassHelper.isTypeBoolean(((EPTypeClass)type).getType());
    }

    public static boolean isTypeInteger(EPType type) {
        if (JavaClassHelper.isNullTypeSafe(type)) {
            return false;
        }
        return JavaClassHelper.isTypeInteger(((EPTypeClass)type).getType());
    }

    public static boolean isTypeLong(EPType type) {
        if (JavaClassHelper.isNullTypeSafe(type)) {
            return false;
        }
        return JavaClassHelper.isTypeLong(((EPTypeClass)type).getType());
    }

    public static boolean isTypeDouble(EPType type) {
        if (JavaClassHelper.isNullTypeSafe(type)) {
            return false;
        }
        return JavaClassHelper.isTypeDouble(((EPTypeClass)type).getType());
    }

    public static boolean isTypeString(EPType type) {
        return JavaClassHelper.isType(type, String.class);
    }

    public static boolean isTypePrimitive(EPType type) {
        if (JavaClassHelper.isNullTypeSafe(type)) {
            return false;
        }
        return ((EPTypeClass)type).getType().isPrimitive();
    }

    public static boolean isType(EPType type, Class<?> clazz) {
        if (JavaClassHelper.isNullTypeSafe(type)) {
            return false;
        }
        return ((EPTypeClass)type).getType() == clazz;
    }

    public static boolean isTypeBoolean(Class<?> clazz) {
        return clazz == Boolean.class || clazz == Boolean.TYPE;
    }

    public static boolean isTypeInteger(Class<?> clazz) {
        return clazz == Integer.class || clazz == Integer.TYPE;
    }

    public static boolean isTypeLong(Class<?> clazz) {
        return clazz == Long.class || clazz == Long.TYPE;
    }

    public static boolean isTypeDouble(Class<?> clazz) {
        return clazz == Double.class || clazz == Double.TYPE;
    }

    public static EPTypeClass getArithmaticCoercionType(EPTypeClass typeOne, EPTypeClass typeTwo) throws CoercionException {
        EPTypeClass boxedOneType = JavaClassHelper.getBoxedType(typeOne);
        EPTypeClass boxedTwoType = JavaClassHelper.getBoxedType(typeTwo);
        Class<?> boxedOne = boxedOneType.getType();
        Class<?> boxedTwo = boxedTwoType.getType();
        if (!JavaClassHelper.isNumeric(boxedOneType) || !JavaClassHelper.isNumeric(boxedTwoType)) {
            throw new CoercionException("Cannot coerce types " + typeOne.getTypeName() + " and " + typeTwo.getTypeName());
        }
        if (boxedOne == boxedTwo) {
            return boxedOneType;
        }
        if (boxedOne == BigDecimal.class || boxedTwo == BigDecimal.class) {
            return EPTypePremade.BIGDECIMAL.getEPType();
        }
        if (boxedOne == BigInteger.class && JavaClassHelper.isFloatingPointClass(boxedTwo) || boxedTwo == BigInteger.class && JavaClassHelper.isFloatingPointClass(boxedOne)) {
            return EPTypePremade.BIGDECIMAL.getEPType();
        }
        if (boxedOne == BigInteger.class || boxedTwo == BigInteger.class) {
            return EPTypePremade.BIGINTEGER.getEPType();
        }
        if (boxedOne == Double.class || boxedTwo == Double.class) {
            return EPTypePremade.DOUBLEBOXED.getEPType();
        }
        if (boxedOne == Float.class && !JavaClassHelper.isFloatingPointClass(typeTwo)) {
            return EPTypePremade.DOUBLEBOXED.getEPType();
        }
        if (boxedTwo == Float.class && !JavaClassHelper.isFloatingPointClass(typeOne)) {
            return EPTypePremade.DOUBLEBOXED.getEPType();
        }
        if (boxedOne == Long.class || boxedTwo == Long.class) {
            return EPTypePremade.LONGBOXED.getEPType();
        }
        return EPTypePremade.INTEGERBOXED.getEPType();
    }

    public static Class<?> getArithmaticCoercionType(Class<?> typeOne, Class<?> typeTwo) throws CoercionException {
        Class<?> boxedOne = JavaClassHelper.getBoxedType(typeOne);
        Class<?> boxedTwo = JavaClassHelper.getBoxedType(typeTwo);
        if (!JavaClassHelper.isNumeric(boxedOne) || !JavaClassHelper.isNumeric(boxedTwo)) {
            throw new CoercionException("Cannot coerce types " + typeOne.getName() + " and " + typeTwo.getName());
        }
        if (boxedOne == boxedTwo) {
            return boxedOne;
        }
        if (boxedOne == BigDecimal.class || boxedTwo == BigDecimal.class) {
            return BigDecimal.class;
        }
        if (boxedOne == BigInteger.class && JavaClassHelper.isFloatingPointClass(boxedTwo) || boxedTwo == BigInteger.class && JavaClassHelper.isFloatingPointClass(boxedOne)) {
            return BigDecimal.class;
        }
        if (boxedOne == BigInteger.class || boxedTwo == BigInteger.class) {
            return BigInteger.class;
        }
        if (boxedOne == Double.class || boxedTwo == Double.class) {
            return Double.class;
        }
        if (boxedOne == Float.class && !JavaClassHelper.isFloatingPointClass(typeTwo)) {
            return Double.class;
        }
        if (boxedTwo == Float.class && !JavaClassHelper.isFloatingPointClass(typeOne)) {
            return Double.class;
        }
        if (boxedOne == Long.class || boxedTwo == Long.class) {
            return Long.class;
        }
        return Integer.class;
    }

    public static Number coerceBoxed(Number numToCoerce, Class<?> resultBoxedType) {
        if (numToCoerce.getClass() == resultBoxedType) {
            return numToCoerce;
        }
        if (resultBoxedType == Double.class) {
            return numToCoerce.doubleValue();
        }
        if (resultBoxedType == Long.class) {
            return numToCoerce.longValue();
        }
        if (resultBoxedType == BigInteger.class) {
            return BigInteger.valueOf(numToCoerce.longValue());
        }
        if (resultBoxedType == BigDecimal.class) {
            if (JavaClassHelper.isFloatingPointNumber(numToCoerce)) {
                return new BigDecimal(numToCoerce.doubleValue());
            }
            return new BigDecimal(numToCoerce.longValue());
        }
        if (resultBoxedType == Float.class) {
            return Float.valueOf(numToCoerce.floatValue());
        }
        if (resultBoxedType == Integer.class) {
            return numToCoerce.intValue();
        }
        if (resultBoxedType == Short.class) {
            return numToCoerce.shortValue();
        }
        if (resultBoxedType == Byte.class) {
            return numToCoerce.byteValue();
        }
        throw new IllegalArgumentException("Cannot coerce to number subtype " + resultBoxedType.getName());
    }

    public static CodegenExpression coerceNumberBoxedToBoxedCodegen(CodegenExpression exprReturningBoxed, EPTypeClass fromTypeBoxed, EPTypeClass targetTypeBoxed) {
        if (fromTypeBoxed.equals(targetTypeBoxed)) {
            return exprReturningBoxed;
        }
        if (targetTypeBoxed.getType() == Double.class) {
            return CodegenExpressionBuilder.exprDotMethod(exprReturningBoxed, "doubleValue", new CodegenExpression[0]);
        }
        if (targetTypeBoxed.getType() == Long.class) {
            return CodegenExpressionBuilder.exprDotMethod(exprReturningBoxed, "longValue", new CodegenExpression[0]);
        }
        if (targetTypeBoxed.getType() == BigInteger.class) {
            return CodegenExpressionBuilder.staticMethod(BigInteger.class, "valueOf", CodegenExpressionBuilder.exprDotMethod(exprReturningBoxed, "longValue", new CodegenExpression[0]));
        }
        if (targetTypeBoxed.getType() == BigDecimal.class) {
            if (JavaClassHelper.isFloatingPointClass(fromTypeBoxed)) {
                return CodegenExpressionBuilder.newInstance(EPTypePremade.BIGDECIMAL.getEPType(), CodegenExpressionBuilder.exprDotMethod(exprReturningBoxed, "doubleValue", new CodegenExpression[0]));
            }
            return CodegenExpressionBuilder.newInstance(EPTypePremade.BIGDECIMAL.getEPType(), CodegenExpressionBuilder.exprDotMethod(exprReturningBoxed, "longValue", new CodegenExpression[0]));
        }
        if (targetTypeBoxed.getType() == Float.class) {
            return CodegenExpressionBuilder.exprDotMethod(exprReturningBoxed, "floatValue", new CodegenExpression[0]);
        }
        if (targetTypeBoxed.getType() == Integer.class) {
            return CodegenExpressionBuilder.exprDotMethod(exprReturningBoxed, "intValue", new CodegenExpression[0]);
        }
        if (targetTypeBoxed.getType() == Short.class) {
            return CodegenExpressionBuilder.exprDotMethod(exprReturningBoxed, "shortValue", new CodegenExpression[0]);
        }
        if (targetTypeBoxed.getType() == Byte.class) {
            return CodegenExpressionBuilder.exprDotMethod(exprReturningBoxed, "byteValue", new CodegenExpression[0]);
        }
        throw new IllegalArgumentException("Cannot coerce to number subtype " + fromTypeBoxed.getType().getName());
    }

    public static CodegenExpression coerceNumberToBoxedCodegen(CodegenExpression expr, EPTypeClass fromType, EPTypeClass targetTypeBoxed) {
        if (!fromType.getType().isPrimitive()) {
            return JavaClassHelper.coerceNumberBoxedToBoxedCodegen(expr, fromType, targetTypeBoxed);
        }
        if (targetTypeBoxed.getType() == Double.class) {
            return JavaClassHelper.coerceAnyToBoxedCodegenValueOf(expr, fromType, EPTypePremade.DOUBLEBOXED.getEPType(), EPTypePremade.DOUBLEPRIMITIVE.getEPType());
        }
        if (targetTypeBoxed.getType() == Long.class) {
            return JavaClassHelper.coerceAnyToBoxedCodegenValueOf(expr, fromType, EPTypePremade.LONGBOXED.getEPType(), EPTypePremade.LONGPRIMITIVE.getEPType());
        }
        if (targetTypeBoxed.getType() == BigInteger.class) {
            return CodegenExpressionBuilder.staticMethod(BigInteger.class, "valueOf", JavaClassHelper.coerceAnyToBoxedCodegenValueOf(expr, fromType, EPTypePremade.LONGBOXED.getEPType(), EPTypePremade.LONGPRIMITIVE.getEPType()));
        }
        if (targetTypeBoxed.getType() == BigDecimal.class) {
            if (JavaClassHelper.isFloatingPointClass(fromType)) {
                return CodegenExpressionBuilder.newInstance(EPTypePremade.BIGDECIMAL.getEPType(), CodegenExpressionBuilder.exprDotMethod(JavaClassHelper.coerceAnyToBoxedCodegenValueOf(expr, fromType, EPTypePremade.DOUBLEBOXED.getEPType(), EPTypePremade.DOUBLEPRIMITIVE.getEPType()), "doubleValue", new CodegenExpression[0]));
            }
            return CodegenExpressionBuilder.newInstance(EPTypePremade.BIGDECIMAL.getEPType(), CodegenExpressionBuilder.exprDotMethod(JavaClassHelper.coerceAnyToBoxedCodegenValueOf(expr, fromType, EPTypePremade.LONGBOXED.getEPType(), EPTypePremade.LONGPRIMITIVE.getEPType()), "longValue", new CodegenExpression[0]));
        }
        if (targetTypeBoxed.getType() == Float.class) {
            return JavaClassHelper.coerceAnyToBoxedCodegenValueOf(expr, fromType, EPTypePremade.BYTEBOXED.getEPType(), EPTypePremade.BYTEPRIMITIVE.getEPType());
        }
        if (targetTypeBoxed.getType() == Integer.class) {
            return JavaClassHelper.coerceAnyToBoxedCodegenValueOf(expr, fromType, EPTypePremade.INTEGERBOXED.getEPType(), EPTypePremade.INTEGERPRIMITIVE.getEPType());
        }
        if (targetTypeBoxed.getType() == Short.class) {
            return JavaClassHelper.coerceAnyToBoxedCodegenValueOf(expr, fromType, EPTypePremade.SHORTBOXED.getEPType(), EPTypePremade.SHORTPRIMITIVE.getEPType());
        }
        if (targetTypeBoxed.getType() == Byte.class) {
            return JavaClassHelper.coerceAnyToBoxedCodegenValueOf(expr, fromType, EPTypePremade.BYTEBOXED.getEPType(), EPTypePremade.BYTEPRIMITIVE.getEPType());
        }
        throw new IllegalArgumentException("Cannot coerce to number subtype " + targetTypeBoxed);
    }

    private static CodegenExpression coerceAnyToBoxedCodegenValueOf(CodegenExpression expr, EPTypeClass from, EPTypeClass boxed, EPTypeClass cast) {
        if (from == cast) {
            return CodegenExpressionBuilder.staticMethod(boxed.getType(), "valueOf", expr);
        }
        return CodegenExpressionBuilder.staticMethod(boxed.getType(), "valueOf", CodegenExpressionBuilder.cast(cast, expr));
    }

    public static boolean isFloatingPointNumber(Number number) {
        return number instanceof Float || number instanceof Double;
    }

    public static boolean isFloatingPointClass(EPType type) {
        if (JavaClassHelper.isNullTypeSafe(type)) {
            return false;
        }
        return JavaClassHelper.isFloatingPointClass(((EPTypeClass)type).getType());
    }

    public static boolean isFloatingPointClass(Class<?> clazz) {
        return clazz == Float.class || clazz == Double.class || clazz == Float.TYPE || clazz == Double.TYPE;
    }

    public static EPTypeClass getCompareToCoercionType(EPType typeOne, EPType typeTwo) throws CoercionException {
        if (typeOne == null || typeOne == EPTypeNull.INSTANCE) {
            if (typeTwo == null || typeTwo == EPTypeNull.INSTANCE) {
                return null;
            }
            return (EPTypeClass)typeTwo;
        }
        if (typeTwo == null || typeTwo == EPTypeNull.INSTANCE) {
            return (EPTypeClass)typeOne;
        }
        EPTypeClass typeClassOne = (EPTypeClass)typeOne;
        EPTypeClass typeClassTwo = (EPTypeClass)typeTwo;
        Class<?> classOne = typeClassOne.getType();
        Class<?> classTwo = typeClassTwo.getType();
        if (classOne == String.class && classTwo == String.class) {
            return EPTypePremade.STRING.getEPType();
        }
        if (!(classOne != Boolean.TYPE && classOne != Boolean.class || classTwo != Boolean.TYPE && classTwo != Boolean.class)) {
            return EPTypePremade.BOOLEANBOXED.getEPType();
        }
        if (!JavaClassHelper.isJavaBuiltinDataType(classOne) && !JavaClassHelper.isJavaBuiltinDataType(classTwo)) {
            if (classOne != classTwo) {
                return EPTypePremade.OBJECT.getEPType();
            }
            return typeClassOne;
        }
        if (classOne == null) {
            return typeClassTwo;
        }
        if (classTwo == null) {
            return typeClassOne;
        }
        if (!JavaClassHelper.isNumeric(classOne) || !JavaClassHelper.isNumeric(classTwo)) {
            String classOneName = classOne.getName();
            String classTwoName = classTwo.getName();
            throw new CoercionException("Types cannot be compared: " + classOneName + " and " + classTwoName);
        }
        return JavaClassHelper.getArithmaticCoercionType(typeClassOne, typeClassTwo);
    }

    static boolean isBigNumberType(Class<?> clazz) {
        return clazz == BigInteger.class || clazz == BigDecimal.class;
    }

    public static boolean canCoerce(Class<?> numberClassToBeCoerced, Class<?> numberClassToCoerceTo) {
        Class<?> boxedFrom = JavaClassHelper.getBoxedType(numberClassToBeCoerced);
        Class<?> boxedTo = JavaClassHelper.getBoxedType(numberClassToCoerceTo);
        if (!JavaClassHelper.isNumeric(numberClassToBeCoerced)) {
            throw new IllegalArgumentException("Class '" + numberClassToBeCoerced + "' is not a numeric type'");
        }
        if (boxedTo == Float.class) {
            return boxedFrom == Byte.class || boxedFrom == Short.class || boxedFrom == Integer.class || boxedFrom == Long.class || boxedFrom == Float.class;
        }
        if (boxedTo == Double.class) {
            return boxedFrom == Byte.class || boxedFrom == Short.class || boxedFrom == Integer.class || boxedFrom == Long.class || boxedFrom == Float.class || boxedFrom == Double.class;
        }
        if (boxedTo == BigDecimal.class) {
            return boxedFrom == Byte.class || boxedFrom == Short.class || boxedFrom == Integer.class || boxedFrom == Long.class || boxedFrom == Float.class || boxedFrom == Double.class || boxedFrom == BigInteger.class || boxedFrom == BigDecimal.class;
        }
        if (boxedTo == BigInteger.class) {
            return boxedFrom == Byte.class || boxedFrom == Short.class || boxedFrom == Integer.class || boxedFrom == Long.class || boxedFrom == BigInteger.class;
        }
        if (boxedTo == Long.class) {
            return boxedFrom == Byte.class || boxedFrom == Short.class || boxedFrom == Integer.class || boxedFrom == Long.class;
        }
        if (boxedTo == Integer.class || boxedTo == Short.class || boxedTo == Byte.class) {
            return boxedFrom == Byte.class || boxedFrom == Short.class || boxedFrom == Integer.class;
        }
        throw new IllegalArgumentException("Class '" + numberClassToCoerceTo + "' is not a numeric type'");
    }

    public static String getBoxedClassName(String className) {
        if (className.equals(Character.TYPE.getName())) {
            return Character.class.getName();
        }
        if (className.equals(Byte.TYPE.getName())) {
            return Byte.class.getName();
        }
        if (className.equals(Short.TYPE.getName())) {
            return Short.class.getName();
        }
        if (className.equals(Integer.TYPE.getName())) {
            return Integer.class.getName();
        }
        if (className.equals(Long.TYPE.getName())) {
            return Long.class.getName();
        }
        if (className.equals(Float.TYPE.getName())) {
            return Float.class.getName();
        }
        if (className.equals(Double.TYPE.getName())) {
            return Double.class.getName();
        }
        if (className.equals(Boolean.TYPE.getName())) {
            return Boolean.class.getName();
        }
        return className;
    }

    public static boolean isJavaBuiltinDataType(EPType type) {
        if (type == null || type == EPTypeNull.INSTANCE) {
            return true;
        }
        return JavaClassHelper.isJavaBuiltinDataType(((EPTypeClass)type).getType());
    }

    public static boolean isJavaBuiltinDataType(Class<?> clazz) {
        if (clazz == null) {
            return true;
        }
        if (clazz.isArray()) {
            return JavaClassHelper.isJavaBuiltinDataType(clazz.getComponentType());
        }
        Class<?> clazzBoxed = JavaClassHelper.getBoxedType(clazz);
        if (JavaClassHelper.isNumeric(clazzBoxed)) {
            return true;
        }
        if (JavaClassHelper.isTypeBoolean(clazzBoxed)) {
            return true;
        }
        if (clazzBoxed.equals(String.class)) {
            return true;
        }
        if (clazzBoxed.equals(CharSequence.class)) {
            return true;
        }
        if (clazzBoxed.equals(Character.TYPE) || clazzBoxed.equals(Character.class)) {
            return true;
        }
        return clazzBoxed.equals(Void.TYPE);
    }

    public static EPType getCommonCoercionType(EPType[] types) throws CoercionException {
        if (types.length < 1) {
            throw new IllegalArgumentException("Unexpected zero length array");
        }
        if (types.length == 1) {
            return JavaClassHelper.getBoxedType(types[0]);
        }
        ArrayList<EPTypeClass> nonNullTypes = new ArrayList<EPTypeClass>();
        for (EPType type : types) {
            if (type == null || type == EPTypeNull.INSTANCE) continue;
            nonNullTypes.add((EPTypeClass)type);
        }
        EPTypeClass[] classes = nonNullTypes.toArray(new EPTypeClass[0]);
        if (classes.length == 0) {
            return EPTypeNull.INSTANCE;
        }
        if (classes.length == 1) {
            return JavaClassHelper.getBoxedType(classes[0]);
        }
        if (classes[0].getType() == String.class) {
            for (EPTypeClass clazz : classes) {
                if (clazz.getType() == String.class) continue;
                throw new CoercionException("Cannot coerce to String type " + clazz.getTypeName());
            }
            return EPTypePremade.STRING.getEPType();
        }
        for (int i = 0; i < classes.length; ++i) {
            classes[i] = JavaClassHelper.getBoxedType(classes[i]);
        }
        if (classes[0].getType() == Boolean.class) {
            for (EPTypeClass clazz : classes) {
                if (clazz.getType() == Boolean.class) continue;
                throw new CoercionException("Cannot coerce to Boolean type " + clazz.getTypeName());
            }
            return EPTypePremade.BOOLEANBOXED.getEPType();
        }
        if (classes[0].getType() == Character.class) {
            for (EPTypeClass type : classes) {
                if (type.getType() == Character.class) continue;
                throw new CoercionException("Cannot coerce to Boolean type " + type.getTypeName());
            }
            return EPTypePremade.CHARBOXED.getEPType();
        }
        if (classes[0].getType().isArray()) {
            EPTypeClass componentType = JavaClassHelper.getArrayComponentType(classes[0]);
            boolean sameComponentType = true;
            for (int i = 1; i < classes.length; ++i) {
                if (!classes[i].getType().isArray()) {
                    throw JavaClassHelper.getCoercionException(classes[0], classes[i]);
                }
                EPTypeClass otherComponentType = JavaClassHelper.getArrayComponentType(classes[i]);
                if (componentType.equals(otherComponentType)) continue;
                if (componentType.getType().isPrimitive() || otherComponentType.getType().isPrimitive()) {
                    throw JavaClassHelper.getCoercionException(classes[0], classes[i]);
                }
                sameComponentType = false;
            }
            if (sameComponentType) {
                return classes[0];
            }
            return EPTypePremade.OBJECTARRAY.getEPType();
        }
        boolean isAllBuiltinTypes = true;
        for (EPTypeClass type : classes) {
            if (JavaClassHelper.isNumeric(type) || JavaClassHelper.isJavaBuiltinDataType(type.getType())) continue;
            isAllBuiltinTypes = false;
        }
        if (isAllBuiltinTypes) {
            EPTypeClass result = JavaClassHelper.getArithmaticCoercionType(classes[0], classes[1]);
            for (int count = 2; count < classes.length; ++count) {
                result = JavaClassHelper.getArithmaticCoercionType(result, classes[count]);
            }
            return result;
        }
        boolean allSame = true;
        for (EPTypeClass type : classes) {
            if (classes[0].equals(type)) continue;
            if (JavaClassHelper.isJavaBuiltinDataType(type.getType())) {
                throw JavaClassHelper.getCoercionException(classes[0], type);
            }
            allSame = false;
        }
        if (allSame) {
            return classes[0];
        }
        Class<?> unparameterized = classes[0].getType();
        boolean unparameterizedSame = true;
        for (EPTypeClass type : classes) {
            if (type.getType() == unparameterized) continue;
            unparameterizedSame = false;
        }
        if (unparameterizedSame) {
            return EPTypePremade.getOrCreate(unparameterized);
        }
        return EPTypePremade.OBJECT.getEPType();
    }

    public static Class<?> getClassForName(String className, ClassForNameProvider classForNameProvider) throws ClassNotFoundException {
        if (className.equals(Boolean.TYPE.getName())) {
            return Boolean.TYPE;
        }
        if (className.equals(Character.TYPE.getName())) {
            return Character.TYPE;
        }
        if (className.equals(Double.TYPE.getName())) {
            return Double.TYPE;
        }
        if (className.equals(Float.TYPE.getName())) {
            return Float.TYPE;
        }
        if (className.equals(Byte.TYPE.getName())) {
            return Byte.TYPE;
        }
        if (className.equals(Short.TYPE.getName())) {
            return Short.TYPE;
        }
        if (className.equals(Integer.TYPE.getName())) {
            return Integer.TYPE;
        }
        if (className.equals(Long.TYPE.getName())) {
            return Long.TYPE;
        }
        return classForNameProvider.classForName(className);
    }

    public static Class<?> getClassForSimpleName(String className, ClassForNameProvider classForNameProvider) {
        if ("string".equals(className.toLowerCase(Locale.ENGLISH).trim()) || "varchar".equals(className.toLowerCase(Locale.ENGLISH).trim()) || "varchar2".equals(className.toLowerCase(Locale.ENGLISH).trim())) {
            return String.class;
        }
        if ("integer".equals(className.toLowerCase(Locale.ENGLISH).trim()) || "int".equals(className.toLowerCase(Locale.ENGLISH).trim())) {
            return Integer.class;
        }
        if ("bool".equals(className.toLowerCase(Locale.ENGLISH).trim())) {
            return Boolean.class;
        }
        if ("character".equals(className.toLowerCase(Locale.ENGLISH).trim())) {
            return Character.class;
        }
        String boxedClassName = JavaClassHelper.getBoxedClassName(className.trim());
        try {
            return classForNameProvider.classForName(boxedClassName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            boxedClassName = JavaClassHelper.getBoxedClassName(className.toLowerCase(Locale.ENGLISH).trim());
            try {
                return classForNameProvider.classForName(boxedClassName);
            }
            catch (ClassNotFoundException ex) {
                return null;
            }
        }
    }

    public static String getSimpleNameForClass(EPTypeClass clazz) {
        if (clazz == null) {
            return "(null)";
        }
        return JavaClassHelper.getSimpleNameForClass(clazz.getType());
    }

    public static String getSimpleNameForClass(Class<?> clazz) {
        if (clazz == null) {
            return "(null)";
        }
        if (JavaClassHelper.isImplementsInterface(clazz, CharSequence.class)) {
            return "string";
        }
        Class<?> boxed = JavaClassHelper.getBoxedType(clazz);
        if (boxed == Integer.class) {
            return "int";
        }
        if (boxed == Boolean.class) {
            return "boolean";
        }
        if (boxed == Character.class) {
            return "character";
        }
        if (boxed == Double.class) {
            return "double";
        }
        if (boxed == Float.class) {
            return "float";
        }
        if (boxed == Byte.class) {
            return "byte";
        }
        if (boxed == Short.class) {
            return "short";
        }
        if (boxed == Long.class) {
            return "long";
        }
        return clazz.getSimpleName();
    }

    public static Class<?> getPrimitiveClassForName(String typeName) {
        if ((typeName = typeName.toLowerCase(Locale.ENGLISH)).equals("boolean")) {
            return Boolean.TYPE;
        }
        if (typeName.equals("char")) {
            return Character.TYPE;
        }
        if (typeName.equals("double")) {
            return Double.TYPE;
        }
        if (typeName.equals("float")) {
            return Float.TYPE;
        }
        if (typeName.equals("byte")) {
            return Byte.TYPE;
        }
        if (typeName.equals("short")) {
            return Short.TYPE;
        }
        if (typeName.equals("int")) {
            return Integer.TYPE;
        }
        if (typeName.equals("long")) {
            return Long.TYPE;
        }
        if (typeName.equals("string")) {
            return String.class;
        }
        return null;
    }

    public static Object parse(Class<?> clazz, String text) {
        Class<?> classBoxed = JavaClassHelper.getBoxedType(clazz);
        if (classBoxed == String.class) {
            return text;
        }
        if (classBoxed == Character.class) {
            return Character.valueOf(text.charAt(0));
        }
        if (classBoxed == Boolean.class) {
            return BoolValue.parseString(text.toLowerCase(Locale.ENGLISH).trim());
        }
        if (classBoxed == Byte.class) {
            return Byte.decode(text.trim());
        }
        if (classBoxed == Short.class) {
            return Short.parseShort(text.trim());
        }
        if (classBoxed == Long.class) {
            return LongValue.parseString(text.trim());
        }
        if (classBoxed == Float.class) {
            return Float.valueOf(Float.parseFloat(text.trim()));
        }
        if (classBoxed == Double.class) {
            return Double.parseDouble(text.trim());
        }
        if (classBoxed == Integer.class) {
            return Integer.parseInt(text.trim());
        }
        return null;
    }

    public static boolean isImplementsInterface(EPType type, Class<?> interfaceClass) {
        if (type == null || type == EPTypeNull.INSTANCE) {
            return false;
        }
        return JavaClassHelper.isImplementsInterface(((EPTypeClass)type).getType(), interfaceClass);
    }

    public static boolean isImplementsInterface(Class<?> clazz, Class<?> interfaceClass) {
        if (!interfaceClass.isInterface()) {
            throw new IllegalArgumentException("Interface class passed in is not an interface");
        }
        boolean resultThisClass = JavaClassHelper.recursiveIsImplementsInterface(clazz, interfaceClass);
        if (resultThisClass) {
            return true;
        }
        return JavaClassHelper.recursiveSuperclassImplementsInterface(clazz, interfaceClass);
    }

    public static boolean isSubclassOrImplementsInterface(EPType extendorOrImplementor, EPTypeClass extendedOrImplemented) {
        if (JavaClassHelper.isNullTypeSafe(extendorOrImplementor)) {
            return false;
        }
        return JavaClassHelper.isSubclassOrImplementsInterface(((EPTypeClass)extendorOrImplementor).getType(), extendedOrImplemented.getType());
    }

    public static boolean isSubclassOrImplementsInterface(EPType extendorOrImplementor, Class<?> extendedOrImplemented) {
        if (JavaClassHelper.isNullTypeSafe(extendorOrImplementor)) {
            return false;
        }
        return JavaClassHelper.isSubclassOrImplementsInterface(((EPTypeClass)extendorOrImplementor).getType(), extendedOrImplemented);
    }

    public static boolean isSubclassOrImplementsInterface(Class<?> extendorOrImplementor, Class<?> extendedOrImplemented) {
        if (extendorOrImplementor == null) {
            return false;
        }
        if (extendorOrImplementor.equals(extendedOrImplemented)) {
            return true;
        }
        if (extendedOrImplemented.isArray()) {
            int dimTo;
            Class<?> extendedComponentType;
            if (!extendorOrImplementor.isArray()) {
                return false;
            }
            if (extendorOrImplementor.getComponentType().isPrimitive()) {
                return false;
            }
            if (extendedOrImplemented == Object[].class) {
                return true;
            }
            Class<?> extendorComponentType = JavaClassHelper.getArrayComponentTypeInnermost(extendorOrImplementor);
            boolean subclass = JavaClassHelper.isSubclassOrImplementsInterface(extendorComponentType, extendedComponentType = JavaClassHelper.getArrayComponentTypeInnermost(extendedOrImplemented));
            if (!subclass) {
                return false;
            }
            int dimFrom = JavaClassHelper.getArrayDimensions(extendorOrImplementor);
            if (dimFrom == (dimTo = JavaClassHelper.getArrayDimensions(extendedOrImplemented))) {
                return true;
            }
            if (dimFrom < dimTo) {
                return false;
            }
            return JavaClassHelper.getArrayComponentTypeInnermost(extendedOrImplemented) == Object.class;
        }
        if (extendedOrImplemented.isInterface()) {
            return JavaClassHelper.recursiveIsImplementsInterface(extendorOrImplementor, extendedOrImplemented) || JavaClassHelper.recursiveSuperclassImplementsInterface(extendorOrImplementor, extendedOrImplemented);
        }
        return JavaClassHelper.recursiveIsSuperClass(extendorOrImplementor, extendedOrImplemented);
    }

    private static boolean recursiveIsSuperClass(Class<?> clazz, Class<?> superClass) {
        if (clazz == null) {
            return false;
        }
        if (clazz.isPrimitive()) {
            return false;
        }
        if (superClass == Object.class) {
            return true;
        }
        Class<?> mySuperClass = clazz.getSuperclass();
        if (mySuperClass == superClass) {
            return true;
        }
        if (mySuperClass == Object.class) {
            return false;
        }
        return JavaClassHelper.recursiveIsSuperClass(mySuperClass, superClass);
    }

    private static boolean recursiveSuperclassImplementsInterface(Class<?> clazz, Class<?> interfaceClass) {
        Class<?> superClass = clazz.getSuperclass();
        if (superClass == null || superClass == Object.class) {
            return false;
        }
        boolean result = JavaClassHelper.recursiveIsImplementsInterface(superClass, interfaceClass);
        if (result) {
            return result;
        }
        return JavaClassHelper.recursiveSuperclassImplementsInterface(superClass, interfaceClass);
    }

    private static boolean recursiveIsImplementsInterface(Class<?> clazz, Class<?> interfaceClass) {
        if (clazz == interfaceClass) {
            return true;
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        if (interfaces == null) {
            return false;
        }
        for (Class<?> implementedInterface : interfaces) {
            if (implementedInterface == interfaceClass) {
                return true;
            }
            boolean result = JavaClassHelper.recursiveIsImplementsInterface(implementedInterface, interfaceClass);
            if (!result) continue;
            return result;
        }
        return false;
    }

    public static <T> T instantiate(Class<T> implementedOrExtendedClass, String className, ClassForNameProvider classForNameProvider) throws ClassInstantiationException {
        Class clazz;
        try {
            clazz = classForNameProvider.classForName(className);
        }
        catch (ClassNotFoundException ex) {
            throw new ClassInstantiationException("Unable to load class '" + className + "', class not found", ex);
        }
        return (T)JavaClassHelper.instantiate(implementedOrExtendedClass, clazz);
    }

    public static Object instantiate(Class<?> implementedOrExtendedClass, Class<?> clazz) throws ClassInstantiationException {
        Object obj;
        if (!JavaClassHelper.isSubclassOrImplementsInterface(clazz, implementedOrExtendedClass)) {
            if (implementedOrExtendedClass.isInterface()) {
                throw new ClassInstantiationException("Class '" + clazz.getName() + "' does not implement interface '" + implementedOrExtendedClass.getName() + "'");
            }
            throw new ClassInstantiationException("Class '" + clazz.getName() + "' does not extend '" + implementedOrExtendedClass.getName() + "'");
        }
        try {
            obj = clazz.newInstance();
        }
        catch (InstantiationException ex) {
            throw new ClassInstantiationException("Unable to instantiate from class '" + clazz.getName() + "' via default constructor", ex);
        }
        catch (IllegalAccessException ex) {
            throw new ClassInstantiationException("Illegal access when instantiating class '" + clazz.getName() + "' via default constructor", ex);
        }
        return obj;
    }

    public static void getSuper(Class<?> clazz, Set<Class> result) {
        JavaClassHelper.getSuperInterfaces(clazz, result);
        JavaClassHelper.getSuperClasses(clazz, result);
    }

    public static boolean isSimpleNameFullyQualfied(String simpleClassName, String fullyQualifiedClassname) {
        return fullyQualifiedClassname.endsWith("." + simpleClassName) || fullyQualifiedClassname.equals(simpleClassName);
    }

    public static boolean isFragmentableType(EPType type) {
        if (type == null || type == EPTypeNull.INSTANCE) {
            return false;
        }
        return JavaClassHelper.isFragmentableType(((EPTypeClass)type).getType());
    }

    public static boolean isFragmentableType(Class<?> propertyType) {
        if (propertyType == null) {
            return false;
        }
        if (propertyType.isArray()) {
            return JavaClassHelper.isFragmentableType(propertyType.getComponentType());
        }
        if (JavaClassHelper.isJavaBuiltinDataType(propertyType)) {
            return false;
        }
        if (propertyType.isEnum()) {
            return false;
        }
        if (JavaClassHelper.isImplementsInterface(propertyType, Map.class)) {
            return false;
        }
        if (JavaClassHelper.isImplementsInterface(propertyType, Collection.class)) {
            return false;
        }
        if (propertyType == Number.class || propertyType == Node.class || propertyType == NodeList.class || propertyType == Object.class || propertyType == Calendar.class || propertyType == java.util.Date.class || propertyType == LocalDateTime.class || propertyType == ZonedDateTime.class || propertyType == LocalDate.class || propertyType == LocalTime.class || propertyType == Date.class || propertyType == Time.class || propertyType == Optional.class) {
            return false;
        }
        return !propertyType.getName().equals(APACHE_AVRO_GENERIC_RECORD_CLASSNAME);
    }

    public static Class[] getSuperInterfaces(Class<?> clazz) {
        HashSet<Class> interfaces = new HashSet<Class>();
        Class<?>[] declaredInterfaces = clazz.getInterfaces();
        for (int i = 0; i < declaredInterfaces.length; ++i) {
            interfaces.add(declaredInterfaces[i]);
            JavaClassHelper.getSuperInterfaces(declaredInterfaces[i], interfaces);
        }
        HashSet<Class> superClasses = new HashSet<Class>();
        JavaClassHelper.getSuperClasses(clazz, superClasses);
        for (Class superClass : superClasses) {
            declaredInterfaces = superClass.getInterfaces();
            for (int i = 0; i < declaredInterfaces.length; ++i) {
                interfaces.add(declaredInterfaces[i]);
                JavaClassHelper.getSuperInterfaces(declaredInterfaces[i], interfaces);
            }
        }
        return interfaces.toArray(new Class[declaredInterfaces.length]);
    }

    public static void getSuperInterfaces(Class<?> clazz, Set<Class> result) {
        Class<?>[] interfaces = clazz.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            result.add(interfaces[i]);
            JavaClassHelper.getSuperInterfaces(interfaces[i], result);
        }
    }

    private static void getSuperClasses(Class<?> clazz, Set<Class> result) {
        Class<?> superClass = clazz.getSuperclass();
        if (superClass == null) {
            return;
        }
        result.add(superClass);
        JavaClassHelper.getSuper(superClass, result);
    }

    public static Class<?> getGenericFieldType(Field field, boolean isAllowNull) {
        Type t = field.getGenericType();
        Class<?> result = JavaClassHelper.getGenericType(t, 0);
        if (!isAllowNull && result == null) {
            return Object.class;
        }
        return result;
    }

    public static Class<?> getGenericFieldTypeMap(Field field, boolean isAllowNull) {
        Type t = field.getGenericType();
        Class<?> result = JavaClassHelper.getGenericType(t, 1);
        if (!isAllowNull && result == null) {
            return Object.class;
        }
        return result;
    }

    public static Class<?> getGenericType(Type t, int index) {
        GenericArrayType genericArrayType;
        if (t == null) {
            return null;
        }
        if (!(t instanceof ParameterizedType)) {
            return null;
        }
        ParameterizedType ptype = (ParameterizedType)t;
        if (ptype.getActualTypeArguments() == null || ptype.getActualTypeArguments().length < index + 1) {
            return Object.class;
        }
        Type typeParam = ptype.getActualTypeArguments()[index];
        if (typeParam instanceof GenericArrayType && (genericArrayType = (GenericArrayType)typeParam).getGenericComponentType() instanceof Class) {
            return JavaClassHelper.getArrayType((Class)genericArrayType.getGenericComponentType());
        }
        if (!(typeParam instanceof Class)) {
            return Object.class;
        }
        return (Class)typeParam;
    }

    public static Class<?> getArrayType(Class<?> resultType) {
        if (resultType == null) {
            return null;
        }
        return Array.newInstance(resultType, 0).getClass();
    }

    public static int getArrayDimensions(Class<?> clazz) {
        return clazz.isArray() ? JavaClassHelper.getArrayDimensions(clazz.getComponentType()) + 1 : 0;
    }

    public static Class<?> getArrayComponentTypeInnermost(Class<?> clazz) {
        return clazz.isArray() ? JavaClassHelper.getArrayComponentTypeInnermost(clazz.getComponentType()) : clazz;
    }

    public static Class<?> getArrayType(Class<?> resultType, int numberOfDimensions) {
        if (resultType == null) {
            return null;
        }
        if (numberOfDimensions == 0) {
            return resultType;
        }
        Class<?> inner = JavaClassHelper.getArrayType(resultType);
        if (numberOfDimensions == 1) {
            return inner;
        }
        return JavaClassHelper.getArrayType(inner, numberOfDimensions - 1);
    }

    public static Method getMethodByName(Class<?> clazz, String methodName) {
        for (Method m : clazz.getMethods()) {
            if (!m.getName().equals(methodName)) continue;
            return m;
        }
        throw new IllegalStateException("Expected '" + methodName + "' method not found on interface '" + clazz.getName());
    }

    public static String printInstance(Object instance, boolean fullyQualified) {
        if (instance == null) {
            return "(null)";
        }
        StringWriter writer = new StringWriter();
        JavaClassHelper.writeInstance(writer, instance, fullyQualified);
        return writer.toString();
    }

    public static void writeInstance(StringWriter writer, Object instance, boolean fullyQualified) {
        String className;
        if (instance == null) {
            writer.write("(null)");
            return;
        }
        if (fullyQualified) {
            className = instance.getClass().getName();
        } else {
            className = instance.getClass().getSimpleName();
            if (className.isEmpty()) {
                className = instance.getClass().getName();
            }
        }
        JavaClassHelper.writeInstance(writer, className, instance);
    }

    public static void writeInstance(StringWriter writer, String title, Object instance) {
        writer.write(title);
        writer.write("@");
        if (instance == null) {
            writer.write("(null)");
        } else {
            writer.write(Integer.toHexString(System.identityHashCode(instance)));
        }
    }

    public static String getMessageInvocationTarget(String optionalStatementName, String methodName, Class[] methodParameters, String classOrPropertyName, Object[] args, Throwable targetException) {
        String parameters;
        String statementName = optionalStatementName == null ? "(unnamed)" : optionalStatementName;
        String string = parameters = args == null ? "null" : Arrays.toString(args);
        if (args != null) {
            for (int i = 0; i < methodParameters.length; ++i) {
                if (!methodParameters[i].isPrimitive() || args[i] != null) continue;
                return "NullPointerException invoking method '" + methodName + "' of class '" + classOrPropertyName + "' in parameter " + i + " passing parameters " + parameters + " for statement '" + statementName + "': The method expects a primitive " + methodParameters[i].getSimpleName() + " value but received a null value";
            }
        }
        return "Invocation exception when invoking method '" + methodName + "' of class '" + classOrPropertyName + "' passing parameters " + parameters + " for statement '" + statementName + "': " + targetException.getClass().getSimpleName() + " : " + targetException.getMessage();
    }

    public static boolean isDatetimeClass(EPType inputType) {
        if (inputType == null || inputType == EPTypeNull.INSTANCE) {
            return false;
        }
        return JavaClassHelper.isDatetimeClass(((EPTypeClass)inputType).getType());
    }

    public static boolean isDatetimeClass(Class<?> inputType) {
        if (inputType == null) {
            return false;
        }
        return JavaClassHelper.isSubclassOrImplementsInterface(inputType, Calendar.class) || JavaClassHelper.isSubclassOrImplementsInterface(inputType, java.util.Date.class) || JavaClassHelper.isSubclassOrImplementsInterface(inputType, LocalDateTime.class) || JavaClassHelper.isSubclassOrImplementsInterface(inputType, ZonedDateTime.class) || JavaClassHelper.getBoxedType(inputType) == Long.class;
    }

    public static Map<String, Object> getClassObjectFromPropertyTypeNames(Properties properties, ClassForNameProvider classForNameProvider) throws ClassNotFoundException {
        LinkedHashMap<String, Object> propertyTypes = new LinkedHashMap<String, Object>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String className = (String)entry.getValue();
            if ("string".equals(className)) {
                className = String.class.getName();
            }
            String boxedClassName = JavaClassHelper.getBoxedClassName(className);
            Class clazz = classForNameProvider.classForName(boxedClassName);
            propertyTypes.put((String)entry.getKey(), clazz);
        }
        return propertyTypes;
    }

    public static Class<?> getClassInClasspath(String classname, ClassForNameProvider classForNameProvider) {
        try {
            return classForNameProvider.classForName(classname);
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
    }

    public static boolean isSignatureCompatible(Class<?>[] one, Class<?>[] two) {
        if (Arrays.equals(one, two)) {
            return true;
        }
        if (one.length != two.length) {
            return false;
        }
        for (int i = 0; i < one.length; ++i) {
            Class<?> oneClass = one[i];
            Class<?> twoClass = two[i];
            if (JavaClassHelper.isAssignmentCompatible(oneClass, twoClass)) continue;
            return false;
        }
        return true;
    }

    public static Method findRequiredMethod(Class<?> clazz, String methodName) {
        Method found = null;
        for (Method m : clazz.getMethods()) {
            if (!m.getName().equals(methodName)) continue;
            found = m;
            break;
        }
        if (found == null) {
            throw new IllegalArgumentException("Not found method '" + methodName + "'");
        }
        return found;
    }

    public static List<Annotation> getAnnotations(Class<? extends Annotation> annotationClass, Annotation[] annotations) {
        ArrayList<Annotation> result = null;
        for (Annotation annotation : annotations) {
            if (annotation.annotationType() != annotationClass) continue;
            if (result == null) {
                result = new ArrayList<Annotation>();
            }
            result.add(annotation);
        }
        if (result == null) {
            return Collections.emptyList();
        }
        return result;
    }

    public static boolean isAnnotationListed(Class<? extends Annotation> annotationClass, Annotation[] annotations) {
        return !JavaClassHelper.getAnnotations(annotationClass, annotations).isEmpty();
    }

    public static Set<Field> findAnnotatedFields(Class<?> targetClass, Class<? extends Annotation> annotation) {
        LinkedHashSet<Field> fields = new LinkedHashSet<Field>();
        JavaClassHelper.findFieldInternal(targetClass, annotation, fields);
        Class<?> clazz = targetClass;
        while ((clazz = clazz.getSuperclass()) != Object.class && clazz != null) {
            JavaClassHelper.findFieldInternal(clazz, annotation, fields);
        }
        return fields;
    }

    private static void findFieldInternal(Class<?> currentClass, Class<? extends Annotation> annotation, Set<Field> fields) {
        for (Field field : currentClass.getDeclaredFields()) {
            if (!JavaClassHelper.isAnnotationListed(annotation, field.getDeclaredAnnotations())) continue;
            fields.add(field);
        }
    }

    public static Set<Method> findAnnotatedMethods(Class<?> targetClass, Class<? extends Annotation> annotation) {
        LinkedHashSet<Method> methods = new LinkedHashSet<Method>();
        JavaClassHelper.findAnnotatedMethodsInternal(targetClass, annotation, methods);
        Class<?> clazz = targetClass;
        while ((clazz = clazz.getSuperclass()) != Object.class && clazz != null) {
            JavaClassHelper.findAnnotatedMethodsInternal(clazz, annotation, methods);
        }
        return methods;
    }

    private static void findAnnotatedMethodsInternal(Class<?> currentClass, Class<? extends Annotation> annotation, Set<Method> methods) {
        for (Method method : currentClass.getDeclaredMethods()) {
            Annotation[] methodAnnotations = method.getDeclaredAnnotations();
            if (!JavaClassHelper.isAnnotationListed(annotation, methodAnnotations)) continue;
            methods.add(method);
        }
    }

    public static void setFieldForAnnotation(Object target, Class<? extends Annotation> annotation, Object value) {
        boolean found = JavaClassHelper.setFieldForAnnotation(target, annotation, value, target.getClass());
        if (!found) {
            Class<?> superClass = target.getClass().getSuperclass();
            while (!found) {
                found = JavaClassHelper.setFieldForAnnotation(target, annotation, value, superClass);
                if (!found) {
                    superClass = superClass.getSuperclass();
                }
                if (superClass != Object.class && superClass != null) continue;
                break;
            }
        }
    }

    private static boolean setFieldForAnnotation(Object target, Class<? extends Annotation> annotation, Object value, Class<?> currentClass) {
        boolean found = false;
        for (Field field : currentClass.getDeclaredFields()) {
            if (!JavaClassHelper.isAnnotationListed(annotation, field.getDeclaredAnnotations())) continue;
            field.setAccessible(true);
            try {
                field.set(target, value);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Failed to set field " + field + " on class " + currentClass.getName() + ": " + e.getMessage(), e);
            }
            return true;
        }
        return false;
    }

    static Class<?>[] takeFirstN(Class<?>[] classes, int numToTake) {
        Class[] shrunk = new Class[numToTake];
        System.arraycopy(classes, 0, shrunk, 0, shrunk.length);
        return shrunk;
    }

    public static Type[] takeFirstN(Type[] types, int numToTake) {
        Type[] shrunk = new Type[numToTake];
        System.arraycopy(types, 0, shrunk, 0, shrunk.length);
        return shrunk;
    }

    private static CoercionException getCoercionException(EPTypeClass type, EPTypeClass other) {
        throw new CoercionException("Cannot coerce to " + type + " type " + other);
    }

    public static void getObjectValuePretty(Object value, StringWriter writer) {
        if (value == null) {
            writer.append("(null)");
            return;
        }
        if (!value.getClass().isArray()) {
            writer.append(value.toString());
            return;
        }
        String delimiter = "";
        writer.append("[");
        for (int i = 0; i < Array.getLength(value); ++i) {
            writer.append(delimiter);
            delimiter = ", ";
            Object val = Array.get(value, i);
            JavaClassHelper.getObjectValuePretty(val, writer);
        }
        writer.append("]");
    }

    public static boolean isTypeVoid(EPType type) {
        return JavaClassHelper.isTypeEither(type, Void.TYPE, Void.class);
    }

    public static boolean isTypeVoid(Class<?> clazz) {
        return clazz == Void.TYPE || clazz == Void.class;
    }

    public static boolean isTypeOrNull(EPType type, Class<?> expected) {
        if (JavaClassHelper.isNullTypeSafe(type)) {
            return true;
        }
        EPTypeClass typeClass = (EPTypeClass)type;
        if (typeClass.getType() == expected) {
            return true;
        }
        return JavaClassHelper.getBoxedType(typeClass.getType()) == expected;
    }

    public static <T> void traverseAnnotations(List<Class> classes, Class<T> annotationClass, BiConsumer<Class, T> consumer) {
        JavaClassHelper.walkAnnotations(classes, (annotation, clazz) -> {
            if (annotation.annotationType() == annotationClass) {
                consumer.accept(clazz, annotation);
            }
        });
    }

    private static boolean isNullTypeSafe(EPType type) {
        return type == null || type == EPTypeNull.INSTANCE;
    }

    private static void walkAnnotations(List<Class> classes, AnnotationConsumer consumer) {
        if (classes == null) {
            return;
        }
        for (Class clazz : classes) {
            for (Annotation annotation : clazz.getDeclaredAnnotations()) {
                consumer.accept(annotation, clazz);
            }
        }
    }

    private static boolean isTypeEither(EPType type, Class<?> one, Class<?> two) {
        if (JavaClassHelper.isNullTypeSafe(type)) {
            return false;
        }
        EPTypeClass typeClass = (EPTypeClass)type;
        return typeClass.getType() == one || typeClass.getType() == two;
    }

    public static EPTypeClass getArrayComponentType(EPTypeClass type) {
        if (!type.getType().isArray()) {
            throw new IllegalArgumentException("Not an array");
        }
        if (type instanceof EPTypeClassParameterized) {
            EPTypeClassParameterized parameterized = (EPTypeClassParameterized)type;
            return new EPTypeClassParameterized(parameterized.getType().getComponentType(), parameterized.getParameters());
        }
        return EPTypePremade.getOrCreate(type.getType().getComponentType());
    }

    public static EPTypeClass getArrayComponentTypeInnermost(EPTypeClass type) {
        if (!type.getType().isArray()) {
            throw new IllegalArgumentException("Not an array");
        }
        EPTypeClass component = JavaClassHelper.getArrayComponentType(type);
        if (!component.getType().isArray()) {
            return component;
        }
        return JavaClassHelper.getArrayComponentTypeInnermost(component);
    }

    public static EPTypeClass getSingleParameterTypeOrObject(EPTypeClass returnType) {
        if (!(returnType instanceof EPTypeClassParameterized)) {
            return EPTypePremade.OBJECT.getEPType();
        }
        EPTypeClassParameterized parameterized = (EPTypeClassParameterized)returnType;
        if (parameterized.getParameters().length != 1) {
            return EPTypePremade.OBJECT.getEPType();
        }
        return parameterized.getParameters()[0];
    }

    public static EPTypeClass getSecondParameterTypeOrObject(EPTypeClass returnType) {
        if (!(returnType instanceof EPTypeClassParameterized)) {
            return EPTypePremade.OBJECT.getEPType();
        }
        EPTypeClassParameterized parameterized = (EPTypeClassParameterized)returnType;
        if (parameterized.getParameters().length != 2) {
            return EPTypePremade.OBJECT.getEPType();
        }
        return parameterized.getParameters()[1];
    }

    public static EPTypeClass getTypeClassOrObjectType(EPType evaluationType) {
        if (evaluationType == null || evaluationType == EPTypeNull.INSTANCE) {
            return EPTypePremade.OBJECT.getEPType();
        }
        return (EPTypeClass)evaluationType;
    }

    public static EPTypeClass getArrayType(EPTypeClass type) {
        return JavaClassHelper.getArrayType(type, 1);
    }

    public static EPTypeClass getArrayType(EPTypeClass type, int numDimensions) {
        if (numDimensions == 0) {
            return type;
        }
        Class<?> inner = JavaClassHelper.getArrayType(type.getType(), numDimensions);
        if (type instanceof EPTypeClassParameterized) {
            EPTypeClassParameterized parameterized = (EPTypeClassParameterized)type;
            return new EPTypeClassParameterized(inner, parameterized.getParameters());
        }
        return EPTypePremade.getOrCreate(inner);
    }

    public static String getClassNameNormalized(EPTypeClass clazz) {
        if (!clazz.getType().isArray()) {
            if (!(clazz instanceof EPTypeClassParameterized)) {
                return JavaClassHelper.getClassNameSimpleNameDateException(clazz.getType());
            }
            EPTypeClassParameterized parameterized = (EPTypeClassParameterized)clazz;
            StringWriter writer = new StringWriter();
            writer.append(JavaClassHelper.getClassNameSimpleNameDateException(clazz.getType()));
            writer.append("<");
            String delimiter = "";
            for (EPTypeClass param : parameterized.getParameters()) {
                writer.append(delimiter).append(JavaClassHelper.getClassNameNormalized(param));
                delimiter = ",";
            }
            writer.append(">");
            return writer.toString();
        }
        EPTypeClass component = JavaClassHelper.getArrayComponentTypeInnermost(clazz);
        int dimensions = JavaClassHelper.getArrayDimensions(clazz.getType());
        StringWriter writer = new StringWriter();
        writer.append(JavaClassHelper.getClassNameNormalized(component));
        for (int i = 0; i < dimensions; ++i) {
            writer.append("[]");
        }
        return writer.toString();
    }

    private static String getClassNameSimpleNameDateException(Class clazz) {
        if (clazz == Date.class) {
            return Date.class.getName();
        }
        return clazz.getSimpleName();
    }

    public static interface AnnotationConsumer {
        public void accept(Annotation var1, Class<?> var2);
    }
}

