/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.util;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.hook.expr.EPLMethodInvocationContext;
import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypeNull;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import com.espertech.esper.common.internal.util.MethodExecutableRank;
import com.espertech.esper.common.internal.util.MethodResolverNoSuchCtorException;
import com.espertech.esper.common.internal.util.MethodResolverNoSuchMethodException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodResolver {
    private static final Logger log = LoggerFactory.getLogger(MethodResolver.class);
    private static final Map<Class, Set<Class>> WIDENING_CONVERSIONS = new HashMap<Class, Set<Class>>();
    private static final Map<Class, Set<Class>> WRAPPING_CONVERSIONS = new HashMap<Class, Set<Class>>();

    public static Map<Class, Set<Class>> getWideningConversions() {
        return WIDENING_CONVERSIONS;
    }

    public static Method resolveMethod(Class declaringClass, String methodName, EPType[] paramTypes, boolean allowInstance, boolean[] allowEventBeanType, boolean[] allowEventBeanCollType) throws MethodResolverNoSuchMethodException {
        Method[] methods = declaringClass.getMethods();
        Method bestMatch = null;
        MethodExecutableRank rank = null;
        Method conversionFailedMethod = null;
        for (Method method : methods) {
            if (!MethodResolver.isPublicAndStatic(method, allowInstance) || !Modifier.isPublic(method.getDeclaringClass().getModifiers()) || !method.getName().equals(methodName)) continue;
            int conversionCount = MethodResolver.compareParameterTypesAllowContext(method.getParameterTypes(), paramTypes, allowEventBeanType, allowEventBeanCollType, method.getGenericParameterTypes(), method.isVarArgs());
            if (conversionCount == -1) {
                conversionFailedMethod = method;
                continue;
            }
            if (conversionCount == 0 && !method.isVarArgs()) {
                bestMatch = method;
                break;
            }
            if (bestMatch == null) {
                bestMatch = method;
                rank = new MethodExecutableRank(conversionCount, method.isVarArgs());
                continue;
            }
            if (rank.compareTo(conversionCount, method.isVarArgs()) != 1) continue;
            bestMatch = method;
            rank = new MethodExecutableRank(conversionCount, method.isVarArgs());
        }
        if (bestMatch != null) {
            MethodResolver.logWarnBoxedToPrimitiveType(declaringClass, methodName, bestMatch, paramTypes);
            return bestMatch;
        }
        String parametersPretty = MethodResolver.getParametersPretty(paramTypes);
        throw new MethodResolverNoSuchMethodException("Unknown method " + declaringClass.getSimpleName() + '.' + methodName + '(' + parametersPretty + ')', conversionFailedMethod);
    }

    private static String getParametersPretty(EPType[] paramTypes) {
        StringBuilder parameters = new StringBuilder();
        if (paramTypes != null && paramTypes.length != 0) {
            String appendString = "";
            for (EPType param : paramTypes) {
                parameters.append(appendString);
                if (param == null) {
                    parameters.append("(null)");
                } else {
                    parameters.append(param.toString());
                }
                appendString = ", ";
            }
        }
        return parameters.toString();
    }

    private static String getParametersPretty(Class[] paramTypes) {
        StringBuilder parameters = new StringBuilder();
        if (paramTypes != null && paramTypes.length != 0) {
            String appendString = "";
            for (Class param : paramTypes) {
                parameters.append(appendString);
                if (param == null) {
                    parameters.append("(null)");
                } else {
                    parameters.append(((Object)param).toString());
                }
                appendString = ", ";
            }
        }
        return parameters.toString();
    }

    private static void logWarnBoxedToPrimitiveType(Class declaringClass, String methodName, Method bestMatch, EPType[] paramTypes) {
        Class<?>[] parametersMethod = bestMatch.getParameterTypes();
        for (int i = 0; i < parametersMethod.length; ++i) {
            boolean paramNull;
            Class<?> paramMethod = parametersMethod[i];
            if (!paramMethod.isPrimitive()) continue;
            EPType paramType = paramTypes[i];
            boolean bl = paramNull = paramType == null || paramType == EPTypeNull.INSTANCE;
            if (!paramNull && (declaringClass.getClass().getName().startsWith("java") || JavaClassHelper.getBoxedType(paramMethod) != ((EPTypeClass)paramType).getType())) continue;
            String paramTypeStr = paramNull ? "null" : ((EPTypeClass)paramType).toSimpleName();
            log.info("Method '" + methodName + "' in class '" + declaringClass.getName() + "' expects primitive type '" + parametersMethod[i] + "' as parameter " + i + ", but receives a nullable (boxed) type " + paramTypeStr + ". This may cause null pointer exception at runtime if the actual value is null, please consider using boxed types for method parameters.");
            return;
        }
    }

    private static boolean isWideningConversion(Class declarationType, Class invocationType) {
        if (WIDENING_CONVERSIONS.containsKey(declarationType)) {
            return WIDENING_CONVERSIONS.get(declarationType).contains(invocationType);
        }
        return false;
    }

    private static boolean isPublicAndStatic(Method method, boolean allowInstance) {
        int modifiers = method.getModifiers();
        if (allowInstance) {
            return Modifier.isPublic(modifiers);
        }
        return Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers);
    }

    private static int compareParameterTypesAllowContext(Class[] declarationParameters, EPType[] invocationParameters, boolean[] optionalAllowEventBeanType, boolean[] optionalAllowEventBeanCollType, Type[] genericParameterTypes, boolean isVarargs) {
        Class[] declaredNoContext = declarationParameters;
        if (!isVarargs && declarationParameters.length > 0 && declarationParameters[declarationParameters.length - 1] == EPLMethodInvocationContext.class) {
            declaredNoContext = JavaClassHelper.takeFirstN(declarationParameters, declarationParameters.length - 1);
        }
        if (isVarargs && declarationParameters.length > 1 && declarationParameters[declarationParameters.length - 2] == EPLMethodInvocationContext.class) {
            Class[] rewritten = new Class[declarationParameters.length - 1];
            System.arraycopy(declarationParameters, 0, rewritten, 0, declarationParameters.length - 2);
            rewritten[rewritten.length - 1] = declarationParameters[declarationParameters.length - 1];
            declaredNoContext = rewritten;
        }
        return MethodResolver.compareParameterTypesNoContext(declaredNoContext, invocationParameters, optionalAllowEventBeanType, optionalAllowEventBeanCollType, genericParameterTypes, isVarargs);
    }

    private static int compareParameterTypesNoContext(Class[] declarationParameters, EPType[] invocationParameters, boolean[] optionalAllowEventBeanType, boolean[] optionalAllowEventBeanCollType, Type[] genericParameterTypes, boolean isVarargs) {
        if (invocationParameters == null) {
            return declarationParameters.length == 0 ? 0 : -1;
        }
        if (isVarargs) {
            EPType last;
            if (invocationParameters.length < declarationParameters.length - 1) {
                return -1;
            }
            if (invocationParameters.length == 0) {
                return 0;
            }
            AtomicInteger conversionCount = new AtomicInteger();
            for (int i = 0; i < declarationParameters.length - 1; ++i) {
                boolean compatible = MethodResolver.compareParameterTypeCompatible(invocationParameters[i], declarationParameters[i], optionalAllowEventBeanType == null ? null : Boolean.valueOf(optionalAllowEventBeanType[i]), optionalAllowEventBeanCollType == null ? null : Boolean.valueOf(optionalAllowEventBeanCollType[i]), genericParameterTypes[i], conversionCount);
                if (compatible) continue;
                return -1;
            }
            Class<?> varargDeclarationParameter = declarationParameters[declarationParameters.length - 1].getComponentType();
            if (invocationParameters.length == declarationParameters.length && (last = invocationParameters[invocationParameters.length - 1]) != null && last != EPTypeNull.INSTANCE && ((EPTypeClass)last).getType().isArray()) {
                EPTypeClass lastClass = (EPTypeClass)last;
                if (lastClass.getType().getComponentType() == varargDeclarationParameter) {
                    return conversionCount.get();
                }
                if (JavaClassHelper.isSubclassOrImplementsInterface(lastClass.getType().getComponentType(), varargDeclarationParameter)) {
                    conversionCount.incrementAndGet();
                    return conversionCount.get();
                }
            }
            Type varargGenericParameterTypes = genericParameterTypes[genericParameterTypes.length - 1];
            for (int i = declarationParameters.length - 1; i < invocationParameters.length; ++i) {
                boolean compatible = MethodResolver.compareParameterTypeCompatible(invocationParameters[i], varargDeclarationParameter, optionalAllowEventBeanType == null ? null : Boolean.valueOf(optionalAllowEventBeanType[i]), optionalAllowEventBeanCollType == null ? null : Boolean.valueOf(optionalAllowEventBeanCollType[i]), varargGenericParameterTypes, conversionCount);
                if (compatible) continue;
                return -1;
            }
            return conversionCount.get();
        }
        if (declarationParameters.length != invocationParameters.length) {
            return -1;
        }
        AtomicInteger conversionCount = new AtomicInteger();
        for (int i = 0; i < declarationParameters.length; ++i) {
            boolean compatible = MethodResolver.compareParameterTypeCompatible(invocationParameters[i], declarationParameters[i], optionalAllowEventBeanType == null ? null : Boolean.valueOf(optionalAllowEventBeanType[i]), optionalAllowEventBeanCollType == null ? null : Boolean.valueOf(optionalAllowEventBeanCollType[i]), genericParameterTypes[i], conversionCount);
            if (compatible) continue;
            return -1;
        }
        return conversionCount.get();
    }

    private static boolean compareParameterTypeCompatible(EPType invocationParameter, Class declarationParameter, Boolean optionalAllowEventBeanType, Boolean optionalAllowEventBeanCollType, Type genericParameterType, AtomicInteger conversionCount) {
        if (invocationParameter == null || invocationParameter == EPTypeNull.INSTANCE) {
            return !declarationParameter.isPrimitive();
        }
        if (optionalAllowEventBeanType != null && declarationParameter == EventBean.class && optionalAllowEventBeanType.booleanValue()) {
            return true;
        }
        if (optionalAllowEventBeanCollType != null && declarationParameter == Collection.class && optionalAllowEventBeanCollType.booleanValue() && JavaClassHelper.getGenericType(genericParameterType, 0) == EventBean.class) {
            return true;
        }
        EPTypeClass typeClass = (EPTypeClass)invocationParameter;
        if (!MethodResolver.isIdentityConversion(declarationParameter, typeClass.getType())) {
            conversionCount.incrementAndGet();
            if (!MethodResolver.isWideningConversion(declarationParameter, typeClass.getType()) && declarationParameter != Object.class) {
                return false;
            }
        }
        return true;
    }

    private static boolean isIdentityConversion(Class declarationType, Class invocationType) {
        if (WRAPPING_CONVERSIONS.containsKey(declarationType)) {
            return WRAPPING_CONVERSIONS.get(declarationType).contains(invocationType) || declarationType.isAssignableFrom(invocationType);
        }
        if (invocationType == null) {
            return !declarationType.isPrimitive();
        }
        if (invocationType.isPrimitive()) {
            invocationType = JavaClassHelper.getBoxedType(invocationType);
        }
        return declarationType.isAssignableFrom(invocationType);
    }

    public static Constructor resolveCtor(Class declaringClass, EPType[] paramTypes) throws MethodResolverNoSuchCtorException {
        Constructor<?>[] ctors = declaringClass.getConstructors();
        Constructor<?> bestMatch = null;
        MethodExecutableRank rank = null;
        Constructor<?> conversionFailedCtor = null;
        for (Constructor<?> ctor : ctors) {
            if (!Modifier.isPublic(ctor.getModifiers())) continue;
            int conversionCount = MethodResolver.compareParameterTypesNoContext(ctor.getParameterTypes(), paramTypes, null, null, ctor.getGenericParameterTypes(), ctor.isVarArgs());
            if (conversionCount == -1) {
                conversionFailedCtor = ctor;
                continue;
            }
            if (conversionCount == 0 && !ctor.isVarArgs()) {
                bestMatch = ctor;
                break;
            }
            if (bestMatch == null) {
                bestMatch = ctor;
                rank = new MethodExecutableRank(conversionCount, ctor.isVarArgs());
                continue;
            }
            if (rank.compareTo(conversionCount, ctor.isVarArgs()) != 1) continue;
            bestMatch = ctor;
            rank = new MethodExecutableRank(conversionCount, ctor.isVarArgs());
        }
        if (bestMatch != null) {
            return bestMatch;
        }
        StringBuilder parameters = new StringBuilder();
        String message = "Constructor not found for " + declaringClass.getSimpleName() + " taking ";
        if (paramTypes != null && paramTypes.length != 0) {
            String appendString = "";
            for (EPType param : paramTypes) {
                parameters.append(appendString);
                if (param == null) {
                    parameters.append("(null)");
                } else {
                    parameters.append(param.toString());
                }
                appendString = ", ";
            }
            message = message + "('" + parameters + "')'";
        } else {
            message = message + "no parameters";
        }
        throw new MethodResolverNoSuchCtorException(message, conversionFailedCtor);
    }

    public static CodegenExpression resolveMethodCodegenExactNonStatic(Method method) {
        return CodegenExpressionBuilder.staticMethod(MethodResolver.class, "resolveMethodExactNonStatic", CodegenExpressionBuilder.constant(method.getDeclaringClass()), CodegenExpressionBuilder.constant(method.getName()), CodegenExpressionBuilder.constant(method.getParameterTypes()));
    }

    public static Method resolveMethodExactNonStatic(Class declaringClass, String methodName, Class[] parameters) {
        try {
            Method method = declaringClass.getMethod(methodName, parameters);
            if (Modifier.isStatic(method.getModifiers())) {
                throw new EPException("Not an instance method");
            }
            return method;
        }
        catch (Exception ex) {
            String parametersPretty = MethodResolver.getParametersPretty(parameters);
            throw new EPException("Failed to resolve static method " + declaringClass.getSimpleName() + '.' + methodName + '(' + parametersPretty + ": " + ex.getMessage(), ex);
        }
    }

    static {
        HashSet<Class<Boolean>> booleanWrappers = new HashSet<Class<Boolean>>();
        booleanWrappers.add(Boolean.TYPE);
        booleanWrappers.add(Boolean.class);
        WRAPPING_CONVERSIONS.put(Boolean.TYPE, booleanWrappers);
        WRAPPING_CONVERSIONS.put(Boolean.class, booleanWrappers);
        HashSet<Class<Character>> charWrappers = new HashSet<Class<Character>>();
        charWrappers.add(Character.TYPE);
        charWrappers.add(Character.class);
        WRAPPING_CONVERSIONS.put(Character.TYPE, charWrappers);
        WRAPPING_CONVERSIONS.put(Character.class, charWrappers);
        HashSet<Class<Byte>> byteWrappers = new HashSet<Class<Byte>>();
        byteWrappers.add(Byte.TYPE);
        byteWrappers.add(Byte.class);
        WRAPPING_CONVERSIONS.put(Byte.TYPE, byteWrappers);
        WRAPPING_CONVERSIONS.put(Byte.class, byteWrappers);
        HashSet<Class<Short>> shortWrappers = new HashSet<Class<Short>>();
        shortWrappers.add(Short.TYPE);
        shortWrappers.add(Short.class);
        WRAPPING_CONVERSIONS.put(Short.TYPE, shortWrappers);
        WRAPPING_CONVERSIONS.put(Short.class, shortWrappers);
        HashSet<Class<Integer>> intWrappers = new HashSet<Class<Integer>>();
        intWrappers.add(Integer.TYPE);
        intWrappers.add(Integer.class);
        WRAPPING_CONVERSIONS.put(Integer.TYPE, intWrappers);
        WRAPPING_CONVERSIONS.put(Integer.class, intWrappers);
        HashSet<Class<Long>> longWrappers = new HashSet<Class<Long>>();
        longWrappers.add(Long.TYPE);
        longWrappers.add(Long.class);
        WRAPPING_CONVERSIONS.put(Long.TYPE, longWrappers);
        WRAPPING_CONVERSIONS.put(Long.class, longWrappers);
        HashSet<Class<Float>> floatWrappers = new HashSet<Class<Float>>();
        floatWrappers.add(Float.TYPE);
        floatWrappers.add(Float.class);
        WRAPPING_CONVERSIONS.put(Float.TYPE, floatWrappers);
        WRAPPING_CONVERSIONS.put(Float.class, floatWrappers);
        HashSet<Class<Double>> doubleWrappers = new HashSet<Class<Double>>();
        doubleWrappers.add(Double.TYPE);
        doubleWrappers.add(Double.class);
        WRAPPING_CONVERSIONS.put(Double.TYPE, doubleWrappers);
        WRAPPING_CONVERSIONS.put(Double.class, doubleWrappers);
        HashSet<Class<Float>> wideningConversions = new HashSet<Class<Float>>(byteWrappers);
        WIDENING_CONVERSIONS.put(Short.TYPE, new HashSet(wideningConversions));
        WIDENING_CONVERSIONS.put(Short.class, new HashSet(wideningConversions));
        wideningConversions.addAll(shortWrappers);
        wideningConversions.addAll(charWrappers);
        WIDENING_CONVERSIONS.put(Integer.TYPE, new HashSet(wideningConversions));
        WIDENING_CONVERSIONS.put(Integer.class, new HashSet(wideningConversions));
        wideningConversions.addAll(intWrappers);
        WIDENING_CONVERSIONS.put(Long.TYPE, new HashSet(wideningConversions));
        WIDENING_CONVERSIONS.put(Long.class, new HashSet(wideningConversions));
        wideningConversions.addAll(longWrappers);
        WIDENING_CONVERSIONS.put(Float.TYPE, new HashSet(wideningConversions));
        WIDENING_CONVERSIONS.put(Float.class, new HashSet(wideningConversions));
        wideningConversions.addAll(floatWrappers);
        WIDENING_CONVERSIONS.put(Double.TYPE, new HashSet(wideningConversions));
        WIDENING_CONVERSIONS.put(Double.class, new HashSet(wideningConversions));
    }
}

