/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.util;

import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionField;
import com.espertech.esper.common.internal.collection.Pair;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import com.espertech.esper.common.internal.util.SimpleTypeCaster;
import java.util.concurrent.CopyOnWriteArraySet;

public class SimpleTypeCasterAnyType
implements SimpleTypeCaster {
    private final EPTypeClass typeToCastTo;
    private CopyOnWriteArraySet<Pair<Class, Boolean>> pairs = new CopyOnWriteArraySet();

    public SimpleTypeCasterAnyType(EPTypeClass typeToCastTo) {
        this.typeToCastTo = typeToCastTo;
    }

    @Override
    public boolean isNumericCast() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object simpleTypeCasterCast(Object object, EPTypeClass typeToCastTo, CopyOnWriteArraySet<Pair<Class, Boolean>> pairs) {
        if (object.getClass() == typeToCastTo.getType()) {
            return object;
        }
        for (Pair<Class, Boolean> pair : pairs) {
            if (pair.getFirst() != typeToCastTo.getType()) continue;
            if (!((Boolean)pair.getSecond()).booleanValue()) {
                return null;
            }
            return object;
        }
        CopyOnWriteArraySet<Pair<Class, Boolean>> copyOnWriteArraySet = pairs;
        synchronized (copyOnWriteArraySet) {
            for (Pair pair : pairs) {
                if (pair.getFirst() != typeToCastTo.getType()) continue;
                if (!((Boolean)pair.getSecond()).booleanValue()) {
                    return null;
                }
                return object;
            }
            boolean passed = JavaClassHelper.isSubclassOrImplementsInterface(object.getClass(), typeToCastTo.getType());
            if (passed) {
                pairs.add(new Pair(object.getClass(), true));
                return object;
            }
            pairs.add(new Pair(object.getClass(), false));
            return null;
        }
    }

    @Override
    public Object cast(Object object) {
        return SimpleTypeCasterAnyType.simpleTypeCasterCast(object, this.typeToCastTo, this.pairs);
    }

    @Override
    public CodegenExpression codegen(CodegenExpression input, EPTypeClass inputType, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        if (JavaClassHelper.isSubclassOrImplementsInterface((EPType)inputType, this.typeToCastTo)) {
            return input;
        }
        CodegenExpressionField cache = codegenClassScope.addFieldUnshared(true, EPTypePremade.COPYONWRITEARRAYSET.getEPType(), CodegenExpressionBuilder.newInstance(EPTypePremade.COPYONWRITEARRAYSET.getEPType(), new CodegenExpression[0]));
        return CodegenExpressionBuilder.cast(this.typeToCastTo, CodegenExpressionBuilder.staticMethod(SimpleTypeCasterAnyType.class, "simpleTypeCasterCast", input, CodegenExpressionBuilder.constant(this.typeToCastTo), cache));
    }
}

