/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.util;

import java.net.URI;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;

public class URIUtil {
    public static Collection<Map.Entry<URI, Object>> filterSort(URI child, Map<URI, Object> uris) {
        boolean childPathIsOpaque = child.isOpaque();
        boolean childPathIsRelative = !child.isAbsolute();
        String[] childPathElements = URIUtil.parsePathElements(child);
        TreeMap<Integer, Map.Entry<URI, Object>> result = new TreeMap<Integer, Map.Entry<URI, Object>>();
        for (Map.Entry<URI, Object> entry : uris.entrySet()) {
            String[] factoryPathElements;
            int score;
            URI facoryUri = entry.getKey();
            if (childPathIsOpaque || childPathIsRelative || !facoryUri.isAbsolute() || facoryUri.isOpaque()) {
                if (!facoryUri.equals(child)) continue;
                result.put(Integer.MIN_VALUE, entry);
                continue;
            }
            if (child.getScheme() != null && facoryUri.getScheme() == null || child.getScheme() == null && facoryUri.getScheme() != null || child.getScheme() != null && !child.getScheme().equals(facoryUri.getScheme()) || child.getAuthority() != null && facoryUri.getAuthority() == null || child.getAuthority() == null && facoryUri.getAuthority() != null || child.getAuthority() != null && !child.getAuthority().equals(facoryUri.getAuthority()) || (score = URIUtil.computeScore(childPathElements, factoryPathElements = URIUtil.parsePathElements(facoryUri))) <= 0) continue;
            result.put(score, entry);
        }
        return result.values();
    }

    public static String[] parsePathElements(URI uri) {
        String path = uri.getPath();
        if (path == null) {
            return new String[0];
        }
        while (path.startsWith("/")) {
            path = path.substring(1);
        }
        String[] split = path.split("/");
        if (split.length > 0 && split[0].length() == 0) {
            return new String[0];
        }
        return split;
    }

    private static int computeScore(String[] childPathElements, String[] factoryPathElements) {
        int index = 0;
        if (factoryPathElements.length == 0) {
            return Integer.MAX_VALUE;
        }
        while (true) {
            if (childPathElements.length > index && factoryPathElements.length > index) {
                if (!childPathElements[index].equals(factoryPathElements[index])) {
                    return 0;
                }
            } else if (childPathElements.length <= index) {
                if (factoryPathElements.length > index) {
                    return 0;
                }
                return Integer.MAX_VALUE - index - 1;
            }
            if (factoryPathElements.length <= index) break;
            ++index;
        }
        return Integer.MAX_VALUE - index - 1;
    }
}

