/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.view.core;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.collection.Pair;
import com.espertech.esper.common.internal.compile.stage1.spec.ViewSpec;
import com.espertech.esper.common.internal.compile.stage3.StmtClassForgeableFactory;
import com.espertech.esper.common.internal.context.aifactory.core.SAIFFInitializeSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityCompare;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.fabric.FabricCharge;
import com.espertech.esper.common.internal.schedule.ScheduleHandleCallbackProvider;
import com.espertech.esper.common.internal.schedule.ScheduleHandleTracked;
import com.espertech.esper.common.internal.serde.compiletime.eventtype.SerdeEventTypeUtility;
import com.espertech.esper.common.internal.util.IntArrayUtil;
import com.espertech.esper.common.internal.view.core.DataWindowViewForge;
import com.espertech.esper.common.internal.view.core.ViewEnum;
import com.espertech.esper.common.internal.view.core.ViewFactory;
import com.espertech.esper.common.internal.view.core.ViewFactoryContext;
import com.espertech.esper.common.internal.view.core.ViewFactoryForge;
import com.espertech.esper.common.internal.view.core.ViewFactoryForgeArgs;
import com.espertech.esper.common.internal.view.core.ViewFactoryForgeDesc;
import com.espertech.esper.common.internal.view.core.ViewForgeEnv;
import com.espertech.esper.common.internal.view.core.ViewParameterException;
import com.espertech.esper.common.internal.view.core.ViewProcessingException;
import com.espertech.esper.common.internal.view.groupwin.GroupByViewFactoryForge;
import com.espertech.esper.common.internal.view.groupwin.MergeViewFactoryForge;
import com.espertech.esper.common.internal.view.intersect.IntersectViewFactoryForge;
import com.espertech.esper.common.internal.view.union.UnionViewFactoryForge;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class ViewFactoryForgeUtil {
    public static ViewFactoryForgeDesc createForges(ViewSpec[] viewSpecDefinitions, ViewFactoryForgeArgs args, EventType parentEventType) throws ExprValidationException {
        try {
            ArrayList<ViewSpec> viewSpecList = new ArrayList<ViewSpec>(Arrays.asList(viewSpecDefinitions));
            ArrayList<StmtClassForgeableFactory> additionalForgeables = new ArrayList<StmtClassForgeableFactory>(2);
            ViewFactoryForgeUtil.addMergeViews(viewSpecList);
            ViewForgeEnv viewForgeEnv = new ViewForgeEnv(args);
            List<ViewFactoryForge> forgesChain = ViewFactoryForgeUtil.instantiateFactories(viewSpecList, args, viewForgeEnv);
            for (ViewFactoryForge forge : forgesChain) {
                if (!(forge instanceof DataWindowViewForge)) continue;
                List<StmtClassForgeableFactory> serdeForgeables = SerdeEventTypeUtility.plan(parentEventType, viewForgeEnv.getStatementRawInfo(), viewForgeEnv.getSerdeEventTypeRegistry(), viewForgeEnv.getSerdeResolver(), viewForgeEnv.getStateMgmtSettingsProvider());
                additionalForgeables.addAll(serdeForgeables);
            }
            List<ViewFactoryForge> forgesChainWIntersections = ViewFactoryForgeUtil.buildIntersectionsUnions(forgesChain, args, viewForgeEnv, parentEventType);
            ViewFactoryForgeUtil.verifyGroups(forgesChainWIntersections);
            List<ViewFactoryForge> forgesGrouped = ViewFactoryForgeUtil.buildGrouped(forgesChainWIntersections, args, viewForgeEnv, parentEventType);
            EventType eventType = parentEventType;
            for (int i = 0; i < forgesGrouped.size(); ++i) {
                ViewFactoryForge factoryToAttach = forgesGrouped.get(i);
                try {
                    factoryToAttach.attach(eventType, viewForgeEnv);
                    eventType = factoryToAttach.getEventType();
                    continue;
                }
                catch (ViewParameterException ex) {
                    throw new ViewProcessingException(ex.getMessage(), ex);
                }
            }
            List<StmtClassForgeableFactory> multikeyForges = ViewFactoryForgeUtil.getMultikeyForges(forgesGrouped, viewForgeEnv);
            additionalForgeables.addAll(multikeyForges);
            Pair<List<ScheduleHandleTracked>, FabricCharge> states = ViewFactoryForgeUtil.getStateMgmtSettings(forgesGrouped, viewForgeEnv);
            return new ViewFactoryForgeDesc(forgesGrouped, additionalForgeables, states.getFirst(), states.getSecond());
        }
        catch (ViewProcessingException ex) {
            throw new ExprValidationException("Failed to validate data window declaration: " + ex.getMessage(), ex);
        }
    }

    private static List<StmtClassForgeableFactory> getMultikeyForges(List<ViewFactoryForge> forges, ViewForgeEnv viewForgeEnv) {
        ArrayList<StmtClassForgeableFactory> factories = new ArrayList<StmtClassForgeableFactory>(1);
        ViewFactoryForgeUtil.getMultikeyForgesRecursive(forges, factories, viewForgeEnv);
        return factories;
    }

    private static void getMultikeyForgesRecursive(List<ViewFactoryForge> forges, List<StmtClassForgeableFactory> multikeyForges, ViewForgeEnv viewForgeEnv) {
        for (ViewFactoryForge forge : forges) {
            List<StmtClassForgeableFactory> plan = forge.initAdditionalForgeables(viewForgeEnv);
            multikeyForges.addAll(plan);
            ViewFactoryForgeUtil.getMultikeyForgesRecursive(forge.getInnerForges(), multikeyForges, viewForgeEnv);
        }
    }

    private static Pair<List<ScheduleHandleTracked>, FabricCharge> getStateMgmtSettings(List<ViewFactoryForge> forges, ViewForgeEnv viewForgeEnv) throws ViewProcessingException {
        FabricCharge fabricCharge = viewForgeEnv.getStateMgmtSettingsProvider().newCharge();
        ArrayList<ScheduleHandleTracked> schedules = new ArrayList<ScheduleHandleTracked>(2);
        for (ViewFactoryForge forge : forges) {
            if (forge instanceof ScheduleHandleCallbackProvider) {
                schedules.add(new ScheduleHandleTracked(viewForgeEnv.getAttributionUngrouped(), (ScheduleHandleCallbackProvider)((Object)forge)));
            }
            try {
                forge.assignStateMgmtSettings(fabricCharge, viewForgeEnv, null);
            }
            catch (ViewParameterException e) {
                throw new ViewProcessingException(e.getMessage(), e);
            }
            ViewFactoryForgeUtil.getStateMgmtSettingsGroupedRecursive(forge.getInnerForges(), fabricCharge, schedules, viewForgeEnv, null);
        }
        return new Pair<List<ScheduleHandleTracked>, FabricCharge>(schedules, fabricCharge);
    }

    private static void getStateMgmtSettingsGroupedRecursive(List<ViewFactoryForge> forges, FabricCharge fabricCharge, List<ScheduleHandleTracked> schedules, ViewForgeEnv viewForgeEnv, int[] grouping) {
        for (int i = 0; i < forges.size(); ++i) {
            int[] nArray;
            if (grouping == null) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = i;
            } else {
                nArray = IntArrayUtil.append(grouping, i);
            }
            int[] groupingChild = nArray;
            ViewFactoryForge child = forges.get(i);
            try {
                if (child instanceof ScheduleHandleCallbackProvider) {
                    schedules.add(new ScheduleHandleTracked(viewForgeEnv.getAttributionGrouped(groupingChild), (ScheduleHandleCallbackProvider)((Object)child)));
                }
                child.assignStateMgmtSettings(fabricCharge, viewForgeEnv, groupingChild);
            }
            catch (ViewParameterException e) {
                throw new ViewProcessingException(e.getMessage(), e);
            }
            ViewFactoryForgeUtil.getStateMgmtSettingsGroupedRecursive(child.getInnerForges(), fabricCharge, schedules, viewForgeEnv, groupingChild);
        }
    }

    private static List<ViewFactoryForge> buildGrouped(List<ViewFactoryForge> forgesChain, ViewFactoryForgeArgs args, ViewForgeEnv viewForgeEnv, EventType parentEventType) {
        if (forgesChain.isEmpty()) {
            return forgesChain;
        }
        if (!(forgesChain.get(0) instanceof GroupByViewFactoryForge)) {
            return forgesChain;
        }
        GroupByViewFactoryForge group = (GroupByViewFactoryForge)forgesChain.get(0);
        int indexMerge = -1;
        for (int i = 0; i < forgesChain.size(); ++i) {
            if (!(forgesChain.get(i) instanceof MergeViewFactoryForge)) continue;
            indexMerge = i;
            break;
        }
        if (indexMerge == -1 || indexMerge == 1) {
            throw new IllegalArgumentException();
        }
        ArrayList<ViewFactoryForge> groupeds = new ArrayList<ViewFactoryForge>(indexMerge - 1);
        EventType eventType = parentEventType;
        for (int i = 1; i < indexMerge; ++i) {
            ViewFactoryForge forge = forgesChain.get(i);
            groupeds.add(forge);
            try {
                forge.attach(eventType, viewForgeEnv);
                continue;
            }
            catch (ViewParameterException ex) {
                throw new ViewProcessingException(ex.getMessage(), ex);
            }
        }
        group.setGroupeds(groupeds);
        ArrayList<ViewFactoryForge> remainder = new ArrayList<ViewFactoryForge>(1);
        remainder.add(group);
        for (int i = indexMerge + 1; i < forgesChain.size(); ++i) {
            remainder.add(forgesChain.get(i));
        }
        return remainder;
    }

    private static List<ViewFactoryForge> buildIntersectionsUnions(List<ViewFactoryForge> forges, ViewFactoryForgeArgs args, ViewForgeEnv viewForgeEnv, EventType parentEventType) {
        ArrayList<ViewFactoryForge> result = new ArrayList<ViewFactoryForge>(forges.size());
        ArrayList<ViewFactoryForge> dataWindows = new ArrayList<ViewFactoryForge>(2);
        for (ViewFactoryForge forge : forges) {
            if (forge instanceof DataWindowViewForge) {
                dataWindows.add(forge);
                continue;
            }
            if (!dataWindows.isEmpty()) {
                if (dataWindows.size() == 1) {
                    result.addAll(dataWindows);
                } else {
                    ViewFactoryForge intersectUnion = ViewFactoryForgeUtil.makeIntersectOrUnion(dataWindows, args, viewForgeEnv, parentEventType);
                    result.add(intersectUnion);
                }
                dataWindows.clear();
            }
            result.add(forge);
        }
        if (!dataWindows.isEmpty()) {
            if (dataWindows.size() == 1) {
                result.addAll(dataWindows);
            } else {
                ViewFactoryForge intersectUnion = ViewFactoryForgeUtil.makeIntersectOrUnion(dataWindows, args, viewForgeEnv, parentEventType);
                result.add(intersectUnion);
            }
        }
        return result;
    }

    private static ViewFactoryForge makeIntersectOrUnion(List<ViewFactoryForge> dataWindows, ViewFactoryForgeArgs args, ViewForgeEnv viewForgeEnv, EventType parentEventType) {
        for (ViewFactoryForge forge : dataWindows) {
            try {
                forge.attach(parentEventType, viewForgeEnv);
            }
            catch (ViewParameterException ex) {
                throw new ViewProcessingException(ex.getMessage(), ex);
            }
        }
        if (args.getOptions().isRetainUnion()) {
            return new UnionViewFactoryForge(new ArrayList<ViewFactoryForge>(dataWindows));
        }
        return new IntersectViewFactoryForge(new ArrayList<ViewFactoryForge>(dataWindows));
    }

    private static void verifyGroups(List<ViewFactoryForge> forges) {
        GroupByViewFactoryForge group = null;
        MergeViewFactoryForge merge = null;
        int numDataWindows = 0;
        for (ViewFactoryForge forge : forges) {
            if (forge instanceof GroupByViewFactoryForge) {
                if (group == null) {
                    group = (GroupByViewFactoryForge)forge;
                } else {
                    throw new ViewProcessingException("Multiple groupwin-declarations are not supported");
                }
            }
            if (forge instanceof MergeViewFactoryForge) {
                if (merge == null) {
                    merge = (MergeViewFactoryForge)forge;
                } else {
                    throw new ViewProcessingException("Multiple merge-declarations are not supported");
                }
            }
            numDataWindows += forge instanceof DataWindowViewForge ? 1 : 0;
        }
        if (group != null && group != forges.get(0)) {
            throw new ViewProcessingException("The 'groupwin' declaration must occur in the first position");
        }
        if (merge != null) {
            if (numDataWindows > 1) {
                throw new ViewProcessingException("The 'merge' declaration cannot be used in conjunction with multiple data windows");
            }
            if (group == null) {
                throw new ViewProcessingException("The 'merge' declaration cannot be used in without a 'group' declaration");
            }
            if (!ExprNodeUtilityCompare.deepEquals(group.getViewParameters(), merge.getViewParameters())) {
                throw new ViewProcessingException("Mismatching parameters between 'group' and 'merge'");
            }
        }
    }

    private static List<ViewFactoryForge> instantiateFactories(List<ViewSpec> viewSpecList, ViewFactoryForgeArgs args, ViewForgeEnv viewForgeEnv) throws ViewProcessingException {
        ArrayList<ViewFactoryForge> forges = new ArrayList<ViewFactoryForge>();
        for (ViewSpec spec : viewSpecList) {
            ViewFactoryForge viewFactoryForge = args.getViewResolutionService().create(spec.getObjectNamespace(), spec.getObjectName(), args.getOptionalCreateNamedWindowName());
            forges.add(viewFactoryForge);
            try {
                viewFactoryForge.setViewParameters(spec.getObjectParameters(), viewForgeEnv, args.getStreamNum());
            }
            catch (ViewParameterException e) {
                throw new ViewProcessingException("Error in view '" + spec.getObjectName() + "', " + e.getMessage(), e);
            }
        }
        return forges;
    }

    private static void addMergeViews(List<ViewSpec> specifications) throws ViewProcessingException {
        ViewEnum viewEnum;
        ViewSpec lastView;
        ViewEnum viewEnum2;
        if (specifications.size() > 0 && (viewEnum2 = ViewEnum.forName((lastView = specifications.get(specifications.size() - 1)).getObjectNamespace(), lastView.getObjectName())) != null && viewEnum2.getMergeView() != null) {
            throw new ViewProcessingException("Invalid use of the '" + lastView.getObjectName() + "' view, the view requires one or more child views to group, or consider using the group-by clause");
        }
        LinkedList<ViewSpec> mergeViewSpecs = new LinkedList<ViewSpec>();
        boolean foundMerge = false;
        for (ViewSpec spec : specifications) {
            viewEnum = ViewEnum.forName(spec.getObjectNamespace(), spec.getObjectName());
            if (viewEnum != ViewEnum.GROUP_MERGE) continue;
            foundMerge = true;
            break;
        }
        if (foundMerge) {
            return;
        }
        for (ViewSpec spec : specifications) {
            viewEnum = ViewEnum.forName(spec.getObjectNamespace(), spec.getObjectName());
            if (viewEnum == null || viewEnum.getMergeView() == null) continue;
            ViewSpec mergeViewSpec = new ViewSpec(viewEnum.getMergeView().getNamespace(), viewEnum.getMergeView().getName(), spec.getObjectParameters());
            mergeViewSpecs.addFirst(mergeViewSpec);
        }
        specifications.addAll(mergeViewSpecs);
    }

    public static CodegenMethod makeViewFactories(List<ViewFactoryForge> forges, Class generator, CodegenMethodScope parent, CodegenClassScope classScope, SAIFFInitializeSymbol symbols) {
        CodegenMethod method = parent.makeChild(ViewFactory.EPTYPEARRAY, generator, (CodegenScope)classScope);
        method.getBlock().declareVar(ViewFactory.EPTYPEARRAY, "groupeds", CodegenExpressionBuilder.newArrayByLength(ViewFactory.EPTYPE, CodegenExpressionBuilder.constant(forges.size())));
        for (int i = 0; i < forges.size(); ++i) {
            method.getBlock().assignArrayElement("groupeds", CodegenExpressionBuilder.constant(i), forges.get(i).make(method, symbols, classScope));
        }
        method.getBlock().methodReturn(CodegenExpressionBuilder.ref("groupeds"));
        return method;
    }

    public static CodegenExpression codegenForgesWInit(List<ViewFactoryForge> forges, int streamNum, Integer subqueryNum, CodegenMethodScope parent, SAIFFInitializeSymbol symbols, CodegenClassScope classScope) {
        if (forges.isEmpty()) {
            return CodegenExpressionBuilder.publicConstValue(ViewFactory.EPTYPE.getType(), "EMPTY_ARRAY");
        }
        CodegenMethod method = parent.makeChild(ViewFactory.EPTYPEARRAY, ViewFactoryForgeUtil.class, (CodegenScope)classScope);
        method.getBlock().declareVar(ViewFactory.EPTYPEARRAY, "factories", CodegenExpressionBuilder.newArrayByLength(ViewFactory.EPTYPE, CodegenExpressionBuilder.constant(forges.size())));
        method.getBlock().declareVarNewInstance(ViewFactoryContext.EPTYPE, "ctx").exprDotMethod(CodegenExpressionBuilder.ref("ctx"), "setStreamNum", CodegenExpressionBuilder.constant(streamNum)).exprDotMethod(CodegenExpressionBuilder.ref("ctx"), "setSubqueryNumber", CodegenExpressionBuilder.constant(subqueryNum));
        for (int i = 0; i < forges.size(); ++i) {
            String ref = "factory_" + i;
            method.getBlock().declareVar(ViewFactory.EPTYPE, ref, forges.get(i).make(method, symbols, classScope)).exprDotMethod(CodegenExpressionBuilder.ref(ref), "init", CodegenExpressionBuilder.ref("ctx"), symbols.getAddInitSvc(method)).assignArrayElement(CodegenExpressionBuilder.ref("factories"), CodegenExpressionBuilder.constant(i), (CodegenExpression)CodegenExpressionBuilder.ref(ref));
        }
        method.getBlock().methodReturn(CodegenExpressionBuilder.ref("factories"));
        return CodegenExpressionBuilder.localMethod(method, new CodegenExpression[0]);
    }

    public static boolean hasDataWindows(List<ViewFactoryForge> views) {
        for (ViewFactoryForge view : views) {
            if (view instanceof DataWindowViewForge) {
                return true;
            }
            if (!(view instanceof GroupByViewFactoryForge)) continue;
            GroupByViewFactoryForge grouped = (GroupByViewFactoryForge)view;
            return ViewFactoryForgeUtil.hasDataWindows(grouped.getGroupeds());
        }
        return false;
    }
}

