/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.view.expression;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.collection.ViewUpdatedCollection;
import com.espertech.esper.common.internal.event.arr.ObjectArrayEventBean;
import com.espertech.esper.common.internal.schedule.ScheduleObjectType;
import com.espertech.esper.common.internal.view.core.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.common.internal.view.core.ViewDataVisitor;
import com.espertech.esper.common.internal.view.expression.ExpressionBatchViewFactory;
import com.espertech.esper.common.internal.view.expression.ExpressionBatchViewUtil;
import com.espertech.esper.common.internal.view.expression.ExpressionViewBase;
import com.espertech.esper.common.internal.view.expression.ExpressionViewOAFieldEnum;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

public class ExpressionBatchView
extends ExpressionViewBase {
    protected final Set<EventBean> window = new LinkedHashSet<EventBean>();
    protected EventBean[] lastBatch;
    protected long newestEventTimestamp;
    protected long oldestEventTimestamp;
    protected EventBean oldestEvent;
    protected EventBean newestEvent;

    public ExpressionBatchView(ExpressionBatchViewFactory factory, ViewUpdatedCollection viewUpdatedCollection, ObjectArrayEventBean builtinEventProps, AgentInstanceViewFactoryChainContext agentInstanceContext) {
        super(factory, viewUpdatedCollection, builtinEventProps, agentInstanceContext);
    }

    public boolean isEmpty() {
        return this.window.isEmpty();
    }

    @Override
    public void scheduleCallback() {
        boolean fireBatch = this.evaluateExpression(null, this.window.size());
        if (fireBatch) {
            this.expire(this.window.size());
        }
    }

    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
        this.agentInstanceContext.getAuditProvider().view(newData, oldData, this.agentInstanceContext, this.factory);
        this.agentInstanceContext.getInstrumentationProvider().qViewProcessIRStream(this.factory, newData, oldData);
        boolean fireBatch = false;
        if (oldData != null) {
            for (EventBean anOldData : oldData) {
                this.window.remove(anOldData);
            }
            if (this.aggregationService != null) {
                this.aggregationService.applyLeave(oldData, null, this.agentInstanceContext);
            }
            this.oldestEvent = !this.window.isEmpty() ? this.window.iterator().next() : null;
            fireBatch = this.evaluateExpression(null, this.window.size());
        }
        int numEventsInBatch = -1;
        if (newData != null && newData.length > 0) {
            if (this.window.isEmpty()) {
                this.oldestEventTimestamp = this.agentInstanceContext.getStatementContext().getSchedulingService().getTime();
            }
            this.newestEventTimestamp = this.agentInstanceContext.getStatementContext().getSchedulingService().getTime();
            if (this.oldestEvent == null) {
                this.oldestEvent = newData[0];
            }
            for (EventBean newEvent : newData) {
                this.window.add(newEvent);
                if (this.aggregationService != null) {
                    this.aggregationService.applyEnter(new EventBean[]{newEvent}, null, this.agentInstanceContext);
                }
                this.newestEvent = newEvent;
                if (fireBatch || !(fireBatch = this.evaluateExpression(newEvent, this.window.size())) || ((ExpressionBatchViewFactory)this.factory).isIncludeTriggeringEvent()) continue;
                numEventsInBatch = this.window.size() - 1;
            }
        }
        if (fireBatch) {
            this.expire(numEventsInBatch);
        }
        this.agentInstanceContext.getInstrumentationProvider().aViewProcessIRStream();
    }

    public void expire(int numEventsInBatch) {
        if (numEventsInBatch == this.window.size() || numEventsInBatch == -1) {
            EventBean[] batchNewData = this.window.toArray(new EventBean[this.window.size()]);
            if (this.viewUpdatedCollection != null) {
                this.viewUpdatedCollection.update(batchNewData, this.lastBatch);
            }
            if (batchNewData != null || this.lastBatch != null) {
                this.agentInstanceContext.getInstrumentationProvider().qViewIndicate(this.factory, batchNewData, this.lastBatch);
                this.child.update(batchNewData, this.lastBatch);
                this.agentInstanceContext.getInstrumentationProvider().aViewIndicate();
            }
            this.window.clear();
            this.lastBatch = batchNewData;
            if (this.aggregationService != null) {
                this.aggregationService.clearResults(this.agentInstanceContext);
            }
            this.oldestEvent = null;
            this.newestEvent = null;
        } else {
            EventBean[] batchNewData = new EventBean[numEventsInBatch];
            Iterator<EventBean> it = this.window.iterator();
            for (int i = 0; i < batchNewData.length; ++i) {
                batchNewData[i] = it.next();
                it.remove();
            }
            if (this.viewUpdatedCollection != null) {
                this.viewUpdatedCollection.update(batchNewData, this.lastBatch);
            }
            if (batchNewData != null || this.lastBatch != null) {
                this.agentInstanceContext.getInstrumentationProvider().qViewIndicate(this.factory, batchNewData, this.lastBatch);
                this.child.update(batchNewData, this.lastBatch);
                this.agentInstanceContext.getInstrumentationProvider().aViewIndicate();
            }
            this.lastBatch = batchNewData;
            if (this.aggregationService != null) {
                this.aggregationService.applyLeave(batchNewData, null, this.agentInstanceContext);
            }
            this.oldestEvent = this.window.iterator().next();
        }
    }

    @Override
    public void visitView(ViewDataVisitor viewDataVisitor) {
        viewDataVisitor.visitPrimary(this.window, true, this.factory.getViewName(), null);
        viewDataVisitor.visitPrimary(this.lastBatch, this.factory.getViewName());
    }

    private boolean evaluateExpression(EventBean arriving, int windowSize) {
        ExpressionViewOAFieldEnum.populate(this.builtinEventProps.getProperties(), windowSize, this.oldestEventTimestamp, this.newestEventTimestamp, this, 0, this.oldestEvent, this.newestEvent);
        this.eventsPerStream[0] = arriving;
        return ExpressionBatchViewUtil.evaluate(this.eventsPerStream, this.agentInstanceContext, this.factory, this.aggregationService);
    }

    @Override
    public final Iterator<EventBean> iterator() {
        return this.window.iterator();
    }

    @Override
    public void update(Object newValue, Object oldValue) {
        if (!this.agentInstanceContext.getStatementContext().getSchedulingService().isScheduled(this.scheduleHandle)) {
            this.agentInstanceContext.getAuditProvider().scheduleAdd(0L, this.agentInstanceContext, this.scheduleHandle, ScheduleObjectType.view, this.factory.getViewName());
            this.agentInstanceContext.getStatementContext().getSchedulingService().add(0L, this.scheduleHandle, this.scheduleSlot);
        }
    }
}

