/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.view.exttimedwin;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.collection.TimeWindow;
import com.espertech.esper.common.internal.collection.ViewUpdatedCollection;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.epl.expression.time.eval.TimePeriodProvide;
import com.espertech.esper.common.internal.util.CollectionUtil;
import com.espertech.esper.common.internal.view.core.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.common.internal.view.core.DataWindowView;
import com.espertech.esper.common.internal.view.core.ViewDataVisitor;
import com.espertech.esper.common.internal.view.core.ViewFactory;
import com.espertech.esper.common.internal.view.core.ViewSupport;
import com.espertech.esper.common.internal.view.exttimedwin.ExternallyTimedWindowViewFactory;
import java.util.ArrayDeque;
import java.util.Iterator;

public class ExternallyTimedWindowView
extends ViewSupport
implements DataWindowView {
    private final ExternallyTimedWindowViewFactory factory;
    private final EventBean[] eventsPerStream = new EventBean[1];
    protected final TimeWindow timeWindow;
    private ViewUpdatedCollection viewUpdatedCollection;
    protected AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext;
    private final TimePeriodProvide timePeriodProvide;

    public ExternallyTimedWindowView(ExternallyTimedWindowViewFactory factory, ViewUpdatedCollection viewUpdatedCollection, AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext, TimePeriodProvide timePeriodProvide) {
        this.factory = factory;
        this.viewUpdatedCollection = viewUpdatedCollection;
        this.timeWindow = new TimeWindow(agentInstanceViewFactoryContext.isRemoveStream());
        this.agentInstanceViewFactoryContext = agentInstanceViewFactoryContext;
        this.timePeriodProvide = timePeriodProvide;
    }

    @Override
    public final EventType getEventType() {
        return this.parent.getEventType();
    }

    @Override
    public final void update(EventBean[] newData, EventBean[] oldData) {
        AgentInstanceContext agentInstanceContext = this.agentInstanceViewFactoryContext.getAgentInstanceContext();
        agentInstanceContext.getAuditProvider().view(newData, oldData, agentInstanceContext, this.factory);
        agentInstanceContext.getInstrumentationProvider().qViewProcessIRStream(this.factory, newData, oldData);
        long timestamp = -1L;
        if (newData != null) {
            for (int i = 0; i < newData.length; ++i) {
                timestamp = this.getLongValue(newData[i]);
                this.timeWindow.add(timestamp, newData[i]);
            }
        }
        ArrayDeque<EventBean> expired = null;
        if (timestamp != -1L) {
            expired = this.timeWindow.expireEvents(timestamp - this.timePeriodProvide.deltaSubtract(timestamp, null, true, this.agentInstanceViewFactoryContext) + 1L);
        }
        EventBean[] oldDataUpdate = null;
        if (expired != null && !expired.isEmpty()) {
            oldDataUpdate = expired.toArray(new EventBean[expired.size()]);
        }
        if (oldData != null && this.agentInstanceViewFactoryContext.isRemoveStream()) {
            for (EventBean anOldData : oldData) {
                this.timeWindow.remove(anOldData);
            }
            oldDataUpdate = oldDataUpdate == null ? oldData : CollectionUtil.addArrayWithSetSemantics(oldData, oldDataUpdate);
        }
        if (this.viewUpdatedCollection != null) {
            this.viewUpdatedCollection.update(newData, oldDataUpdate);
        }
        if (this.child != null) {
            agentInstanceContext.getInstrumentationProvider().qViewIndicate(this.factory, newData, oldDataUpdate);
            this.child.update(newData, oldDataUpdate);
            agentInstanceContext.getInstrumentationProvider().aViewIndicate();
        }
        agentInstanceContext.getInstrumentationProvider().aViewProcessIRStream();
    }

    @Override
    public final Iterator<EventBean> iterator() {
        return this.timeWindow.iterator();
    }

    @Override
    public void visitView(ViewDataVisitor viewDataVisitor) {
        this.timeWindow.visitView(viewDataVisitor, this.factory);
    }

    private long getLongValue(EventBean obj) {
        this.eventsPerStream[0] = obj;
        Number num = (Number)this.factory.timestampEval.evaluate(this.eventsPerStream, true, this.agentInstanceViewFactoryContext);
        return num.longValue();
    }

    public boolean isEmpty() {
        return this.timeWindow.isEmpty();
    }

    public ViewUpdatedCollection getViewUpdatedCollection() {
        return this.viewUpdatedCollection;
    }

    public ViewFactory getViewFactory() {
        return this.factory;
    }
}

