/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.view.filter;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.metrics.instrumentation.InstrumentationCommon;
import com.espertech.esper.common.internal.view.core.ViewSupport;
import com.espertech.esper.common.internal.view.filter.FilterExprViewIterator;
import java.util.Iterator;

public class FilterExprView
extends ViewSupport {
    private final ExprEvaluator exprEvaluator;
    private final ExprEvaluatorContext exprEvaluatorContext;
    private final String whereClauseEvaluatorTextForAudit;

    public FilterExprView(ExprEvaluator exprEvaluator, ExprEvaluatorContext exprEvaluatorContext, String whereClauseEvaluatorTextForAudit) {
        this.exprEvaluator = exprEvaluator;
        this.exprEvaluatorContext = exprEvaluatorContext;
        this.whereClauseEvaluatorTextForAudit = whereClauseEvaluatorTextForAudit;
    }

    @Override
    public EventType getEventType() {
        return this.parent.getEventType();
    }

    @Override
    public Iterator<EventBean> iterator() {
        return new FilterExprViewIterator(this.parent.iterator(), this.exprEvaluator, this.exprEvaluatorContext);
    }

    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
        InstrumentationCommon instrumentationCommon = this.exprEvaluatorContext.getInstrumentationProvider();
        instrumentationCommon.qWhereClauseFilter(this.whereClauseEvaluatorTextForAudit, newData, oldData);
        EventBean[] filteredNewData = this.filterEvents(this.exprEvaluator, newData, true, this.exprEvaluatorContext);
        EventBean[] filteredOldData = this.filterEvents(this.exprEvaluator, oldData, false, this.exprEvaluatorContext);
        instrumentationCommon.aWhereClauseFilter(filteredNewData, filteredOldData);
        if (filteredNewData != null || filteredOldData != null) {
            instrumentationCommon.qWhereClauseIR(filteredNewData, filteredOldData);
            this.child.update(filteredNewData, filteredOldData);
            instrumentationCommon.aWhereClauseIR();
        }
    }

    private EventBean[] filterEvents(ExprEvaluator exprEvaluator, EventBean[] events, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        if (events == null) {
            return null;
        }
        InstrumentationCommon instrumentationCommon = exprEvaluatorContext.getInstrumentationProvider();
        EventBean[] evalEventArr = new EventBean[1];
        boolean[] passResult = new boolean[events.length];
        int passCount = 0;
        for (int i = 0; i < events.length; ++i) {
            evalEventArr[0] = events[i];
            instrumentationCommon.qWhereClauseFilterEval(i, events[i], isNewData);
            Boolean pass = (Boolean)exprEvaluator.evaluate(evalEventArr, isNewData, exprEvaluatorContext);
            instrumentationCommon.aWhereClauseFilterEval(pass);
            if (pass == null || !pass.booleanValue()) continue;
            passResult[i] = true;
            ++passCount;
        }
        if (passCount == 0) {
            return null;
        }
        if (passCount == events.length) {
            return events;
        }
        EventBean[] resultArray = new EventBean[passCount];
        int count = 0;
        for (int i = 0; i < passResult.length; ++i) {
            if (!passResult[i]) continue;
            resultArray[count] = events[i];
            ++count;
        }
        return resultArray;
    }
}

