/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.view.groupwin;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.PropertyAccessException;
import com.espertech.esper.common.client.annotation.AppliesTo;
import com.espertech.esper.common.client.annotation.Hint;
import com.espertech.esper.common.client.annotation.HintEnum;
import com.espertech.esper.common.client.meta.EventTypeApplicationType;
import com.espertech.esper.common.client.meta.EventTypeIdPair;
import com.espertech.esper.common.client.meta.EventTypeMetadata;
import com.espertech.esper.common.client.meta.EventTypeTypeClass;
import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypeNull;
import com.espertech.esper.common.client.util.EventTypeBusModifier;
import com.espertech.esper.common.client.util.NameAccessModifier;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRef;
import com.espertech.esper.common.internal.compile.multikey.MultiKeyClassRef;
import com.espertech.esper.common.internal.compile.multikey.MultiKeyPlan;
import com.espertech.esper.common.internal.compile.multikey.MultiKeyPlanner;
import com.espertech.esper.common.internal.compile.stage3.StmtClassForgeableFactory;
import com.espertech.esper.common.internal.context.aifactory.core.SAIFFInitializeSymbol;
import com.espertech.esper.common.internal.context.module.EPStatementInitServices;
import com.espertech.esper.common.internal.epl.expression.core.ExprIdentNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityPrint;
import com.espertech.esper.common.internal.epl.expression.time.abacus.TimeAbacus;
import com.espertech.esper.common.internal.event.core.EventBeanTypedEventFactoryCompileTime;
import com.espertech.esper.common.internal.event.core.EventTypeUtility;
import com.espertech.esper.common.internal.event.core.WrapperEventType;
import com.espertech.esper.common.internal.event.core.WrapperEventTypeUtil;
import com.espertech.esper.common.internal.view.core.ViewFactoryForge;
import com.espertech.esper.common.internal.view.core.ViewFactoryForgeBase;
import com.espertech.esper.common.internal.view.core.ViewFactoryForgeUtil;
import com.espertech.esper.common.internal.view.core.ViewFactoryForgeVisitor;
import com.espertech.esper.common.internal.view.core.ViewForgeEnv;
import com.espertech.esper.common.internal.view.core.ViewForgeVisitor;
import com.espertech.esper.common.internal.view.core.ViewParameterException;
import com.espertech.esper.common.internal.view.groupwin.GroupByViewFactory;
import com.espertech.esper.common.internal.view.util.ViewForgeSupport;
import com.espertech.esper.common.internal.view.util.ViewMultiKeyHelper;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupByViewFactoryForge
extends ViewFactoryForgeBase {
    private static final Logger log = LoggerFactory.getLogger(GroupByViewFactoryForge.class);
    protected List<ExprNode> viewParameters;
    protected List<ViewFactoryForge> groupeds;
    protected ExprNode[] criteriaExpressions;
    protected String[] propertyNames;
    protected boolean addingProperties;
    protected boolean isReclaimAged;
    protected long reclaimMaxAge;
    protected long reclaimFrequency;
    protected MultiKeyClassRef multiKeyClassNames;

    @Override
    public void setViewParameters(List<ExprNode> parameters, ViewForgeEnv viewForgeEnv, int streamNumber) throws ViewParameterException {
        this.viewParameters = parameters;
        TimeAbacus timeAbacus = viewForgeEnv.getClasspathImportServiceCompileTime().getTimeAbacus();
        Hint reclaimGroupAged = HintEnum.RECLAIM_GROUP_AGED.getHint(viewForgeEnv.getAnnotations());
        if (reclaimGroupAged != null) {
            this.isReclaimAged = true;
            String hintValueMaxAge = HintEnum.RECLAIM_GROUP_AGED.getHintAssignedValue(reclaimGroupAged);
            if (hintValueMaxAge == null) {
                throw new ViewParameterException("Required hint value for hint '" + (Object)((Object)HintEnum.RECLAIM_GROUP_AGED) + "' has not been provided");
            }
            try {
                this.reclaimMaxAge = timeAbacus.deltaForSecondsDouble(Double.parseDouble(hintValueMaxAge));
            }
            catch (RuntimeException ex) {
                throw new ViewParameterException("Required hint value for hint '" + (Object)((Object)HintEnum.RECLAIM_GROUP_AGED) + "' value '" + hintValueMaxAge + "' could not be parsed as a double value");
            }
            String hintValueFrequency = HintEnum.RECLAIM_GROUP_FREQ.getHintAssignedValue(reclaimGroupAged);
            if (hintValueFrequency == null) {
                this.reclaimFrequency = this.reclaimMaxAge;
            } else {
                try {
                    this.reclaimFrequency = timeAbacus.deltaForSecondsDouble(Double.parseDouble(hintValueFrequency));
                }
                catch (RuntimeException ex) {
                    throw new ViewParameterException("Required hint value for hint '" + (Object)((Object)HintEnum.RECLAIM_GROUP_FREQ) + "' value '" + hintValueFrequency + "' could not be parsed as a double value");
                }
            }
            if (this.reclaimMaxAge < 1L) {
                log.warn("Reclaim max age parameter is less then 1, are your sure?");
            }
            if (log.isDebugEnabled()) {
                log.debug("Using reclaim-aged strategy for group-window age " + this.reclaimMaxAge + " frequency " + this.reclaimFrequency);
            }
        }
    }

    @Override
    public void attachValidate(EventType parentEventType, ViewForgeEnv viewForgeEnv) throws ViewParameterException {
        this.criteriaExpressions = ViewForgeSupport.validate(this.getViewName(), parentEventType, this.viewParameters, false, viewForgeEnv);
        if (this.criteriaExpressions.length == 0) {
            String errorMessage = this.getViewName() + " view requires a one or more expressions provinding unique values as parameters";
            throw new ViewParameterException(errorMessage);
        }
        this.propertyNames = new String[this.criteriaExpressions.length];
        for (int i = 0; i < this.criteriaExpressions.length; ++i) {
            this.propertyNames[i] = ExprNodeUtilityPrint.toExpressionStringMinPrecedenceSafe(this.criteriaExpressions[i]);
        }
        EventType groupedEventType = this.groupeds.get(this.groupeds.size() - 1).getEventType();
        this.eventType = GroupByViewFactoryForge.determineEventType(groupedEventType, this.criteriaExpressions, viewForgeEnv);
        if (this.eventType != groupedEventType) {
            this.addingProperties = true;
        }
    }

    @Override
    public List<StmtClassForgeableFactory> initAdditionalForgeables(ViewForgeEnv viewForgeEnv) {
        MultiKeyPlan desc = MultiKeyPlanner.planMultiKey(this.criteriaExpressions, false, viewForgeEnv.getStatementRawInfo(), viewForgeEnv.getSerdeResolver());
        this.multiKeyClassNames = desc.getClassRef();
        return desc.getMultiKeyForgeables();
    }

    @Override
    protected EPTypeClass typeOfFactory() {
        return GroupByViewFactory.EPTYPE;
    }

    @Override
    protected String factoryMethod() {
        return "group";
    }

    @Override
    protected void assign(CodegenMethod method, CodegenExpressionRef factory, SAIFFInitializeSymbol symbols, CodegenClassScope classScope) {
        if (this.groupeds == null) {
            throw new IllegalStateException("Empty grouped forges");
        }
        method.getBlock().exprDotMethod(factory, "setReclaimAged", CodegenExpressionBuilder.constant(this.isReclaimAged)).exprDotMethod(factory, "setReclaimMaxAge", CodegenExpressionBuilder.constant(this.reclaimMaxAge)).exprDotMethod(factory, "setReclaimFrequency", CodegenExpressionBuilder.constant(this.reclaimFrequency)).exprDotMethod(factory, "setPropertyNames", CodegenExpressionBuilder.constant(this.propertyNames)).exprDotMethod(factory, "setGroupeds", CodegenExpressionBuilder.localMethod(ViewFactoryForgeUtil.makeViewFactories(this.groupeds, this.getClass(), method, classScope, symbols), new CodegenExpression[0])).exprDotMethod(factory, "setEventType", EventTypeUtility.resolveTypeCodegen(this.eventType, EPStatementInitServices.REF)).exprDotMethod(factory, "setAddingProperties", CodegenExpressionBuilder.constant(this.addingProperties));
        ViewMultiKeyHelper.assign(this.criteriaExpressions, this.multiKeyClassNames, method, factory, symbols, classScope);
    }

    @Override
    public void accept(ViewForgeVisitor visitor) {
        visitor.visit(this);
        for (ViewFactoryForge forge : this.groupeds) {
            forge.accept(visitor);
        }
    }

    public List<ViewFactoryForge> getGroupeds() {
        return this.groupeds;
    }

    public void setGroupeds(List<ViewFactoryForge> groupeds) {
        this.groupeds = groupeds;
    }

    @Override
    public String getViewName() {
        return "Group-By";
    }

    public void setEventType(EventType eventType) {
        this.eventType = eventType;
    }

    public ExprNode[] getCriteriaExpressions() {
        return this.criteriaExpressions;
    }

    public List<ExprNode> getViewParameters() {
        return this.viewParameters;
    }

    @Override
    public List<ViewFactoryForge> getInnerForges() {
        return this.groupeds;
    }

    private static EventType determineEventType(EventType groupedEventType, ExprNode[] criteriaExpressions, ViewForgeEnv viewForgeEnv) throws ViewParameterException {
        EPTypeClass[] fieldTypes = new EPTypeClass[criteriaExpressions.length];
        for (int i = 0; i < fieldTypes.length; ++i) {
            EPType type = criteriaExpressions[i].getForge().getEvaluationType();
            if (type == null || type == EPTypeNull.INSTANCE) {
                throw new ViewParameterException("Group-window received a null-typed criteria expression");
            }
            fieldTypes[i] = (EPTypeClass)type;
        }
        boolean parentContainsMergeKeys = true;
        String[] fieldNames = new String[criteriaExpressions.length];
        for (int i = 0; i < criteriaExpressions.length; ++i) {
            String name;
            fieldNames[i] = name = ExprNodeUtilityPrint.toExpressionStringMinPrecedenceSafe(criteriaExpressions[i]);
            try {
                ExprIdentNode identNode;
                if (groupedEventType.isProperty(name) || !(criteriaExpressions[i] instanceof ExprIdentNode) || groupedEventType.isProperty((identNode = (ExprIdentNode)criteriaExpressions[i]).getUnresolvedPropertyName())) continue;
                parentContainsMergeKeys = false;
                continue;
            }
            catch (PropertyAccessException ex) {
                parentContainsMergeKeys = false;
            }
        }
        if (parentContainsMergeKeys) {
            return groupedEventType;
        }
        HashMap<String, Object> additionalProps = new HashMap<String, Object>();
        for (int i = 0; i < fieldNames.length; ++i) {
            additionalProps.put(fieldNames[i], fieldTypes[i]);
        }
        String outputEventTypeName = viewForgeEnv.getStatementCompileTimeServices().getEventTypeNameGeneratorStatement().getViewGroup(viewForgeEnv.getStreamNumber());
        EventTypeMetadata metadata = new EventTypeMetadata(outputEventTypeName, viewForgeEnv.getModuleName(), EventTypeTypeClass.VIEWDERIVED, EventTypeApplicationType.WRAPPER, NameAccessModifier.TRANSIENT, EventTypeBusModifier.NONBUS, false, EventTypeIdPair.unassigned());
        WrapperEventType eventType = WrapperEventTypeUtil.makeWrapper(metadata, groupedEventType, additionalProps, EventBeanTypedEventFactoryCompileTime.INSTANCE, viewForgeEnv.getBeanEventTypeFactoryProtected(), viewForgeEnv.getEventTypeCompileTimeResolver());
        viewForgeEnv.getEventTypeModuleCompileTimeRegistry().newType(eventType);
        return eventType;
    }

    @Override
    public AppliesTo appliesTo() {
        return AppliesTo.WINDOW_GROUP;
    }

    @Override
    public <T> T accept(ViewFactoryForgeVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public MultiKeyClassRef getMultiKeyClassNames() {
        return this.multiKeyClassNames;
    }
}

