/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.view.groupwin;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.collection.Pair;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.context.util.AgentInstanceMgmtCallback;
import com.espertech.esper.common.internal.context.util.AgentInstanceStopServices;
import com.espertech.esper.common.internal.event.core.EventBeanUtility;
import com.espertech.esper.common.internal.view.core.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.common.internal.view.core.View;
import com.espertech.esper.common.internal.view.core.ViewDataVisitorContained;
import com.espertech.esper.common.internal.view.core.ViewSupport;
import com.espertech.esper.common.internal.view.groupwin.GroupByView;
import com.espertech.esper.common.internal.view.groupwin.GroupByViewFactory;
import com.espertech.esper.common.internal.view.groupwin.GroupByViewUtil;
import com.espertech.esper.common.internal.view.groupwin.MergeView;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupByViewImpl
extends ViewSupport
implements GroupByView,
AgentInstanceMgmtCallback {
    private static final String VIEWNAME = "groupwin";
    private final GroupByViewFactory groupByViewFactory;
    private final MergeView mergeView;
    protected final AgentInstanceViewFactoryChainContext agentInstanceContext;
    private EventBean[] eventsPerStream = new EventBean[1];
    protected final Map<Object, View> subViewPerKey = new HashMap<Object, View>();
    private final HashMap<View, Pair<Object, Object>> groupedEvents = new HashMap();
    private static final Logger log = LoggerFactory.getLogger(GroupByViewImpl.class);

    public GroupByViewImpl(GroupByViewFactory groupByViewFactory, AgentInstanceViewFactoryChainContext agentInstanceContext) {
        this.groupByViewFactory = groupByViewFactory;
        this.agentInstanceContext = agentInstanceContext;
        this.mergeView = new MergeView(this, groupByViewFactory.eventType);
    }

    @Override
    public final EventType getEventType() {
        return this.parent.getEventType();
    }

    @Override
    public GroupByViewFactory getViewFactory() {
        return this.groupByViewFactory;
    }

    @Override
    public final void update(EventBean[] newData, EventBean[] oldData) {
        AgentInstanceContext aiContext = this.agentInstanceContext.getAgentInstanceContext();
        aiContext.getAuditProvider().view(newData, oldData, aiContext, this.groupByViewFactory);
        aiContext.getInstrumentationProvider().qViewProcessIRStream(this.groupByViewFactory, newData, oldData);
        if (newData != null && oldData == null && newData.length == 1) {
            EventBean theEvent = newData[0];
            EventBean[] eventBeanArray = new EventBean[]{theEvent};
            Object groupByValuesKey = this.getGroupKey(theEvent);
            View subView = this.subViewPerKey.get(groupByValuesKey);
            if (subView == null) {
                subView = GroupByViewUtil.makeSubView(this, groupByValuesKey);
                this.subViewPerKey.put(groupByValuesKey, subView);
            }
            this.agentInstanceContext.getInstrumentationProvider().qViewIndicate(this.groupByViewFactory, eventBeanArray, null);
            subView.update(eventBeanArray, null);
            this.agentInstanceContext.getInstrumentationProvider().aViewIndicate();
        } else {
            if (newData != null) {
                for (EventBean newValue : newData) {
                    this.handleEvent(newValue, true);
                }
            }
            if (oldData != null) {
                for (EventBean oldValue : oldData) {
                    this.handleEvent(oldValue, false);
                }
            }
            for (Map.Entry entry : this.groupedEvents.entrySet()) {
                EventBean[] newEvents = GroupByViewImpl.convertToArray(((Pair)entry.getValue()).getFirst());
                EventBean[] oldEvents = GroupByViewImpl.convertToArray(((Pair)entry.getValue()).getSecond());
                this.agentInstanceContext.getInstrumentationProvider().qViewIndicate(this.groupByViewFactory, newEvents, oldEvents);
                ((View)entry.getKey()).update(newEvents, oldEvents);
                this.agentInstanceContext.getInstrumentationProvider().aViewIndicate();
            }
            this.groupedEvents.clear();
        }
        this.agentInstanceContext.getInstrumentationProvider().aViewProcessIRStream();
    }

    @Override
    public final Iterator<EventBean> iterator() {
        return this.mergeView.iterator();
    }

    public final String toString() {
        return this.getClass().getName() + " groupFieldNames=" + Arrays.toString(this.groupByViewFactory.getPropertyNames());
    }

    @Override
    public void visitViewContainer(ViewDataVisitorContained viewDataVisitor) {
        viewDataVisitor.visitPrimary(VIEWNAME, this.subViewPerKey.size());
        for (Map.Entry<Object, View> entry : this.subViewPerKey.entrySet()) {
            GroupByViewImpl.visitView(viewDataVisitor, entry.getKey(), entry.getValue());
        }
    }

    public static void visitView(ViewDataVisitorContained viewDataVisitor, Object groupkey, View view) {
        if (view == null) {
            return;
        }
        viewDataVisitor.visitContained(groupkey, view);
    }

    @Override
    public MergeView getMergeView() {
        return this.mergeView;
    }

    @Override
    public AgentInstanceViewFactoryChainContext getAgentInstanceContext() {
        return this.agentInstanceContext;
    }

    @Override
    public void stop(AgentInstanceStopServices services) {
        for (Map.Entry<Object, View> entry : this.subViewPerKey.entrySet()) {
            GroupByViewUtil.removeSubview(entry.getValue(), services);
        }
    }

    private void handleEvent(EventBean theEvent, boolean isNew) {
        Pair<Object, Object> pair;
        Object groupByValuesKey = this.getGroupKey(theEvent);
        View subView = this.subViewPerKey.get(groupByValuesKey);
        if (subView == null) {
            subView = GroupByViewUtil.makeSubView(this, groupByValuesKey);
            this.subViewPerKey.put(groupByValuesKey, subView);
        }
        if ((pair = this.groupedEvents.get(subView)) == null) {
            pair = new Pair<Object, Object>(null, null);
            this.groupedEvents.put(subView, pair);
        }
        if (isNew) {
            pair.setFirst(GroupByViewImpl.addUpgradeToDequeIfPopulated(pair.getFirst(), theEvent));
        } else {
            pair.setSecond(GroupByViewImpl.addUpgradeToDequeIfPopulated(pair.getSecond(), theEvent));
        }
    }

    private Object getGroupKey(EventBean theEvent) {
        this.eventsPerStream[0] = theEvent;
        return this.groupByViewFactory.getCriteriaEval().evaluate(this.eventsPerStream, true, this.agentInstanceContext);
    }

    protected static Object addUpgradeToDequeIfPopulated(Object holder, EventBean theEvent) {
        if (holder == null) {
            return theEvent;
        }
        if (holder instanceof Deque) {
            Deque deque = (Deque)holder;
            deque.add(theEvent);
            return deque;
        }
        ArrayDeque<EventBean> deque = new ArrayDeque<EventBean>(4);
        deque.add((EventBean)holder);
        deque.add(theEvent);
        return deque;
    }

    protected static EventBean[] convertToArray(Object eventOrDeque) {
        if (eventOrDeque == null) {
            return null;
        }
        if (eventOrDeque instanceof EventBean) {
            return new EventBean[]{(EventBean)eventOrDeque};
        }
        return EventBeanUtility.toArray((ArrayDeque)eventOrDeque);
    }
}

