/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.view.keepall;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.collection.ViewUpdatedCollection;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.view.core.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.common.internal.view.core.DataWindowView;
import com.espertech.esper.common.internal.view.core.ViewDataVisitor;
import com.espertech.esper.common.internal.view.core.ViewFactory;
import com.espertech.esper.common.internal.view.core.ViewSupport;
import com.espertech.esper.common.internal.view.keepall.KeepAllViewFactory;
import java.util.Iterator;
import java.util.LinkedHashSet;

public class KeepAllView
extends ViewSupport
implements DataWindowView {
    protected final AgentInstanceContext agentInstanceContext;
    private final KeepAllViewFactory keepAllViewFactory;
    protected LinkedHashSet<EventBean> indexedEvents;
    protected ViewUpdatedCollection viewUpdatedCollection;

    public KeepAllView(AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext, KeepAllViewFactory keepAllViewFactory, ViewUpdatedCollection viewUpdatedCollection) {
        this.agentInstanceContext = agentInstanceViewFactoryContext.getAgentInstanceContext();
        this.keepAllViewFactory = keepAllViewFactory;
        this.indexedEvents = new LinkedHashSet();
        this.viewUpdatedCollection = viewUpdatedCollection;
    }

    public ViewFactory getViewFactory() {
        return this.keepAllViewFactory;
    }

    public boolean isEmpty() {
        return this.indexedEvents.isEmpty();
    }

    public ViewUpdatedCollection getViewUpdatedCollection() {
        return this.viewUpdatedCollection;
    }

    @Override
    public final EventType getEventType() {
        return this.parent.getEventType();
    }

    @Override
    public final void update(EventBean[] newData, EventBean[] oldData) {
        this.agentInstanceContext.getAuditProvider().view(newData, oldData, this.agentInstanceContext, this.keepAllViewFactory);
        this.agentInstanceContext.getInstrumentationProvider().qViewProcessIRStream(this.keepAllViewFactory, newData, oldData);
        if (newData != null) {
            for (EventBean newEvent : newData) {
                this.indexedEvents.add(newEvent);
                this.internalHandleAdded(newEvent);
            }
        }
        if (oldData != null) {
            for (EventBean anOldData : oldData) {
                this.indexedEvents.remove(anOldData);
                this.internalHandleRemoved(anOldData);
            }
        }
        if (this.viewUpdatedCollection != null) {
            this.viewUpdatedCollection.update(newData, oldData);
        }
        this.agentInstanceContext.getInstrumentationProvider().qViewIndicate(this.keepAllViewFactory, newData, oldData);
        this.child.update(newData, oldData);
        this.agentInstanceContext.getInstrumentationProvider().aViewIndicate();
        this.agentInstanceContext.getInstrumentationProvider().aViewProcessIRStream();
    }

    @Override
    public final Iterator<EventBean> iterator() {
        return this.indexedEvents.iterator();
    }

    public void internalHandleAdded(EventBean newEvent) {
    }

    public void internalHandleRemoved(EventBean oldEvent) {
    }

    @Override
    public void visitView(ViewDataVisitor viewDataVisitor) {
        viewDataVisitor.visitPrimary(this.indexedEvents, true, this.keepAllViewFactory.getViewName(), null);
    }

    public LinkedHashSet<EventBean> getIndexedEvents() {
        return this.indexedEvents;
    }
}

