/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.view.lengthbatch;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.collection.ViewUpdatedCollection;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.view.core.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.common.internal.view.core.DataWindowView;
import com.espertech.esper.common.internal.view.core.ViewDataVisitor;
import com.espertech.esper.common.internal.view.core.ViewFactory;
import com.espertech.esper.common.internal.view.core.ViewSupport;
import com.espertech.esper.common.internal.view.lengthbatch.LengthBatchViewFactory;
import java.util.ArrayDeque;
import java.util.Iterator;

public class LengthBatchView
extends ViewSupport
implements DataWindowView {
    protected final AgentInstanceContext agentInstanceContext;
    private final LengthBatchViewFactory lengthBatchViewFactory;
    private final int size;
    private final ViewUpdatedCollection viewUpdatedCollection;
    protected ArrayDeque<EventBean> lastBatch = null;
    protected ArrayDeque<EventBean> currentBatch = new ArrayDeque();

    public LengthBatchView(AgentInstanceViewFactoryChainContext agentInstanceContext, LengthBatchViewFactory lengthBatchViewFactory, int size, ViewUpdatedCollection viewUpdatedCollection) {
        this.agentInstanceContext = agentInstanceContext.getAgentInstanceContext();
        this.lengthBatchViewFactory = lengthBatchViewFactory;
        this.size = size;
        this.viewUpdatedCollection = viewUpdatedCollection;
        if (size <= 0) {
            throw new IllegalArgumentException("Invalid size parameter, size=" + size);
        }
    }

    public final int getSize() {
        return this.size;
    }

    @Override
    public final EventType getEventType() {
        return this.parent.getEventType();
    }

    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
        this.agentInstanceContext.getAuditProvider().view(newData, oldData, this.agentInstanceContext, this.lengthBatchViewFactory);
        this.agentInstanceContext.getInstrumentationProvider().qViewProcessIRStream(this.lengthBatchViewFactory, newData, oldData);
        if (newData == null || newData.length == 0) {
            return;
        }
        for (EventBean newEvent : newData) {
            this.currentBatch.add(newEvent);
        }
        if (this.currentBatch.size() < this.size) {
            return;
        }
        this.sendBatch();
        this.agentInstanceContext.getInstrumentationProvider().aViewProcessIRStream();
    }

    protected void sendBatch() {
        if (this.child != null) {
            EventBean[] newData = null;
            EventBean[] oldData = null;
            if (!this.currentBatch.isEmpty()) {
                newData = this.currentBatch.toArray(new EventBean[this.currentBatch.size()]);
            }
            if (this.lastBatch != null && !this.lastBatch.isEmpty()) {
                oldData = this.lastBatch.toArray(new EventBean[this.lastBatch.size()]);
            }
            if (this.viewUpdatedCollection != null) {
                this.viewUpdatedCollection.update(newData, oldData);
            }
            if (newData != null || oldData != null) {
                this.agentInstanceContext.getInstrumentationProvider().qViewIndicate(this.lengthBatchViewFactory, newData, oldData);
                this.child.update(newData, oldData);
                this.agentInstanceContext.getInstrumentationProvider().aViewIndicate();
            }
        }
        this.lastBatch = this.currentBatch;
        this.currentBatch = new ArrayDeque();
    }

    public boolean isEmpty() {
        if (this.lastBatch != null && !this.lastBatch.isEmpty()) {
            return false;
        }
        return this.currentBatch.isEmpty();
    }

    @Override
    public final Iterator<EventBean> iterator() {
        return this.currentBatch.iterator();
    }

    public final String toString() {
        return this.getClass().getName() + " size=" + this.size;
    }

    @Override
    public void visitView(ViewDataVisitor viewDataVisitor) {
        viewDataVisitor.visitPrimary(this.currentBatch, true, this.lengthBatchViewFactory.getViewName(), null);
        viewDataVisitor.visitPrimary(this.lastBatch, true, this.lengthBatchViewFactory.getViewName(), null);
    }

    public ViewFactory getViewFactory() {
        return this.lengthBatchViewFactory;
    }
}

