/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.view.sort;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.serde.DataInputOutputSerde;
import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.context.module.EPStatementInitServices;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityMake;
import com.espertech.esper.common.internal.view.access.RandomAccessByIndexGetter;
import com.espertech.esper.common.internal.view.core.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.common.internal.view.core.DataWindowViewFactory;
import com.espertech.esper.common.internal.view.core.DataWindowViewWithPrevious;
import com.espertech.esper.common.internal.view.core.View;
import com.espertech.esper.common.internal.view.core.ViewEnum;
import com.espertech.esper.common.internal.view.core.ViewFactoryContext;
import com.espertech.esper.common.internal.view.core.ViewFactoryUtil;
import com.espertech.esper.common.internal.view.previous.IStreamSortRankRandomAccess;
import com.espertech.esper.common.internal.view.previous.PreviousGetterStrategy;
import com.espertech.esper.common.internal.view.sort.SortWindowView;
import java.util.Comparator;

public class SortWindowViewFactory
implements DataWindowViewFactory,
DataWindowViewWithPrevious {
    public static final EPTypeClass EPTYPE = new EPTypeClass(SortWindowViewFactory.class);
    protected ExprEvaluator[] sortCriteriaEvaluators;
    protected EPType[] sortCriteriaTypes;
    protected DataInputOutputSerde[] sortSerdes;
    protected boolean[] isDescendingValues;
    protected ExprEvaluator size;
    protected boolean useCollatorSort;
    protected Comparator<Object> comparator;
    protected EventType eventType;

    @Override
    public void setEventType(EventType eventType) {
        this.eventType = eventType;
    }

    @Override
    public void init(ViewFactoryContext viewFactoryContext, EPStatementInitServices services) {
        this.comparator = ExprNodeUtilityMake.getComparatorHashableMultiKeys(this.sortCriteriaTypes, this.useCollatorSort, this.isDescendingValues);
    }

    @Override
    public View makeView(AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext) {
        int sortWindowSize = ViewFactoryUtil.evaluateSizeParam(this.getViewName(), this.size, agentInstanceViewFactoryContext.getAgentInstanceContext());
        IStreamSortRankRandomAccess sortedRandomAccess = agentInstanceViewFactoryContext.getStatementContext().getViewServicePreviousFactory().getOptPreviousExprSortedRankedAccess(agentInstanceViewFactoryContext);
        return new SortWindowView(this, sortWindowSize, sortedRandomAccess, agentInstanceViewFactoryContext);
    }

    @Override
    public PreviousGetterStrategy makePreviousGetter() {
        return new RandomAccessByIndexGetter();
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    public ExprEvaluator[] getSortCriteriaEvaluators() {
        return this.sortCriteriaEvaluators;
    }

    public ExprEvaluator getSize() {
        return this.size;
    }

    public Comparator<Object> getComparator() {
        return this.comparator;
    }

    public boolean[] getIsDescendingValues() {
        return this.isDescendingValues;
    }

    public boolean isUseCollatorSort() {
        return this.useCollatorSort;
    }

    private boolean compare(boolean[] one, boolean[] two) {
        if (one.length != two.length) {
            return false;
        }
        for (int i = 0; i < one.length; ++i) {
            if (one[i] == two[i]) continue;
            return false;
        }
        return true;
    }

    public void setSortCriteriaEvaluators(ExprEvaluator[] sortCriteriaEvaluators) {
        this.sortCriteriaEvaluators = sortCriteriaEvaluators;
    }

    public void setSortCriteriaTypes(EPType[] sortCriteriaTypes) {
        this.sortCriteriaTypes = sortCriteriaTypes;
    }

    public void setIsDescendingValues(boolean[] isDescendingValues) {
        this.isDescendingValues = isDescendingValues;
    }

    public void setSize(ExprEvaluator size) {
        this.size = size;
    }

    public void setUseCollatorSort(boolean useCollatorSort) {
        this.useCollatorSort = useCollatorSort;
    }

    public void setSortSerdes(DataInputOutputSerde[] sortSerdes) {
        this.sortSerdes = sortSerdes;
    }

    @Override
    public String getViewName() {
        return ViewEnum.SORT_WINDOW.getName();
    }
}

