/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.view.timebatch;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.context.util.AgentInstanceMgmtCallback;
import com.espertech.esper.common.internal.context.util.AgentInstanceStopServices;
import com.espertech.esper.common.internal.context.util.EPStatementHandleCallbackSchedule;
import com.espertech.esper.common.internal.epl.expression.time.eval.TimePeriodDeltaResult;
import com.espertech.esper.common.internal.epl.expression.time.eval.TimePeriodProvide;
import com.espertech.esper.common.internal.schedule.ScheduleHandleCallback;
import com.espertech.esper.common.internal.schedule.ScheduleObjectType;
import com.espertech.esper.common.internal.view.core.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.common.internal.view.core.DataWindowView;
import com.espertech.esper.common.internal.view.core.ViewDataVisitor;
import com.espertech.esper.common.internal.view.core.ViewFactory;
import com.espertech.esper.common.internal.view.core.ViewSupport;
import com.espertech.esper.common.internal.view.timebatch.TimeBatchViewFactory;
import java.util.Iterator;
import java.util.LinkedHashSet;

public class TimeBatchViewRStream
extends ViewSupport
implements AgentInstanceMgmtCallback,
DataWindowView {
    private final TimeBatchViewFactory factory;
    private final AgentInstanceContext agentInstanceContext;
    private EPStatementHandleCallbackSchedule handle;
    private final long scheduleSlot;
    private final TimePeriodProvide timePeriodProvide;
    private Long currentReferencePoint;
    private LinkedHashSet<EventBean> lastBatch = null;
    private LinkedHashSet<EventBean> currentBatch = new LinkedHashSet();
    private boolean isCallbackScheduled;

    public TimeBatchViewRStream(TimeBatchViewFactory factory, AgentInstanceViewFactoryChainContext agentInstanceContext, TimePeriodProvide timePeriodProvide) {
        this.agentInstanceContext = agentInstanceContext.getAgentInstanceContext();
        this.factory = factory;
        this.scheduleSlot = agentInstanceContext.getStatementContext().getScheduleBucket().allocateSlot();
        this.timePeriodProvide = timePeriodProvide;
        if (factory.isStartEager) {
            this.currentReferencePoint = agentInstanceContext.getStatementContext().getSchedulingService().getTime();
            this.scheduleCallback();
            this.isCallbackScheduled = true;
        }
    }

    @Override
    public final EventType getEventType() {
        return this.parent.getEventType();
    }

    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
        this.agentInstanceContext.getAuditProvider().view(newData, oldData, this.agentInstanceContext, this.factory);
        this.agentInstanceContext.getInstrumentationProvider().qViewProcessIRStream(this.factory, newData, oldData);
        if (oldData != null) {
            for (int i = 0; i < oldData.length; ++i) {
                this.currentBatch.remove(oldData[i]);
            }
        }
        if (newData == null || newData.length == 0) {
            this.agentInstanceContext.getInstrumentationProvider().aViewProcessIRStream();
            return;
        }
        if (this.currentBatch.isEmpty()) {
            if (this.currentReferencePoint == null) {
                this.currentReferencePoint = this.factory.optionalReferencePoint;
                if (this.currentReferencePoint == null) {
                    this.currentReferencePoint = this.agentInstanceContext.getStatementContext().getSchedulingService().getTime();
                }
            }
            if (!this.isCallbackScheduled) {
                this.scheduleCallback();
                this.isCallbackScheduled = true;
            }
        }
        for (EventBean newEvent : newData) {
            this.currentBatch.add(newEvent);
        }
        this.agentInstanceContext.getInstrumentationProvider().aViewProcessIRStream();
    }

    protected void sendBatch() {
        this.isCallbackScheduled = false;
        if (this.child != null) {
            EventBean[] newData = null;
            EventBean[] oldData = null;
            if (!this.currentBatch.isEmpty()) {
                newData = this.currentBatch.toArray(new EventBean[this.currentBatch.size()]);
            }
            if (this.lastBatch != null && !this.lastBatch.isEmpty()) {
                oldData = this.lastBatch.toArray(new EventBean[this.lastBatch.size()]);
            }
            if (newData != null || oldData != null || this.factory.isForceUpdate) {
                this.agentInstanceContext.getInstrumentationProvider().qViewIndicate(this.factory, newData, oldData);
                this.child.update(newData, oldData);
                this.agentInstanceContext.getInstrumentationProvider().aViewIndicate();
            }
        }
        if (!this.currentBatch.isEmpty() || this.lastBatch != null && !this.lastBatch.isEmpty() || this.factory.isForceUpdate) {
            this.scheduleCallback();
            this.isCallbackScheduled = true;
        }
        this.lastBatch = this.currentBatch;
        this.currentBatch = new LinkedHashSet();
    }

    public boolean isEmpty() {
        if (this.lastBatch != null && !this.lastBatch.isEmpty()) {
            return false;
        }
        return this.currentBatch.isEmpty();
    }

    @Override
    public final Iterator<EventBean> iterator() {
        return this.currentBatch.iterator();
    }

    public final String toString() {
        return this.getClass().getName() + " initialReferencePoint=" + this.factory.optionalReferencePoint;
    }

    protected void scheduleCallback() {
        long current = this.agentInstanceContext.getStatementContext().getSchedulingService().getTime();
        TimePeriodDeltaResult deltaWReference = this.timePeriodProvide.deltaAddWReference(current, this.currentReferencePoint, null, true, this.agentInstanceContext);
        long afterTime = deltaWReference.getDelta();
        this.currentReferencePoint = deltaWReference.getLastReference();
        ScheduleHandleCallback callback = new ScheduleHandleCallback(){

            @Override
            public void scheduledTrigger() {
                TimeBatchViewRStream.this.agentInstanceContext.getAuditProvider().scheduleFire(TimeBatchViewRStream.this.agentInstanceContext, ScheduleObjectType.view, TimeBatchViewRStream.this.factory.getViewName());
                TimeBatchViewRStream.this.agentInstanceContext.getInstrumentationProvider().qViewScheduledEval(TimeBatchViewRStream.this.factory);
                TimeBatchViewRStream.this.sendBatch();
                TimeBatchViewRStream.this.agentInstanceContext.getInstrumentationProvider().aViewScheduledEval();
            }
        };
        this.handle = new EPStatementHandleCallbackSchedule(this.agentInstanceContext.getEpStatementAgentInstanceHandle(), callback);
        this.agentInstanceContext.getAuditProvider().scheduleAdd(afterTime, this.agentInstanceContext, this.handle, ScheduleObjectType.view, this.factory.getViewName());
        this.agentInstanceContext.getStatementContext().getSchedulingService().add(afterTime, this.handle, this.scheduleSlot);
    }

    @Override
    public void stop(AgentInstanceStopServices services) {
        if (this.handle != null) {
            this.agentInstanceContext.getAuditProvider().scheduleRemove(this.agentInstanceContext, this.handle, ScheduleObjectType.view, this.factory.getViewName());
            this.agentInstanceContext.getStatementContext().getSchedulingService().remove(this.handle, this.scheduleSlot);
        }
    }

    @Override
    public void visitView(ViewDataVisitor viewDataVisitor) {
        viewDataVisitor.visitPrimary(this.currentBatch, true, this.factory.getViewName(), null);
        viewDataVisitor.visitPrimary(this.lastBatch, true, this.factory.getViewName(), null);
    }

    public ViewFactory getViewFactory() {
        return this.factory;
    }
}

