/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.view.timewin;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.collection.TimeWindow;
import com.espertech.esper.common.internal.collection.ViewUpdatedCollection;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.context.util.AgentInstanceMgmtCallback;
import com.espertech.esper.common.internal.context.util.AgentInstanceStopServices;
import com.espertech.esper.common.internal.context.util.AgentInstanceTransferServices;
import com.espertech.esper.common.internal.context.util.EPStatementHandleCallbackSchedule;
import com.espertech.esper.common.internal.epl.expression.time.eval.TimePeriodProvide;
import com.espertech.esper.common.internal.schedule.ScheduleHandleCallback;
import com.espertech.esper.common.internal.schedule.ScheduleObjectType;
import com.espertech.esper.common.internal.view.core.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.common.internal.view.core.DataWindowView;
import com.espertech.esper.common.internal.view.core.ViewDataVisitor;
import com.espertech.esper.common.internal.view.core.ViewFactory;
import com.espertech.esper.common.internal.view.core.ViewSupport;
import com.espertech.esper.common.internal.view.timewin.TimeWindowViewFactory;
import java.util.ArrayDeque;
import java.util.Iterator;

public class TimeWindowView
extends ViewSupport
implements DataWindowView,
AgentInstanceMgmtCallback {
    private final TimeWindowViewFactory timeWindowViewFactory;
    private final TimeWindow timeWindow;
    private final ViewUpdatedCollection viewUpdatedCollection;
    private final AgentInstanceContext agentInstanceContext;
    private final EPStatementHandleCallbackSchedule handle;
    private final long scheduleSlot;
    private final TimePeriodProvide timePeriodProvide;

    public TimeWindowView(final AgentInstanceViewFactoryChainContext agentInstanceContext, final TimeWindowViewFactory timeWindowViewFactory, ViewUpdatedCollection viewUpdatedCollection, TimePeriodProvide timePeriodProvide) {
        this.agentInstanceContext = agentInstanceContext.getAgentInstanceContext();
        this.timeWindowViewFactory = timeWindowViewFactory;
        this.viewUpdatedCollection = viewUpdatedCollection;
        this.timeWindow = new TimeWindow(agentInstanceContext.isRemoveStream());
        this.scheduleSlot = agentInstanceContext.getStatementContext().getScheduleBucket().allocateSlot();
        this.timePeriodProvide = timePeriodProvide;
        ScheduleHandleCallback callback = new ScheduleHandleCallback(){

            @Override
            public void scheduledTrigger() {
                agentInstanceContext.getAuditProvider().scheduleFire(TimeWindowView.this.agentInstanceContext, ScheduleObjectType.view, timeWindowViewFactory.getViewName());
                agentInstanceContext.getInstrumentationProvider().qViewScheduledEval(timeWindowViewFactory);
                TimeWindowView.this.expire();
                agentInstanceContext.getInstrumentationProvider().aViewScheduledEval();
            }
        };
        this.handle = new EPStatementHandleCallbackSchedule(agentInstanceContext.getEpStatementAgentInstanceHandle(), callback);
    }

    public ViewUpdatedCollection getViewUpdatedCollection() {
        return this.viewUpdatedCollection;
    }

    @Override
    public final EventType getEventType() {
        return this.parent.getEventType();
    }

    @Override
    public final void update(EventBean[] newData, EventBean[] oldData) {
        int i;
        this.agentInstanceContext.getAuditProvider().view(newData, oldData, this.agentInstanceContext, this.timeWindowViewFactory);
        this.agentInstanceContext.getInstrumentationProvider().qViewProcessIRStream(this.timeWindowViewFactory, newData, oldData);
        long timestamp = this.agentInstanceContext.getStatementContext().getSchedulingService().getTime();
        if (oldData != null) {
            for (i = 0; i < oldData.length; ++i) {
                this.timeWindow.remove(oldData[i]);
            }
        }
        if (newData != null && newData.length > 0) {
            if (this.timeWindow.isEmpty()) {
                long current = this.agentInstanceContext.getStatementContext().getSchedulingService().getTime();
                this.scheduleCallback(this.timePeriodProvide.deltaAdd(current, null, true, this.agentInstanceContext));
            }
            for (i = 0; i < newData.length; ++i) {
                this.timeWindow.add(timestamp, newData[i]);
            }
            if (this.viewUpdatedCollection != null) {
                this.viewUpdatedCollection.update(newData, null);
            }
        }
        this.agentInstanceContext.getInstrumentationProvider().qViewIndicate(this.timeWindowViewFactory, newData, oldData);
        this.child.update(newData, oldData);
        this.agentInstanceContext.getInstrumentationProvider().aViewIndicate();
        this.agentInstanceContext.getInstrumentationProvider().aViewProcessIRStream();
    }

    private final void expire() {
        long current = this.agentInstanceContext.getStatementContext().getSchedulingService().getTime();
        long expireBeforeTimestamp = current - this.timePeriodProvide.deltaSubtract(current, null, true, this.agentInstanceContext) + 1L;
        ArrayDeque<EventBean> expired = this.timeWindow.expireEvents(expireBeforeTimestamp);
        if (this.getChild() != null && expired != null && !expired.isEmpty()) {
            EventBean[] oldEvents = expired.toArray(new EventBean[expired.size()]);
            if (this.viewUpdatedCollection != null) {
                this.viewUpdatedCollection.update(null, oldEvents);
            }
            this.agentInstanceContext.getInstrumentationProvider().qViewIndicate(this.timeWindowViewFactory, null, oldEvents);
            this.getChild().update(null, oldEvents);
            this.agentInstanceContext.getInstrumentationProvider().aViewIndicate();
        }
        this.scheduleExpiryCallback();
    }

    private void scheduleExpiryCallback() {
        long scheduleTime = this.computeScheduleTime();
        if (scheduleTime == -1L) {
            return;
        }
        this.scheduleCallback(scheduleTime);
    }

    private long computeScheduleTime() {
        if (this.timeWindow.isEmpty()) {
            return -1L;
        }
        Long oldestTimestamp = this.timeWindow.getOldestTimestamp();
        long currentTimestamp = this.agentInstanceContext.getStatementContext().getSchedulingService().getTime();
        return this.timePeriodProvide.deltaAdd(oldestTimestamp, null, true, this.agentInstanceContext) + oldestTimestamp - currentTimestamp;
    }

    private void scheduleCallback(long timeAfterCurrentTime) {
        this.agentInstanceContext.getAuditProvider().scheduleAdd(timeAfterCurrentTime, this.agentInstanceContext, this.handle, ScheduleObjectType.view, this.timeWindowViewFactory.getViewName());
        this.agentInstanceContext.getStatementContext().getSchedulingService().add(timeAfterCurrentTime, this.handle, this.scheduleSlot);
    }

    @Override
    public final Iterator<EventBean> iterator() {
        return this.timeWindow.iterator();
    }

    public final String toString() {
        return this.getClass().getName();
    }

    public boolean isEmpty() {
        return this.timeWindow.isEmpty();
    }

    @Override
    public void stop(AgentInstanceStopServices services) {
        if (this.handle != null) {
            this.agentInstanceContext.getAuditProvider().scheduleRemove(this.agentInstanceContext, this.handle, ScheduleObjectType.view, this.timeWindowViewFactory.getViewName());
            this.agentInstanceContext.getStatementContext().getSchedulingService().remove(this.handle, this.scheduleSlot);
        }
    }

    @Override
    public void transfer(AgentInstanceTransferServices services) {
    }

    @Override
    public void visitView(ViewDataVisitor viewDataVisitor) {
        this.timeWindow.visitView(viewDataVisitor, this.timeWindowViewFactory);
    }

    public ViewFactory getViewFactory() {
        return this.timeWindowViewFactory;
    }
}

