/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.view.timewin;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.annotation.AppliesTo;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRef;
import com.espertech.esper.common.internal.context.aifactory.core.SAIFFInitializeSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.time.eval.TimePeriodCompute;
import com.espertech.esper.common.internal.epl.expression.time.eval.TimePeriodComputeForge;
import com.espertech.esper.common.internal.schedule.ScheduleHandleCallbackProvider;
import com.espertech.esper.common.internal.view.core.DataWindowViewForge;
import com.espertech.esper.common.internal.view.core.DataWindowViewForgeWithPrevious;
import com.espertech.esper.common.internal.view.core.ViewFactoryForgeBase;
import com.espertech.esper.common.internal.view.core.ViewFactoryForgeVisitor;
import com.espertech.esper.common.internal.view.core.ViewForgeEnv;
import com.espertech.esper.common.internal.view.core.ViewParameterException;
import com.espertech.esper.common.internal.view.timewin.TimeWindowViewFactory;
import com.espertech.esper.common.internal.view.util.ViewFactoryTimePeriodHelper;
import java.util.List;

public class TimeWindowViewForge
extends ViewFactoryForgeBase
implements DataWindowViewForge,
DataWindowViewForgeWithPrevious,
ScheduleHandleCallbackProvider {
    protected TimePeriodComputeForge timePeriodComputeForge;
    private int scheduleCallbackId = -1;

    @Override
    public void setViewParameters(List<ExprNode> parameters, ViewForgeEnv viewForgeEnv, int streamNumber) throws ViewParameterException {
        if (parameters.size() != 1) {
            throw new ViewParameterException(this.getViewParamMessage());
        }
        this.timePeriodComputeForge = ViewFactoryTimePeriodHelper.validateAndEvaluateTimeDeltaFactory(this.getViewName(), parameters.get(0), this.getViewParamMessage(), 0, viewForgeEnv);
    }

    @Override
    protected void attachValidate(EventType parentEventType, ViewForgeEnv viewForgeEnv) throws ViewParameterException {
        this.eventType = parentEventType;
    }

    @Override
    protected EPTypeClass typeOfFactory() {
        return TimeWindowViewFactory.EPTYPE;
    }

    @Override
    protected String factoryMethod() {
        return "time";
    }

    @Override
    protected void assign(CodegenMethod method, CodegenExpressionRef factory, SAIFFInitializeSymbol symbols, CodegenClassScope classScope) {
        if (this.scheduleCallbackId == -1) {
            throw new IllegalStateException("No schedule callback id");
        }
        method.getBlock().declareVar(TimePeriodCompute.EPTYPE, "eval", this.timePeriodComputeForge.makeEvaluator(method, classScope)).exprDotMethod(factory, "setTimePeriodCompute", CodegenExpressionBuilder.ref("eval")).exprDotMethod(factory, "setScheduleCallbackId", CodegenExpressionBuilder.constant(this.scheduleCallbackId));
    }

    @Override
    public String getViewName() {
        return "Time";
    }

    @Override
    public void setScheduleCallbackId(int id) {
        this.scheduleCallbackId = id;
    }

    @Override
    public int getScheduleCallbackId() {
        return this.scheduleCallbackId;
    }

    private String getViewParamMessage() {
        return this.getViewName() + " view requires a single numeric or time period parameter";
    }

    @Override
    public AppliesTo appliesTo() {
        return AppliesTo.WINDOW_TIME;
    }

    @Override
    public <T> T accept(ViewFactoryForgeVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

