/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.view.unique;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.collection.OneEventCollection;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.view.core.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.common.internal.view.core.DataWindowView;
import com.espertech.esper.common.internal.view.core.ViewDataVisitor;
import com.espertech.esper.common.internal.view.core.ViewFactory;
import com.espertech.esper.common.internal.view.core.ViewSupport;
import com.espertech.esper.common.internal.view.unique.UniqueByPropertyViewFactory;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class UniqueByPropertyView
extends ViewSupport
implements DataWindowView {
    private final UniqueByPropertyViewFactory viewFactory;
    protected final Map<Object, EventBean> mostRecentEvents = new HashMap<Object, EventBean>();
    private final EventBean[] eventsPerStream = new EventBean[1];
    protected final AgentInstanceContext agentInstanceContext;

    public UniqueByPropertyView(UniqueByPropertyViewFactory viewFactory, AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext) {
        this.viewFactory = viewFactory;
        this.agentInstanceContext = agentInstanceViewFactoryContext.getAgentInstanceContext();
    }

    @Override
    public final EventType getEventType() {
        return this.parent.getEventType();
    }

    @Override
    public final void update(EventBean[] newData, EventBean[] oldData) {
        this.agentInstanceContext.getAuditProvider().view(newData, oldData, this.agentInstanceContext, this.viewFactory);
        this.agentInstanceContext.getInstrumentationProvider().qViewProcessIRStream(this.viewFactory, newData, oldData);
        if (newData != null && newData.length == 1 && (oldData == null || oldData.length == 0)) {
            Object key = this.getUniqueKey(newData[0]);
            EventBean lastValue = this.mostRecentEvents.put(key, newData[0]);
            if (this.child != null) {
                EventBean[] eventBeanArray;
                if (lastValue == null) {
                    eventBeanArray = null;
                } else {
                    EventBean[] eventBeanArray2 = new EventBean[1];
                    eventBeanArray = eventBeanArray2;
                    eventBeanArray2[0] = lastValue;
                }
                EventBean[] oldDataToPost = eventBeanArray;
                this.agentInstanceContext.getInstrumentationProvider().qViewIndicate(this.viewFactory, newData, oldDataToPost);
                this.child.update(newData, oldDataToPost);
                this.agentInstanceContext.getInstrumentationProvider().aViewIndicate();
            }
        } else {
            EventBean lastValue;
            Object key;
            int i;
            OneEventCollection postOldData = null;
            if (this.child != null) {
                postOldData = new OneEventCollection();
            }
            if (newData != null) {
                for (i = 0; i < newData.length; ++i) {
                    key = this.getUniqueKey(newData[i]);
                    if (this.child == null) {
                        this.mostRecentEvents.put(key, newData[i]);
                        continue;
                    }
                    lastValue = this.mostRecentEvents.get(key);
                    if (lastValue != null) {
                        postOldData.add(lastValue);
                    }
                    this.mostRecentEvents.put(key, newData[i]);
                }
            }
            if (oldData != null) {
                for (i = 0; i < oldData.length; ++i) {
                    key = this.getUniqueKey(oldData[i]);
                    lastValue = this.mostRecentEvents.get(key);
                    if (lastValue == null || !lastValue.equals(oldData[i])) continue;
                    postOldData.add(lastValue);
                    this.mostRecentEvents.remove(key);
                }
            }
            if (this.child != null) {
                if (postOldData.isEmpty()) {
                    this.agentInstanceContext.getInstrumentationProvider().qViewIndicate(this.viewFactory, newData, null);
                    this.child.update(newData, null);
                    this.agentInstanceContext.getInstrumentationProvider().aViewIndicate();
                } else {
                    EventBean[] postOldDataArray = postOldData.toArray();
                    this.agentInstanceContext.getInstrumentationProvider().qViewIndicate(this.viewFactory, newData, postOldDataArray);
                    this.child.update(newData, postOldDataArray);
                    this.agentInstanceContext.getInstrumentationProvider().aViewIndicate();
                }
            }
        }
        this.agentInstanceContext.getInstrumentationProvider().aViewProcessIRStream();
    }

    public boolean isEmpty() {
        return this.mostRecentEvents.isEmpty();
    }

    @Override
    public final Iterator<EventBean> iterator() {
        return this.mostRecentEvents.values().iterator();
    }

    public final String toString() {
        return this.getClass().getName();
    }

    protected Object getUniqueKey(EventBean theEvent) {
        this.eventsPerStream[0] = theEvent;
        return this.viewFactory.criteriaEval.evaluate(this.eventsPerStream, true, this.agentInstanceContext);
    }

    @Override
    public void visitView(ViewDataVisitor viewDataVisitor) {
        viewDataVisitor.visitPrimary(this.mostRecentEvents, true, this.viewFactory.getViewName(), this.mostRecentEvents.size(), this.mostRecentEvents.size());
    }

    public ViewFactory getViewFactory() {
        return this.viewFactory;
    }
}

