/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.client.configuration;

import com.espertech.esper.common.client.configuration.ConfigurationException;
import com.espertech.esper.common.internal.util.ConfigurationParser;
import com.espertech.esper.common.internal.util.DOMElementIterator;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConfigurationSchema7To8Upgrade {
    public static String upgrade(InputStream inputStream, String name) throws ConfigurationException {
        Document document = ConfigurationParser.getDocument(inputStream, name);
        try {
            ConfigurationSchema7To8Upgrade.upgradeInternal(document);
            String result = ConfigurationSchema7To8Upgrade.prettyPrint(document);
            result = result.replaceAll("esper-configuration-\\d-\\d.xsd", "esper-configuration-8.0.xsd");
            return result;
        }
        catch (Throwable t) {
            throw new ConfigurationException("Failed to transform document " + name + ": " + t.getMessage(), t);
        }
    }

    private static void upgradeInternal(Document document) throws ConfigurationException {
        Element top = document.getDocumentElement();
        if (!top.getNodeName().equals("esper-configuration")) {
            throw new ConfigurationException("Expected root node 'esper-configuration'");
        }
        ConfigurationSchema7To8Upgrade.trimWhitespace(top);
        Element common = ConfigurationSchema7To8Upgrade.createIfNotFound("common", top, document);
        Element compiler = ConfigurationSchema7To8Upgrade.createIfNotFound("compiler", top, document);
        Element runtime = ConfigurationSchema7To8Upgrade.createIfNotFound("runtime", top, document);
        ConfigurationSchema7To8Upgrade.removeNodes("revision-event-type", top);
        ConfigurationSchema7To8Upgrade.removeNodes("plugin-event-representation", top);
        ConfigurationSchema7To8Upgrade.removeNodes("plugin-event-type", top);
        ConfigurationSchema7To8Upgrade.removeNodes("plugin-event-type-name-resolution", top);
        ConfigurationSchema7To8Upgrade.removeNodes("bytecodegen", top);
        ConfigurationSchema7To8Upgrade.moveNodes("event-type-auto-name", top, common);
        ConfigurationSchema7To8Upgrade.moveNodes("event-type", top, common);
        ConfigurationSchema7To8Upgrade.moveNodes("variant-stream", top, common);
        ConfigurationSchema7To8Upgrade.moveNodes("auto-import", top, common);
        ConfigurationSchema7To8Upgrade.moveNodes("auto-import-annotations", top, common);
        ConfigurationSchema7To8Upgrade.moveNodes("method-reference", top, common);
        ConfigurationSchema7To8Upgrade.moveNodes("database-reference", top, common);
        ConfigurationSchema7To8Upgrade.moveNodes("variable", top, common);
        List<Node> views = ConfigurationSchema7To8Upgrade.moveNodes("plugin-view", top, compiler);
        List<Node> vdw = ConfigurationSchema7To8Upgrade.moveNodes("plugin-virtualdw", top, compiler);
        List<Node> aggs = ConfigurationSchema7To8Upgrade.moveNodes("plugin-aggregation-function", top, compiler);
        List<Node> aggsMF = ConfigurationSchema7To8Upgrade.moveNodes("plugin-aggregation-multifunction", top, compiler);
        ConfigurationSchema7To8Upgrade.moveNodes("plugin-singlerow-function", top, compiler);
        List<Node> guards = ConfigurationSchema7To8Upgrade.moveNodes("plugin-pattern-guard", top, compiler);
        List<Node> observers = ConfigurationSchema7To8Upgrade.moveNodes("plugin-pattern-observer", top, compiler);
        ConfigurationSchema7To8Upgrade.updateAttributeName("factory-class", "forge-class", views, vdw, aggs, aggsMF, guards, observers);
        ConfigurationSchema7To8Upgrade.moveNodes("plugin-loader", top, runtime);
        ConfigurationSchema7To8Upgrade.handleSettings(top, common, compiler, runtime);
    }

    private static void updateAttributeName(String oldName, String newName, List<Node> ... nodes) {
        for (List<Node> list : nodes) {
            for (Node node : list) {
                Element element = (Element)node;
                String value = element.getAttribute(oldName);
                if (value == null) continue;
                element.removeAttribute(oldName);
                element.setAttribute(newName, value);
            }
        }
    }

    private static void handleSettings(Element top, Element common, Element compiler, Element runtime) {
        Element settings = ConfigurationSchema7To8Upgrade.findNode("engine-settings", top);
        if (settings == null) {
            return;
        }
        settings.getParentNode().removeChild(settings);
        Element defaults = ConfigurationSchema7To8Upgrade.findNode("defaults", settings);
        defaults.getParentNode().removeChild(defaults);
        DOMElementIterator iterator = new DOMElementIterator(defaults.getChildNodes());
        while (iterator.hasNext()) {
            Element element = iterator.next();
            String nodeName = element.getNodeName();
            if (nodeName.equals("event-meta")) {
                ConfigurationSchema7To8Upgrade.moveChild(element, common);
            }
            if (nodeName.equals("view-resources")) {
                ConfigurationSchema7To8Upgrade.removeNodes("share-views", element);
                ConfigurationSchema7To8Upgrade.removeNodes("allow-multiple-expiry-policy", element);
                ConfigurationSchema7To8Upgrade.moveChild(element, compiler);
            }
            if (nodeName.equals("logging")) {
                element.getParentNode().removeChild(element);
                ConfigurationSchema7To8Upgrade.cloneMove(element, "query-plan,jdbc", common);
                ConfigurationSchema7To8Upgrade.cloneMove(element, "code", compiler);
                ConfigurationSchema7To8Upgrade.cloneMove(element, "execution-path,timer-debug,audit", runtime);
            }
            if (nodeName.equals("stream-selection") || nodeName.equals("language") || nodeName.equals("scripts")) {
                ConfigurationSchema7To8Upgrade.moveChild(element, compiler);
            }
            if (nodeName.equals("time-source")) {
                element.getParentNode().removeChild(element);
                ConfigurationSchema7To8Upgrade.cloneMove(element, "time-unit", common);
                ConfigurationSchema7To8Upgrade.cloneMove(element, "time-source-type", runtime);
            }
            if (nodeName.equals("expression")) {
                element.getParentNode().removeChild(element);
                Element compilerExpr = ConfigurationSchema7To8Upgrade.cloneMove(element, "", compiler);
                Element runtimeExpr = ConfigurationSchema7To8Upgrade.cloneMove(element, "", runtime);
                ConfigurationSchema7To8Upgrade.removeAttributes(compilerExpr, "self-subselect-preeval,time-zone");
                ConfigurationSchema7To8Upgrade.removeAttributesAllBut(runtimeExpr, "self-subselect-preeval,time-zone");
            }
            if (nodeName.equals("execution")) {
                element.getParentNode().removeChild(element);
                ConfigurationSchema7To8Upgrade.removeAttributes(element, "allow-isolated-service");
                Element commonExec = ConfigurationSchema7To8Upgrade.cloneMove(element, "", common);
                Element compilerExec = ConfigurationSchema7To8Upgrade.cloneMove(element, "", compiler);
                Element runtimeExec = ConfigurationSchema7To8Upgrade.cloneMove(element, "", runtime);
                ConfigurationSchema7To8Upgrade.removeAttributesAllBut(commonExec, "threading-profile");
                ConfigurationSchema7To8Upgrade.removeAttributesAllBut(compilerExec, "filter-service-max-filter-width");
                ConfigurationSchema7To8Upgrade.removeAttributes(runtimeExec, "filter-service-max-filter-width,threading-profile");
            }
            if (!nodeName.equals("patterns") && !nodeName.equals("match-recognize") && !nodeName.equals("metrics-reporting") && !nodeName.equals("exceptionHandling") && !nodeName.equals("variables") && !nodeName.equals("threading") && !nodeName.equals("conditionHandling")) continue;
            if (nodeName.equals("threading")) {
                ConfigurationSchema7To8Upgrade.renameAttribute(element, "engine-fairlock", "runtime-fairlock");
            }
            if (nodeName.equals("metrics-reporting")) {
                ConfigurationSchema7To8Upgrade.renameAttribute(element, "engine-interval", "runtime-interval");
                ConfigurationSchema7To8Upgrade.renameAttribute(element, "jmx-engine-metrics", "jmx-runtime-metrics");
            }
            ConfigurationSchema7To8Upgrade.moveChild(element, runtime);
        }
    }

    private static void renameAttribute(Element element, String oldName, String newName) {
        String value = element.getAttribute(oldName);
        if (value == null || value.isEmpty()) {
            return;
        }
        element.removeAttribute(oldName);
        element.setAttribute(newName, value);
    }

    private static void removeAttributesAllBut(Element element, String allButCSV) {
        Set<String> names = ConfigurationSchema7To8Upgrade.toSet(allButCSV);
        NamedNodeMap attributes = element.getAttributes();
        ArrayList<String> removed = new ArrayList<String>();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node node = attributes.item(i);
            if (names.contains(node.getNodeName())) continue;
            removed.add(node.getNodeName());
        }
        for (String remove : removed) {
            attributes.removeNamedItem(remove);
        }
    }

    private static Element cloneMove(Element cloned, String allowedCSV, Element target) {
        Element clone = (Element)cloned.cloneNode(true);
        Element appended = (Element)target.appendChild(clone);
        ConfigurationSchema7To8Upgrade.removeNodesBut(allowedCSV, appended);
        return clone;
    }

    private static void moveChild(Element element, Element newParent) {
        element.getParentNode().removeChild(element);
        newParent.appendChild(element);
    }

    private static void removeAttributes(Element element, String namesCSV) {
        Set<String> names = ConfigurationSchema7To8Upgrade.toSet(namesCSV);
        for (String name : names) {
            String value = element.getAttribute(name);
            if (value == null) continue;
            element.removeAttribute(name);
        }
    }

    private static List<Node> moveNodes(String name, Element from, Element to) {
        NodeList nodes = from.getChildNodes();
        if (nodes == null || nodes.getLength() == 0) {
            return Collections.emptyList();
        }
        ArrayList<Node> moved = new ArrayList<Node>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!node.getNodeName().equals(name)) continue;
            from.removeChild(node);
            to.appendChild(node);
            moved.add(node);
        }
        return moved;
    }

    private static void removeNodes(String name, Element parent) {
        NodeList nodes = parent.getChildNodes();
        if (nodes == null || nodes.getLength() == 0) {
            return;
        }
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!node.getNodeName().equals(name)) continue;
            parent.removeChild(node);
        }
    }

    private static void removeNodesBut(String allowedCSV, Element parent) {
        Set<String> allowed = ConfigurationSchema7To8Upgrade.toSet(allowedCSV);
        NodeList nodes = parent.getChildNodes();
        if (nodes == null || nodes.getLength() == 0) {
            return;
        }
        ArrayList<Node> toRemove = new ArrayList<Node>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String name = node.getNodeName();
            if (allowed.contains(name)) continue;
            toRemove.add(node);
        }
        for (Node node : toRemove) {
            parent.removeChild(node);
        }
    }

    private static Element createIfNotFound(String name, Element parent, Document document) throws ConfigurationException {
        Element found = ConfigurationSchema7To8Upgrade.findNode(name, parent);
        if (found != null) {
            return found;
        }
        Element element = document.createElement(name);
        parent.appendChild(element);
        return element;
    }

    private static Element findNode(String name, Element parent) throws ConfigurationException {
        NodeList nodes = parent.getChildNodes();
        if (nodes == null || nodes.getLength() == 0) {
            return null;
        }
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!node.getNodeName().equals(name)) continue;
            if (!(node instanceof Element)) {
                throw new ConfigurationException("Unexpected non-element for name '" + name + "'");
            }
            return (Element)node;
        }
        return null;
    }

    private static String prettyPrint(Document document) throws ConfigurationException {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            StreamResult result = new StreamResult(new StringWriter());
            DOMSource source = new DOMSource(document);
            transformer.transform(source, result);
            return result.getWriter().toString();
        }
        catch (Throwable t) {
            throw new ConfigurationException("Failed to pretty-print document: " + t.getMessage(), t);
        }
    }

    private static void trimWhitespace(Node node) {
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() == 3) {
                child.setTextContent(child.getTextContent().trim());
            }
            ConfigurationSchema7To8Upgrade.trimWhitespace(child);
        }
    }

    private static Set<String> toSet(String csv) {
        return new HashSet<String>(Arrays.asList(csv.split(",")));
    }
}

