/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.client.configuration.common;

import com.espertech.esper.common.client.configuration.ConfigurationException;
import com.espertech.esper.common.client.configuration.common.ConfigurationCommonCache;
import com.espertech.esper.common.client.configuration.common.ConfigurationCommonCacheExpiryTime;
import com.espertech.esper.common.client.configuration.common.ConfigurationCommonCacheLRU;
import com.espertech.esper.common.client.util.CacheReferenceType;
import com.espertech.esper.common.internal.util.DatabaseTypeEnum;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class ConfigurationCommonDBRef
implements Serializable {
    private static final long serialVersionUID = 2833881768128847540L;
    private ConnectionFactoryDesc connectionFactoryDesc;
    private ConnectionSettings connectionSettings;
    private ConnectionLifecycleEnum connectionLifecycleEnum = ConnectionLifecycleEnum.RETAIN;
    private ConfigurationCommonCache dataCacheDesc;
    private MetadataOriginEnum metadataOrigin;
    private ColumnChangeCaseEnum columnChangeCase;
    private Map<Integer, String> sqlTypesMapping;

    public ConfigurationCommonDBRef() {
        this.connectionSettings = new ConnectionSettings();
        this.metadataOrigin = MetadataOriginEnum.DEFAULT;
        this.columnChangeCase = ColumnChangeCaseEnum.NONE;
        this.sqlTypesMapping = new HashMap<Integer, String>();
    }

    public void setDataSourceFactory(Properties properties, String dataSourceFactoryClassName) {
        this.connectionFactoryDesc = new DataSourceFactory(properties, dataSourceFactoryClassName);
    }

    public void setDataSourceConnection(String contextLookupName, Properties environmentProps) {
        this.connectionFactoryDesc = new DataSourceConnection(contextLookupName, environmentProps);
    }

    public void setDriverManagerConnection(String className, String url, Properties connectionArgs) {
        this.connectionFactoryDesc = new DriverManagerConnection(className, url, connectionArgs);
    }

    public void setDriverManagerConnection(String className, String url, String username, String password) {
        this.connectionFactoryDesc = new DriverManagerConnection(className, url, username, password);
    }

    public void setDriverManagerConnection(String className, String url, String username, String password, Properties connectionArgs) {
        this.connectionFactoryDesc = new DriverManagerConnection(className, url, username, password, connectionArgs);
    }

    public void setConnectionAutoCommit(boolean value) {
        this.connectionSettings.setAutoCommit(value);
    }

    public void setConnectionTransactionIsolation(int value) {
        this.connectionSettings.setTransactionIsolation(value);
    }

    public void setConnectionReadOnly(boolean isReadOnly) {
        this.connectionSettings.setReadOnly(isReadOnly);
    }

    public void setConnectionCatalog(String catalog) {
        this.connectionSettings.setCatalog(catalog);
    }

    public ConnectionSettings getConnectionSettings() {
        return this.connectionSettings;
    }

    public ConnectionLifecycleEnum getConnectionLifecycleEnum() {
        return this.connectionLifecycleEnum;
    }

    public void setConnectionLifecycleEnum(ConnectionLifecycleEnum connectionLifecycleEnum) {
        this.connectionLifecycleEnum = connectionLifecycleEnum;
    }

    public ConnectionFactoryDesc getConnectionFactoryDesc() {
        return this.connectionFactoryDesc;
    }

    public void setLRUCache(int size) {
        this.dataCacheDesc = new ConfigurationCommonCacheLRU(size);
    }

    public void setExpiryTimeCache(double maxAgeSeconds, double purgeIntervalSeconds) {
        this.dataCacheDesc = new ConfigurationCommonCacheExpiryTime(maxAgeSeconds, purgeIntervalSeconds, CacheReferenceType.getDefault());
    }

    public void setExpiryTimeCache(double maxAgeSeconds, double purgeIntervalSeconds, CacheReferenceType cacheReferenceType) {
        this.dataCacheDesc = new ConfigurationCommonCacheExpiryTime(maxAgeSeconds, purgeIntervalSeconds, cacheReferenceType);
    }

    public ConfigurationCommonCache getDataCacheDesc() {
        return this.dataCacheDesc;
    }

    public MetadataOriginEnum getMetadataRetrievalEnum() {
        return this.metadataOrigin;
    }

    public void setMetadataOrigin(MetadataOriginEnum metadataOrigin) {
        this.metadataOrigin = metadataOrigin;
    }

    public ColumnChangeCaseEnum getColumnChangeCase() {
        return this.columnChangeCase;
    }

    public void setColumnChangeCase(ColumnChangeCaseEnum columnChangeCaseEnum) {
        this.columnChangeCase = columnChangeCaseEnum;
    }

    public void addSqlTypesBinding(int sqlType, String javaTypeName) {
        DatabaseTypeEnum typeEnum = DatabaseTypeEnum.getEnum(javaTypeName);
        if (typeEnum == null) {
            String supported = Arrays.toString((Object[])DatabaseTypeEnum.values());
            throw new ConfigurationException("Unsupported java type '" + javaTypeName + "' when expecting any of: " + supported);
        }
        this.sqlTypesMapping.put(sqlType, javaTypeName);
    }

    public void addSqlTypesBinding(int sqlType, Class javaTypeName) {
        this.addSqlTypesBinding(sqlType, javaTypeName.getName());
    }

    public Map<Integer, String> getSqlTypesMapping() {
        return this.sqlTypesMapping;
    }

    public static enum ConnectionLifecycleEnum {
        RETAIN,
        POOLED;

    }

    public static class ConnectionSettings
    implements Serializable {
        private static final long serialVersionUID = 5463131581739739687L;
        private Boolean autoCommit;
        private String catalog;
        private Boolean readOnly;
        private Integer transactionIsolation;

        public Boolean getAutoCommit() {
            return this.autoCommit;
        }

        public void setAutoCommit(Boolean autoCommit) {
            this.autoCommit = autoCommit;
        }

        public String getCatalog() {
            return this.catalog;
        }

        public void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        public Boolean getReadOnly() {
            return this.readOnly;
        }

        public void setReadOnly(Boolean readOnly) {
            this.readOnly = readOnly;
        }

        public Integer getTransactionIsolation() {
            return this.transactionIsolation;
        }

        public void setTransactionIsolation(int transactionIsolation) {
            this.transactionIsolation = transactionIsolation;
        }
    }

    public static enum MetadataOriginEnum {
        DEFAULT,
        METADATA,
        SAMPLE;

    }

    public static enum ColumnChangeCaseEnum {
        NONE,
        LOWERCASE,
        UPPERCASE;

    }

    public static class DataSourceFactory
    implements ConnectionFactoryDesc,
    Serializable {
        private Properties properties;
        private String factoryClassname;
        private static final long serialVersionUID = 262880601816358807L;

        public DataSourceFactory(Properties properties, String factoryClassname) {
            this.properties = properties;
            this.factoryClassname = factoryClassname;
        }

        public Properties getProperties() {
            return this.properties;
        }

        public String getFactoryClassname() {
            return this.factoryClassname;
        }

        public void addProperty(String name, String value) {
            this.properties.put(name, value);
        }
    }

    public static interface ConnectionFactoryDesc
    extends Serializable {
    }

    public static class DataSourceConnection
    implements ConnectionFactoryDesc,
    Serializable {
        private String contextLookupName;
        private Properties envProperties;
        private static final long serialVersionUID = -3528568111362490390L;

        public DataSourceConnection(String contextLookupName, Properties envProperties) {
            this.contextLookupName = contextLookupName;
            this.envProperties = envProperties;
        }

        public String getContextLookupName() {
            return this.contextLookupName;
        }

        public Properties getEnvProperties() {
            return this.envProperties;
        }
    }

    public static class DriverManagerConnection
    implements ConnectionFactoryDesc,
    Serializable {
        private String className;
        private String url;
        private String optionalUserName;
        private String optionalPassword;
        private Properties optionalProperties;
        private static final long serialVersionUID = 9004336438099122203L;

        public DriverManagerConnection(String className, String url, Properties optionalProperties) {
            this.className = className;
            this.url = url;
            this.optionalProperties = optionalProperties;
        }

        public DriverManagerConnection(String className, String url, String optionalUserName, String optionalPassword) {
            this.className = className;
            this.url = url;
            this.optionalUserName = optionalUserName;
            this.optionalPassword = optionalPassword;
        }

        public DriverManagerConnection(String className, String url, String optionalUserName, String optionalPassword, Properties optionalProperties) {
            this.className = className;
            this.url = url;
            this.optionalUserName = optionalUserName;
            this.optionalPassword = optionalPassword;
            this.optionalProperties = optionalProperties;
        }

        public String getClassName() {
            return this.className;
        }

        public String getUrl() {
            return this.url;
        }

        public String getOptionalUserName() {
            return this.optionalUserName;
        }

        public String getOptionalPassword() {
            return this.optionalPassword;
        }

        public Properties getOptionalProperties() {
            return this.optionalProperties;
        }
    }
}

